/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.util;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class HgProjectUtils {
    private static final String ProjectTab_ID_LOGICAL = "projectTabLogical_tc";

    public static void renameProject(Project project, Object object) {
        if (project == null) {
            return;
        }
        ContextAwareAction contextAwareAction = (ContextAwareAction)CommonProjectActions.renameProjectAction();
        Lookup lookup = Lookups.singleton((Object)project);
        Action action = contextAwareAction.createContextAwareInstance(lookup);
        action.actionPerformed(new ActionEvent(object, 0, ""));
    }

    public static void openProject(Project project, Object object, boolean bl) {
        if (project == null) {
            return;
        }
        Project[] projectArray = new Project[]{project};
        OpenProjects.getDefault().open(projectArray, false);
        if (bl) {
            OpenProjects.getDefault().setMainProject(project);
        }
        HgProjectUtils.selectAndExpandProject(project);
    }

    public static void selectAndExpandProject(final Project project) {
        if (project == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){
            final ExplorerManager.Provider ptLogial = HgProjectUtils.access$000("projectTabLogical_tc");

            public void run() {
                Node node = this.ptLogial.getExplorerManager().getRootContext();
                Node node2 = node.getChildren().findChild(ProjectUtils.getInformation((Project)project).getName());
                if (node2 != null) {
                    try {
                        this.ptLogial.getExplorerManager().setSelectedNodes(new Node[]{node2});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProjectName(File file) {
        if (file == null || !file.isDirectory()) {
            return null;
        }
        ProjectManager projectManager = ProjectManager.getDefault();
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject == null || projectManager == null) {
            return null;
        }
        String string = null;
        if (projectManager.isProject(fileObject)) {
            try {
                try {
                    Project project = projectManager.findProject(fileObject);
                    string = HgProjectUtils.getProjectName(project);
                }
                catch (Exception exception) {
                    Mercurial.LOG.log(Level.FINE, "getProjectName() file: {0} {1}", new Object[]{fileObject.getPath(), exception.toString()});
                    Object var6_7 = null;
                    return string;
                }
                Object var6_6 = null;
                return string;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                return string;
            }
        }
        return string;
    }

    public static String getProjectName(Project project) {
        if (project == null) {
            return null;
        }
        ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
        return projectInformation == null ? null : projectInformation.getDisplayName();
    }

    private static synchronized ExplorerManager.Provider findDefault(String string) {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(string);
        return (ExplorerManager.Provider)topComponent;
    }

    private HgProjectUtils() {
    }

    static /* synthetic */ ExplorerManager.Provider access$000(String string) {
        return HgProjectUtils.findDefault(string);
    }
}

