/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.mercurial.ui.properties.HgPropertiesNode;
import org.netbeans.modules.mercurial.ui.properties.PropertiesTableModel;
import org.openide.util.NbBundle;

public class PropertiesTable
implements AncestorListener,
TableModelListener {
    public static final String[] PROPERTIES_COLUMNS = new String[]{"name", "value"};
    private PropertiesTableModel tableModel;
    private JTable table;
    private JComponent component;
    private String[] columns;

    public PropertiesTable(JLabel jLabel, String[] stringArray) {
        this.init(jLabel, stringArray);
    }

    private void init(JLabel jLabel, String[] stringArray) {
        this.tableModel = new PropertiesTableModel(stringArray);
        this.tableModel.addTableModelListener(this);
        this.table = new JTable(this.tableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setDefaultRenderer(String.class, new PropertiesTableCellRenderer());
        this.table.setRowHeight(this.table.getRowHeight());
        this.table.addAncestorListener(this);
        this.component = new JScrollPane(this.table, 22, 30);
        this.component.setPreferredSize(new Dimension(340, 150));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertiesTable.class, (String)"ACSD_PropertiesTable"));
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertiesTable.class, (String)"ACSN_PropertiesTable"));
        jLabel.setLabelFor(this.table);
        this.setColumns(stringArray);
    }

    public void setColumns(String[] stringArray) {
        if (Arrays.equals(this.columns, stringArray)) {
            return;
        }
        this.columns = stringArray;
        this.tableModel.setColumns(stringArray);
        this.setDefaultColumnSize();
    }

    public JTable getTable() {
        return this.table;
    }

    private void setDefaultColumnSize() {
        int n = this.table.getWidth();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        if (this.columns == null || tableColumnModel == null) {
            return;
        }
        if (tableColumnModel.getColumnCount() != this.columns.length) {
            return;
        }
        for (int i = 0; i < this.columns.length; ++i) {
            String string = this.columns[i];
            if (string.equals("name")) {
                tableColumnModel.getColumn(i).setPreferredWidth(n * 20 / 100);
                continue;
            }
            if (!string.equals("value")) continue;
            tableColumnModel.getColumn(i).setPreferredWidth(n * 40 / 100);
        }
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void dataChanged() {
        int n = this.table.getSelectedRow();
        this.tableModel.fireTableDataChanged();
        if (n != -1) {
            this.table.getSelectionModel().addSelectionInterval(n, n);
        }
    }

    public int[] getSelectedItems() {
        return this.table.getSelectedRows();
    }

    public HgPropertiesNode[] getNodes() {
        return this.tableModel.getNodes();
    }

    public void setNodes(HgPropertiesNode[] hgPropertiesNodeArray) {
        this.tableModel.setNodes(hgPropertiesNodeArray);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.setDefaultColumnSize();
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.table.repaint();
    }

    public class PropertiesTableCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl2, bl2, n, n2);
            if (component instanceof JComponent) {
                String string = PropertiesTable.this.tableModel.getNode(n).getValue();
                ((JComponent)component).setToolTipText(string);
            }
            this.setToolTipText(object.toString());
            return component;
        }
    }
}

