/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.ui.log.SearchExecutor;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class SearchCriteriaPanel
extends JPanel {
    private JLabel commitMessageLabel;
    private JLabel fromInfoLabel;
    private JLabel fromLabel;
    private JTextField tfCommitMessage;
    final JTextField tfFrom = new JTextField();
    final JTextField tfLimit = new JTextField();
    final JTextField tfTo = new JTextField();
    private JTextField tfUsername;
    private JLabel toInfoLabel;
    private JLabel toLabel;
    private JLabel toLabel1;
    private JLabel usernameLabel;

    public SearchCriteriaPanel() {
        this.initComponents();
    }

    public String getFrom() {
        String string = this.tfFrom.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public String getTo() {
        String string = this.tfTo.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public int getLimit() {
        String string = this.tfLimit.getText().trim();
        Integer n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (n <= 0) {
            n = -1;
        }
        return n;
    }

    void setForIncoming() {
        this.fromInfoLabel.setText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_FromToOutOrIncomingHint"));
        this.toInfoLabel.setText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_FromToOutOrIncomingHint"));
        this.commitMessageLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_IncomingCommitMessage"));
        this.usernameLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_IncomingUsername"));
        this.fromLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_IncomingFrom"));
        this.toLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_IncomingTo"));
        this.tfFrom.setText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TTF_IncomingFrom"));
        this.tfFrom.setEnabled(false);
        this.tfLimit.setEnabled(false);
    }

    void setForOut() {
        this.fromInfoLabel.setText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_FromToOutOrIncomingHint"));
        this.toInfoLabel.setText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_FromToOutOrIncomingHint"));
        this.commitMessageLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_OutCommitMessage"));
        this.usernameLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_OutUsername"));
        this.fromLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_OutFrom"));
        this.toLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_OutTo"));
        this.tfFrom.setText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TTF_OutFrom"));
        this.tfFrom.setEnabled(false);
        this.tfLimit.setEnabled(false);
    }

    private Date parseDate(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < SearchExecutor.dateFormats.length; ++i) {
            DateFormat dateFormat = SearchExecutor.dateFormats[i];
            try {
                return dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return null;
    }

    public String getCommitMessage() {
        String string = this.tfCommitMessage.getText().trim();
        return string.length() > 0 ? string : null;
    }

    public String getUsername() {
        String string = this.tfUsername.getText().trim();
        return string.length() > 0 ? string : null;
    }

    public void setFrom(String string) {
        if (string == null) {
            string = "";
        }
        this.tfFrom.setText(string);
    }

    public void setTo(String string) {
        if (string == null) {
            string = "";
        }
        this.tfTo.setText(string);
    }

    public void setCommitMessage(String string) {
        if (string == null) {
            string = "";
        }
        this.tfCommitMessage.setText(string);
    }

    public void setUsername(String string) {
        if (string == null) {
            string = "";
        }
        this.tfUsername.setText(string);
    }

    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchCriteriaPanel.this.tfCommitMessage.requestFocusInWindow();
            }
        });
    }

    private void initComponents() {
        this.commitMessageLabel = new JLabel();
        this.tfCommitMessage = new JTextField();
        this.usernameLabel = new JLabel();
        this.tfUsername = new JTextField();
        this.fromLabel = new JLabel();
        this.fromInfoLabel = new JLabel();
        this.toLabel = new JLabel();
        this.toInfoLabel = new JLabel();
        this.toLabel1 = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(8, 12, 0, 11));
        this.setLayout(new GridBagLayout());
        this.commitMessageLabel.setLabelFor(this.tfCommitMessage);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/mercurial/ui/log/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.commitMessageLabel, (String)resourceBundle.getString("CTL_UseCommitMessage"));
        this.commitMessageLabel.setToolTipText(resourceBundle.getString("TT_CommitMessage"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        this.add((Component)this.commitMessageLabel, gridBagConstraints);
        this.commitMessageLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_UseCommitMessage"));
        this.tfCommitMessage.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.tfCommitMessage, gridBagConstraints);
        this.usernameLabel.setLabelFor(this.tfUsername);
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)resourceBundle.getString("CTL_UseUsername"));
        this.usernameLabel.setToolTipText(resourceBundle.getString("TT_Username"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.usernameLabel, gridBagConstraints);
        this.tfUsername.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 4, 0, 0);
        this.add((Component)this.tfUsername, gridBagConstraints);
        this.fromLabel.setLabelFor(this.tfFrom);
        Mnemonics.setLocalizedText((JLabel)this.fromLabel, (String)resourceBundle.getString("CTL_UseFrom"));
        this.fromLabel.setToolTipText(resourceBundle.getString("TT_From"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.fromLabel, gridBagConstraints);
        this.tfFrom.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.tfFrom, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.fromInfoLabel, (String)resourceBundle.getString("CTL_FromToHint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 4);
        this.add((Component)this.fromInfoLabel, gridBagConstraints);
        this.toLabel.setLabelFor(this.tfTo);
        Mnemonics.setLocalizedText((JLabel)this.toLabel, (String)resourceBundle.getString("CTL_UseTo"));
        this.toLabel.setToolTipText(resourceBundle.getString("TT_To"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.toLabel, gridBagConstraints);
        this.tfTo.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.tfTo, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.toInfoLabel, (String)resourceBundle.getString("CTL_FromToHint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(3, 2, 0, 4);
        this.add((Component)this.toInfoLabel, gridBagConstraints);
        this.toLabel1.setLabelFor(this.tfLimit);
        Mnemonics.setLocalizedText((JLabel)this.toLabel1, (String)resourceBundle.getString("CTL_UseLimit"));
        this.toLabel1.setToolTipText(resourceBundle.getString("TT_Limit"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.toLabel1, gridBagConstraints);
        this.tfLimit.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.tfLimit, gridBagConstraints);
    }
}

