/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import java.util.ResourceBundle;
import org.netbeans.modules.mercurial.FileStatus;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_NOTVERSIONED_NOTMANAGED = 1;
    public static final int STATUS_NOTVERSIONED_EXCLUDED = 2;
    public static final int STATUS_NOTVERSIONED_NEWLOCALLY = 4;
    public static final int STATUS_VERSIONED_UPTODATE = 8;
    public static final int STATUS_VERSIONED_MODIFIEDLOCALLY = 16;
    public static final int STATUS_VERSIONED_MODIFIEDINREPOSITORY = 32;
    public static final int STATUS_VERSIONED_CONFLICT = 64;
    public static final int STATUS_VERSIONED_MERGE = 128;
    public static final int STATUS_VERSIONED_REMOVEDLOCALLY = 256;
    public static final int STATUS_VERSIONED_NEWINREPOSITORY = 512;
    public static final int STATUS_VERSIONED_REMOVEDINREPOSITORY = 1024;
    public static final int STATUS_VERSIONED_DELETEDLOCALLY = 2048;
    public static final int STATUS_VERSIONED_ADDEDLOCALLY = 4096;
    public static final int STATUS_ALL = -1;
    public static final int STATUS_MANAGED = -2;
    public static final int STATUS_VERSIONED = 7672;
    public static final int STATUS_IN_REPOSITORY = 4088;
    public static final int STATUS_LOCAL_CHANGE = 6612;
    public static final int STATUS_REVERTIBLE_CHANGE = 6608;
    public static final int STATUS_REMOTE_CHANGE = 1696;
    private final int status;
    private transient FileStatus entry;
    private final boolean isDirectory;
    private final HashSet<File> modifiedChildren = new HashSet();
    private final HashSet<File> conflictedChildren = new HashSet();

    public FileInformation() {
        this.status = 0;
        this.isDirectory = false;
    }

    public FileInformation(int n, FileStatus fileStatus, boolean bl) {
        this.status = n;
        this.entry = fileStatus;
        this.isDirectory = bl;
    }

    FileInformation(int n, boolean bl) {
        this(n, null, bl);
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public FileStatus getStatus(File file) {
        return this.entry;
    }

    public String getStatusText() {
        return this.getStatusText(-1);
    }

    public String getStatusText(int n) {
        int n2 = this.status & n;
        ResourceBundle resourceBundle = NbBundle.getBundle(FileInformation.class);
        if (n2 == 0) {
            return resourceBundle.getString("CTL_FileInfoStatus_Unknown");
        }
        if (FileInformation.match(n2, 2)) {
            return resourceBundle.getString("CTL_FileInfoStatus_Excluded");
        }
        if (FileInformation.match(n2, 4)) {
            return resourceBundle.getString("CTL_FileInfoStatus_NewLocally");
        }
        if (FileInformation.match(n2, 4096)) {
            if (this.entry != null && this.entry.isCopied()) {
                return resourceBundle.getString("CTL_FileInfoStatus_AddedLocallyCopied");
            }
            return resourceBundle.getString("CTL_FileInfoStatus_AddedLocally");
        }
        if (FileInformation.match(n2, 8)) {
            return resourceBundle.getString("CTL_FileInfoStatus_UpToDate");
        }
        if (FileInformation.match(n2, 64)) {
            return resourceBundle.getString("CTL_FileInfoStatus_Conflict");
        }
        if (FileInformation.match(n2, 128)) {
            return resourceBundle.getString("CTL_FileInfoStatus_Merge");
        }
        if (FileInformation.match(n2, 2048)) {
            return resourceBundle.getString("CTL_FileInfoStatus_DeletedLocally");
        }
        if (FileInformation.match(n2, 256)) {
            return resourceBundle.getString("CTL_FileInfoStatus_RemovedLocally");
        }
        if (FileInformation.match(n2, 16)) {
            return resourceBundle.getString("CTL_FileInfoStatus_ModifiedLocally");
        }
        if (FileInformation.match(n2, 512)) {
            return resourceBundle.getString("CTL_FileInfoStatus_NewInRepository");
        }
        if (FileInformation.match(n2, 32)) {
            return resourceBundle.getString("CTL_FileInfoStatus_ModifiedInRepository");
        }
        if (FileInformation.match(n2, 1024)) {
            return resourceBundle.getString("CTL_FileInfoStatus_RemovedInRepository");
        }
        return "";
    }

    public String getShortStatusText() {
        ResourceBundle resourceBundle = NbBundle.getBundle(FileInformation.class);
        if (FileInformation.match(this.status, 2)) {
            return resourceBundle.getString("CTL_FileInfoStatus_Excluded_Short");
        }
        if (FileInformation.match(this.status, 4)) {
            return resourceBundle.getString("CTL_FileInfoStatus_NewLocally_Short");
        }
        if (FileInformation.match(this.status, 4096)) {
            if (this.entry != null && this.entry.isCopied()) {
                return resourceBundle.getString("CTL_FileInfoStatus_AddedLocallyCopied_Short");
            }
            return resourceBundle.getString("CTL_FileInfoStatus_AddedLocally_Short");
        }
        if (this.status == 256) {
            return resourceBundle.getString("CTL_FileInfoStatus_RemovedLocally_Short");
        }
        if (this.status == 2048) {
            return resourceBundle.getString("CTL_FileInfoStatus_DeletedLocally_Short");
        }
        if (FileInformation.match(this.status, 16)) {
            return resourceBundle.getString("CTL_FileInfoStatus_ModifiedLocally_Short");
        }
        if (FileInformation.match(this.status, 64)) {
            return resourceBundle.getString("CTL_FileInfoStatus_Conflict_Short");
        }
        return "";
    }

    private static boolean match(int n, int n2) {
        return (n & n2) != 0;
    }

    public String toString() {
        return "Text: " + this.status + " " + this.getStatusText(this.status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashSet<File> getModifiedChildren(boolean bl) {
        HashSet<File> hashSet;
        HashSet<File> hashSet2 = this.modifiedChildren;
        synchronized (hashSet2) {
            hashSet = bl ? new HashSet<File>(this.conflictedChildren) : new HashSet<File>(this.modifiedChildren);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setModifiedChild(File file, FileInformation fileInformation) {
        if ((this.status & 1) != 0) {
            return false;
        }
        HashSet<File> hashSet = this.modifiedChildren;
        synchronized (hashSet) {
            this.modifiedChildren.remove(file);
            this.conflictedChildren.remove(file);
            boolean bl = this.modifiedChildren.isEmpty();
            if (fileInformation.getStatus() != 0 && (fileInformation.getStatus() & 8) == 0) {
                boolean bl2 = false;
                if (!$assertionsDisabled) {
                    bl2 = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (bl2 && this.modifiedChildren.size() > 0) {
                    File file2 = this.modifiedChildren.iterator().next();
                    if (!file.getParentFile().equals(file2.getParentFile())) {
                        throw new IllegalStateException("Adding " + file.getAbsolutePath() + ", already added " + file2.getAbsolutePath() + " under " + file2.getParentFile().getAbsolutePath());
                    }
                }
                this.modifiedChildren.add(file);
                if ((fileInformation.getStatus() & 0x40) != 0) {
                    this.conflictedChildren.add(file);
                }
                bl = true;
            }
            return bl;
        }
    }
}

