/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.modules.project.rake;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.modules.project.rake.Util;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeBasedProjectType;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectState;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RakeBasedProjectFactorySingleton
implements ProjectFactory {
    public static final String PROJECT_XML_PATH = "nbproject/project.xml";
    public static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    private static final Map<Project, Reference<RakeProjectHelper>> project2Helper;
    private static final Map<RakeProjectHelper, Reference<Project>> helper2Project;
    private static final Map<RakeBasedProjectType, List<Reference<RakeProjectHelper>>> type2Projects;
    private static final Lookup.Result<RakeBasedProjectType> antBasedProjectTypes;
    private static Map<String, RakeBasedProjectType> antBasedProjectTypesByType;
    public static RakeProjectHelperCallback HELPER_CALLBACK;

    private static void antBasedProjectTypesRemoved(Set<RakeBasedProjectType> set) {
        for (RakeBasedProjectType rakeBasedProjectType : set) {
            List<Reference<RakeProjectHelper>> list = type2Projects.get(rakeBasedProjectType);
            if (list != null) {
                for (Reference<RakeProjectHelper> reference : list) {
                    RakeProjectHelper rakeProjectHelper = reference.get();
                    if (rakeProjectHelper == null) continue;
                    rakeProjectHelper.notifyDeleted();
                }
            }
            type2Projects.remove(rakeBasedProjectType);
        }
    }

    private static synchronized RakeBasedProjectType findRakeBasedProjectType(String string) {
        if (antBasedProjectTypesByType == null) {
            antBasedProjectTypesByType = new HashMap<String, RakeBasedProjectType>();
            for (RakeBasedProjectType rakeBasedProjectType : antBasedProjectTypes.allInstances()) {
                antBasedProjectTypesByType.put(rakeBasedProjectType.getType(), rakeBasedProjectType);
            }
        }
        return antBasedProjectTypesByType.get(string);
    }

    public boolean isProject(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return false;
        }
        File file2 = new File(new File(file, "nbproject"), "project.xml");
        return file2.isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project loadProject(FileObject fileObject, ProjectState projectState) throws IOException {
        Document document;
        if (FileUtil.toFile((FileObject)fileObject) == null) {
            return null;
        }
        FileObject fileObject2 = fileObject.getFileObject(PROJECT_XML_PATH);
        if (fileObject2 == null || !fileObject2.isData() || fileObject2.isVirtual()) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject2);
        if (file == null) {
            return null;
        }
        try {
            document = XMLUtil.parse((InputSource)new InputSource(file.toURI().toString()), (boolean)false, (boolean)true, (ErrorHandler)Util.defaultErrorHandler(), null);
        }
        catch (SAXException sAXException) {
            IOException iOException = (IOException)new IOException(file + ": " + sAXException.toString()).initCause(sAXException);
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(RakeBasedProjectFactorySingleton.class, (String)"RakeBasedProjectFactorySingleton.parseError", (Object)file.getAbsolutePath(), (Object)sAXException.getMessage()));
            throw iOException;
        }
        Element element = document.getDocumentElement();
        if (!"project".equals(element.getLocalName()) || !PROJECT_NS.equals(element.getNamespaceURI())) {
            return null;
        }
        Element element2 = Util.findElement(element, "type", PROJECT_NS);
        if (element2 == null) {
            return null;
        }
        String string = Util.findText(element2);
        if (string == null) {
            return null;
        }
        RakeBasedProjectType rakeBasedProjectType = RakeBasedProjectFactorySingleton.findRakeBasedProjectType(string);
        if (rakeBasedProjectType == null) {
            return null;
        }
        RakeProjectHelper rakeProjectHelper = HELPER_CALLBACK.createHelper(fileObject, document, projectState, rakeBasedProjectType);
        Project project = rakeBasedProjectType.createProject(rakeProjectHelper);
        project2Helper.put(project, new WeakReference<RakeProjectHelper>(rakeProjectHelper));
        ArrayList<WeakReference<RakeProjectHelper>> arrayList = helper2Project;
        synchronized (arrayList) {
            helper2Project.put(rakeProjectHelper, new WeakReference<Project>(project));
        }
        arrayList = type2Projects.get(rakeBasedProjectType);
        if (arrayList == null) {
            arrayList = new ArrayList<WeakReference<RakeProjectHelper>>();
            type2Projects.put(rakeBasedProjectType, arrayList);
        }
        arrayList.add(new WeakReference<RakeProjectHelper>(rakeProjectHelper));
        return project;
    }

    public void saveProject(Project project) throws IOException, ClassCastException {
        Reference<RakeProjectHelper> reference = project2Helper.get(project);
        if (reference == null) {
            throw new ClassCastException(project.getClass().getName());
        }
        RakeProjectHelper rakeProjectHelper = reference.get();
        assert (rakeProjectHelper != null) : "RakeProjectHelper collected for " + project;
        HELPER_CALLBACK.save(rakeProjectHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Project getProjectFor(RakeProjectHelper rakeProjectHelper) {
        Reference<Project> reference;
        Project project = helper2Project;
        synchronized (project) {
            reference = helper2Project.get(rakeProjectHelper);
        }
        assert (reference != null) : "Expecting a Project reference for " + rakeProjectHelper;
        project = reference.get();
        assert (project != null) : "Expecting a non-null Project for " + rakeProjectHelper;
        return project;
    }

    public static RakeProjectHelper getHelperFor(Project project) {
        Reference<RakeProjectHelper> reference = project2Helper.get(project);
        return reference != null ? reference.get() : null;
    }

    static {
        block3: {
            project2Helper = new WeakHashMap<Project, Reference<RakeProjectHelper>>();
            helper2Project = new WeakHashMap<RakeProjectHelper, Reference<Project>>();
            type2Projects = new HashMap<RakeBasedProjectType, List<Reference<RakeProjectHelper>>>();
            antBasedProjectTypesByType = null;
            antBasedProjectTypes = Lookup.getDefault().lookupResult(RakeBasedProjectType.class);
            antBasedProjectTypes.addLookupListener(new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent lookupEvent) {
                    Class<RakeBasedProjectFactorySingleton> clazz = RakeBasedProjectFactorySingleton.class;
                    synchronized (RakeBasedProjectFactorySingleton.class) {
                        Set set = type2Projects.keySet();
                        HashSet hashSet = new HashSet(set);
                        hashSet.removeAll(antBasedProjectTypes.allInstances());
                        RakeBasedProjectFactorySingleton.antBasedProjectTypesRemoved(hashSet);
                        antBasedProjectTypesByType = null;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
            Class<RakeProjectHelper> clazz = RakeProjectHelper.class;
            try {
                Class.forName(clazz.getName(), true, clazz.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)classNotFoundException);
            }
        }
        assert (HELPER_CALLBACK != null);
    }

    public static interface RakeProjectHelperCallback {
        public RakeProjectHelper createHelper(FileObject var1, Document var2, ProjectState var3, RakeBasedProjectType var4);

        public void save(RakeProjectHelper var1) throws IOException;
    }
}

