/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.websvc.design.view.widget.ButtonWidget;
import org.netbeans.modules.websvc.design.view.widget.ImageLabelWidget;

public class CheckBoxWidget
extends ButtonWidget {
    public static final String ACTION_COMMAND_SELECTED = "toggle-button-selected";
    public static final String ACTION_COMMAND_DESELECTED = "toggle-button-deselected";

    public CheckBoxWidget(Scene scene, String string) {
        super(scene, null, string);
        this.setImage(new UncheckedImageWidget(scene, 8));
        this.setSelectedImage((Object)new CheckedImageWidget(scene, 8));
        this.setBorder(BorderFactory.createEmptyBorder((int)1));
    }

    public void performAction() {
        this.setSelected(!this.isSelected());
        super.performAction();
    }

    public String getActionCommand() {
        return this.isSelected() ? ACTION_COMMAND_SELECTED : ACTION_COMMAND_DESELECTED;
    }

    protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
        if (objectState.isFocused() != objectState2.isFocused()) {
            this.setBorder(objectState2.isFocused() ? BorderFactory.createDashedBorder((Color)BORDER_COLOR, (int)2, (int)2, (boolean)true) : BorderFactory.createEmptyBorder((int)1));
        }
        super.notifyStateChanged(objectState, objectState2);
    }

    private static class UncheckedImageWidget
    extends ImageLabelWidget.PaintableImageWidget {
        public UncheckedImageWidget(Scene scene, int n) {
            super(scene, Color.LIGHT_GRAY, n, n);
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createLineBorder((int)1, (Color)Color.GRAY));
            this.setOpaque(true);
        }

        protected Shape createImage(int n, int n2) {
            return new Rectangle2D.Double(0.0, 0.0, n - 2, n2 - 2);
        }
    }

    private static class CheckedImageWidget
    extends ImageLabelWidget.PaintableImageWidget {
        public CheckedImageWidget(Scene scene, int n) {
            super(scene, Color.LIGHT_GRAY, n, n);
            this.setBackground(Color.GRAY);
            this.setBorder(BorderFactory.createLineBorder((int)1, (Color)Color.GRAY));
            this.setOpaque(true);
        }

        protected Shape createImage(int n, int n2) {
            return new Rectangle2D.Double(0.0, 0.0, n - 2, n2 - 2);
        }
    }
}

