/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.configuration;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.modules.websvc.design.configuration.WSConfigurationProvider;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSConfigurationProviderRegistry {
    static WSConfigurationProviderRegistry registry = new WSConfigurationProviderRegistry();
    private Set<WSConfigurationProvider> providers = new LinkedHashSet<WSConfigurationProvider>();

    private WSConfigurationProviderRegistry() {
    }

    public static WSConfigurationProviderRegistry getDefault() {
        return registry;
    }

    public void register(WSConfigurationProvider wSConfigurationProvider) {
        this.providers.add(wSConfigurationProvider);
    }

    public void unregister(WSConfigurationProvider wSConfigurationProvider) {
        this.providers.remove(wSConfigurationProvider);
    }

    public Set<WSConfigurationProvider> getWSConfigurationProviders() {
        this.populateRegistry();
        return this.providers;
    }

    private void populateRegistry() {
        if (this.providers.isEmpty()) {
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(WSConfigurationProvider.class));
            Collection collection = result.allInstances();
            for (WSConfigurationProvider wSConfigurationProvider : collection) {
                this.register(wSConfigurationProvider);
            }
        }
    }
}

