/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.antext.preprocessor;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.netbeans.mobility.antext.preprocessor.LineParser;
import org.netbeans.mobility.antext.preprocessor.PPBlockInfo;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.mobility.antext.preprocessor.PPToken;
import org.netbeans.mobility.antext.preprocessor.PreprocessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommentingPreProcessor
implements Runnable {
    static final String DEFAULT_COMMENT = "//# ";
    private final Source src;
    private final Destination dest;
    private final Stack<PPBlockInfo> stack;
    private final AbilitiesEvaluator eval;
    private final ArrayList<PPBlockInfo> blockList;
    private final ArrayList<PPLine> lines;
    private PPLine line;
    private LineParser lp;
    protected PPBlockInfo stackTop;

    public CommentingPreProcessor(Source source, Destination destination, String string) {
        this(source, destination, CommentingPreProcessor.decodeAbilitiesMap(string));
    }

    public CommentingPreProcessor(Source source, Destination destination, Map<String, String> map) {
        this.src = source;
        this.dest = destination;
        this.blockList = new ArrayList();
        this.lines = new ArrayList();
        this.stack = new Stack();
        this.stackTop = null;
        this.eval = new MapEvaluator(map);
        this.line = null;
    }

    public ArrayList<PPLine> getLines() {
        return this.lines;
    }

    public ArrayList<PPBlockInfo> getBlockList() {
        return this.blockList;
    }

    @Override
    public void run() {
        Exception exception = null;
        Reader reader = null;
        try {
            reader = this.src.createReader();
            this.parse(reader);
        }
        catch (Exception exception2) {
            while (this.lp.hasMoreLines()) {
                this.lines.add(this.lp.nextLine());
            }
            exception = exception2;
        }
        Writer writer = null;
        if (this.dest != null) {
            try {
                writer = this.dest.createWriter(exception == null && !this.hasErrors() && this.conditionIsTrue());
                this.writeOutput(writer);
            }
            catch (IOException iOException) {
                throw new PreprocessorException("IOException during write", iOException);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        throw new PreprocessorException("IOException during source reader close", iOException);
                    }
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {
                        throw new PreprocessorException("IOException during detination writer close/flush", iOException);
                    }
                }
            }
        }
        if (exception != null) {
            if (exception instanceof PreprocessorException) {
                exception.fillInStackTrace();
                throw (PreprocessorException)exception;
            }
            throw new PreprocessorException("Critical Preprocessor Exception", exception);
        }
    }

    private void parse(Reader reader) {
        this.lp = new LineParser(reader, this.eval);
        while (this.lp.hasMoreLines()) {
            this.line = this.lp.nextLine();
            this.lines.add(this.line);
            boolean bl = this.debugOnTop();
            switch (this.line.getType()) {
                case 0: 
                case 2: 
                case 3: 
                case 8: 
                case 9: 
                case 13: 
                case 17: {
                    this.push(new PPBlockInfo(this.stackTop, this.line, this.line.hasValue(), this.line.getValue(), null));
                    this.line.setBlock(this.stackTop);
                    break;
                }
                case 1: {
                    this.line.setBlock(this.stackTop);
                    if (this.stackTop != null && this.stackTop.getType() != 13 && this.stackTop.getType() != 9) {
                        this.pop(true);
                        break;
                    }
                    this.line.addError("ERR_redundant_endif");
                    break;
                }
                case 14: {
                    this.line.setBlock(this.stackTop);
                    if (this.stackTop != null && this.stackTop.getType() == 13) {
                        this.pop(true);
                        break;
                    }
                    this.line.addError("ERR_redundant_old_block_end");
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (this.stackTop != null && this.stackTop.getType() != 13 && this.stackTop.getType() != 9 && this.stackTop.getType() != 4) {
                        PPBlockInfo pPBlockInfo = this.stackTop;
                        this.pop(false);
                        this.push(new PPBlockInfo(this.stackTop, this.line, this.line.hasValue(), this.line.getValue(), pPBlockInfo));
                    } else {
                        this.line.addError("ERR_redundant_else");
                    }
                    this.line.setBlock(this.stackTop);
                    break;
                }
                case 10: {
                    this.line.setBlock(this.stackTop);
                    if (this.stackTop != null && this.stackTop.getType() == 9) {
                        this.pop(true);
                        break;
                    }
                    this.line.addError("ERR_redundant_enddebug");
                    break;
                }
                default: {
                    this.line.setBlock(this.stackTop);
                }
            }
            if (!bl || !this.debugOnTop()) continue;
            this.pop(true);
        }
        while (this.stackTop != null) {
            if (this.stackTop.getType() != 17) {
                this.stackTop.addError("ERR_unterminated_block");
            }
            this.pop(false);
        }
    }

    private void writeOutput(Writer writer) throws IOException {
        for (PPLine pPLine : this.lines) {
            PPToken pPToken;
            Iterator<PPToken> iterator = pPLine.getTokens().iterator();
            PPBlockInfo pPBlockInfo = pPLine.getBlock();
            if (pPBlockInfo == null || pPBlockInfo.isToBeCommented()) {
                if (pPBlockInfo == null || pPBlockInfo.isActive()) {
                    if (pPLine.getType() == 15) {
                        pPToken = iterator.next();
                        if (pPBlockInfo == null && "//--".equals(pPToken.getText())) {
                            if (writer != null) {
                                writer.write(pPToken.getText());
                            }
                        } else {
                            this.dest.doRemove(pPToken.getLine(), pPToken.getColumn(), pPToken.getText().length());
                        }
                    }
                } else if (pPLine.getType() == 16) {
                    this.dest.doInsert(pPLine.getLineNumber(), DEFAULT_COMMENT);
                    if (writer != null) {
                        writer.write(DEFAULT_COMMENT);
                    }
                }
            }
            if (writer == null) continue;
            while (iterator.hasNext()) {
                pPToken = iterator.next();
                writer.write(pPToken.getPadding());
                writer.write(pPToken.getText());
            }
        }
    }

    private void push(PPBlockInfo pPBlockInfo) {
        this.blockList.add(pPBlockInfo);
        this.stack.push(this.stackTop);
        this.stackTop = pPBlockInfo;
    }

    private void pop(boolean bl) {
        if (this.stack.isEmpty()) {
            this.stackTop = null;
        } else {
            this.stackTop.setEndLine(this.line.getLineNumber() - (bl ? 0 : 1));
            this.stackTop.setHasFooter(bl);
            this.stackTop = this.stack.pop();
            if (this.debugOnTop()) {
                this.pop(false);
            }
        }
    }

    private boolean hasErrors() {
        for (PPLine pPLine : this.lines) {
            if (!pPLine.hasErrors()) continue;
            return true;
        }
        return false;
    }

    private boolean conditionIsTrue() {
        if (this.lines.size() == 0) {
            return true;
        }
        PPLine pPLine = this.lines.get(0);
        return pPLine.getType() != 17 || !pPLine.hasValue() || pPLine.getValue();
    }

    private boolean debugOnTop() {
        return this.stackTop != null && this.stackTop.getType() == 8;
    }

    public static String encodeAbilitiesMap(Map<String, String> map) {
        StringBuffer stringBuffer = new StringBuffer();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(entry.getKey());
                String string = entry.getValue();
                if (string == null) continue;
                stringBuffer.append('=');
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '\\' || c == ',') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static Map<String, String> decodeAbilitiesMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            String string2 = null;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (string2 == null) {
                    if (c == '=') {
                        string2 = stringBuffer.toString();
                        stringBuffer.setLength(0);
                        continue;
                    }
                    if (c == ',') {
                        hashMap.put(stringBuffer.toString(), null);
                        stringBuffer.setLength(0);
                        continue;
                    }
                    stringBuffer.append(c);
                    continue;
                }
                if (bl) {
                    if (c != '\\' && c != ',') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                    bl = false;
                    continue;
                }
                if (c == '\\') {
                    bl = true;
                    continue;
                }
                if (c == ',') {
                    hashMap.put(string2, stringBuffer.toString());
                    string2 = null;
                    stringBuffer.setLength(0);
                    continue;
                }
                stringBuffer.append(c);
            }
            if (bl) {
                stringBuffer.append('\\');
            }
            if (string2 == null) {
                hashMap.put(stringBuffer.toString(), null);
            } else {
                hashMap.put(string2, stringBuffer.toString());
            }
        }
        hashMap.remove("");
        return hashMap;
    }

    public static void main(final String[] stringArray) throws Exception {
        new CommentingPreProcessor(new Source(){

            public Reader createReader() throws IOException {
                return new FileReader(stringArray[0]);
            }
        }, new Destination(){

            public void doInsert(int n, String string) throws IOException {
                System.err.print(String.valueOf(n) + "+, ");
            }

            public void doRemove(int n, int n2, int n3) throws IOException {
                System.err.print(String.valueOf(n) + "-, ");
            }

            public Writer createWriter(boolean bl) throws IOException {
                return new StringWriter();
            }
        }, Collections.singletonMap("aaa", null)).run();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapEvaluator
    extends HashMap<String, String>
    implements AbilitiesEvaluator {
        public MapEvaluator() {
        }

        public MapEvaluator(Map<String, String> map) {
            super(map);
        }

        @Override
        public boolean isAbilityDefined(String string) {
            return this.containsKey(string);
        }

        @Override
        public String getAbilityValue(String string) {
            return (String)this.get(string);
        }

        @Override
        public void requestDefineAbility(String string, String string2) {
            if (!(CommentingPreProcessor.this.stackTop != null && CommentingPreProcessor.this.stackTop.isToBeCommented() && !CommentingPreProcessor.this.stackTop.isActive() || this.containsKey(string))) {
                this.put(string, string2);
            }
        }

        @Override
        public void requestUndefineAbility(String string) {
            if (CommentingPreProcessor.this.stackTop == null || !CommentingPreProcessor.this.stackTop.isToBeCommented() || CommentingPreProcessor.this.stackTop.isActive()) {
                this.remove(string);
            }
        }
    }

    public static interface Destination {
        public Writer createWriter(boolean var1) throws IOException;

        public void doInsert(int var1, String var2) throws IOException;

        public void doRemove(int var1, int var2, int var3) throws IOException;
    }

    public static interface Source {
        public Reader createReader() throws IOException;
    }

    public static interface AbilitiesEvaluator {
        public boolean isAbilityDefined(String var1);

        public String getAbilityValue(String var1);

        public void requestDefineAbility(String var1, String var2);

        public void requestUndefineAbility(String var1);
    }
}

