/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CompilationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyFinder
extends TreePathScanner<Boolean, TreePath> {
    private final TreePath searchingFor;
    private final CompilationInfo info;
    private final List<TreePath> result = new LinkedList<TreePath>();
    private boolean allowGoDeeper = true;
    private AtomicBoolean cancel;

    private CopyFinder(TreePath treePath, CompilationInfo compilationInfo, AtomicBoolean atomicBoolean) {
        this.searchingFor = treePath;
        this.info = compilationInfo;
        this.cancel = atomicBoolean;
    }

    public static List<TreePath> computeDuplicates(CompilationInfo compilationInfo, TreePath treePath, TreePath treePath2, AtomicBoolean atomicBoolean) {
        CopyFinder copyFinder = new CopyFinder(treePath, compilationInfo, atomicBoolean);
        copyFinder.scan(treePath2, null);
        return copyFinder.result;
    }

    public static boolean isDuplicate(CompilationInfo compilationInfo, TreePath treePath, TreePath treePath2, AtomicBoolean atomicBoolean) {
        if (treePath.getLeaf().getKind() != treePath2.getLeaf().getKind()) {
            return false;
        }
        CopyFinder copyFinder = new CopyFinder(treePath, compilationInfo, atomicBoolean);
        copyFinder.allowGoDeeper = false;
        return (Boolean)copyFinder.scan(treePath2, treePath);
    }

    @Override
    public Boolean scan(Tree tree, TreePath treePath) {
        boolean bl;
        if (this.cancel.get()) {
            return false;
        }
        if (tree == null) {
            return treePath == null;
        }
        if (treePath != null && tree.getKind() == treePath.getLeaf().getKind()) {
            boolean bl2 = bl = super.scan(tree, treePath) == Boolean.TRUE;
            if (bl) {
                if (treePath == this.searchingFor && tree != this.searchingFor) {
                    this.result.add(new TreePath(this.getCurrentPath(), tree));
                }
                return true;
            }
        }
        if (!this.allowGoDeeper) {
            return false;
        }
        if (treePath != null && treePath.getLeaf() == this.searchingFor.getLeaf() || tree.getKind() != this.searchingFor.getLeaf().getKind()) {
            super.scan(tree, null);
            return false;
        }
        this.allowGoDeeper = false;
        bl = super.scan(tree, this.searchingFor) == Boolean.TRUE;
        this.allowGoDeeper = true;
        if (bl) {
            if (tree != this.searchingFor.getLeaf()) {
                this.result.add(new TreePath(this.getCurrentPath(), tree));
            }
            return true;
        }
        super.scan(tree, null);
        return false;
    }

    private Boolean scan(Tree tree, Tree tree2, TreePath treePath) {
        if (tree == null || tree2 == null) {
            return tree == tree2;
        }
        return this.scan(tree, new TreePath(treePath, tree2));
    }

    @Override
    public Boolean visitMethodInvocation(MethodInvocationTree methodInvocationTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitMethodInvocation(methodInvocationTree, treePath);
        }
        MethodInvocationTree methodInvocationTree2 = (MethodInvocationTree)treePath.getLeaf();
        if (!this.scan(methodInvocationTree.getMethodSelect(), methodInvocationTree2.getMethodSelect(), treePath).booleanValue()) {
            return false;
        }
        if (!this.checkLists(methodInvocationTree.getTypeArguments(), methodInvocationTree2.getTypeArguments(), treePath)) {
            return false;
        }
        return this.checkLists(methodInvocationTree.getArguments(), methodInvocationTree2.getArguments(), treePath);
    }

    private <T extends Tree> boolean checkLists(List<? extends T> list, List<? extends T> list2, TreePath treePath) {
        if (list == null || list2 == null) {
            return list == list2;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (this.scan((Tree)list.get(i), (Tree)list2.get(i), treePath).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitAssignment(AssignmentTree assignmentTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitAssignment(assignmentTree, treePath);
        }
        AssignmentTree assignmentTree2 = (AssignmentTree)treePath.getLeaf();
        boolean bl = this.scan(assignmentTree.getExpression(), assignmentTree2.getExpression(), treePath);
        return bl && this.scan(assignmentTree.getVariable(), assignmentTree2.getVariable(), treePath) != false;
    }

    @Override
    public Boolean visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, TreePath treePath) {
        if (treePath == null) {
            super.visitCompoundAssignment(compoundAssignmentTree, treePath);
            return false;
        }
        CompoundAssignmentTree compoundAssignmentTree2 = (CompoundAssignmentTree)treePath.getLeaf();
        boolean bl = this.scan(compoundAssignmentTree.getExpression(), compoundAssignmentTree2.getExpression(), treePath);
        return bl && this.scan(compoundAssignmentTree.getVariable(), compoundAssignmentTree2.getVariable(), treePath) != false;
    }

    @Override
    public Boolean visitBinary(BinaryTree binaryTree, TreePath treePath) {
        if (treePath == null) {
            super.visitBinary(binaryTree, treePath);
            return false;
        }
        BinaryTree binaryTree2 = (BinaryTree)treePath.getLeaf();
        boolean bl = this.scan(binaryTree.getLeftOperand(), binaryTree2.getLeftOperand(), treePath);
        return bl && this.scan(binaryTree.getRightOperand(), binaryTree2.getRightOperand(), treePath) != false;
    }

    @Override
    public Boolean visitConditionalExpression(ConditionalExpressionTree conditionalExpressionTree, TreePath treePath) {
        if (treePath == null) {
            super.visitConditionalExpression(conditionalExpressionTree, treePath);
            return false;
        }
        ConditionalExpressionTree conditionalExpressionTree2 = (ConditionalExpressionTree)treePath.getLeaf();
        if (!this.scan(conditionalExpressionTree.getCondition(), conditionalExpressionTree2.getCondition(), treePath).booleanValue()) {
            return false;
        }
        if (!this.scan(conditionalExpressionTree.getFalseExpression(), conditionalExpressionTree2.getFalseExpression(), treePath).booleanValue()) {
            return false;
        }
        return this.scan(conditionalExpressionTree.getTrueExpression(), conditionalExpressionTree2.getTrueExpression(), treePath);
    }

    @Override
    public Boolean visitIdentifier(IdentifierTree identifierTree, TreePath treePath) {
        Element element;
        if (treePath == null) {
            return (Boolean)super.visitIdentifier(identifierTree, treePath);
        }
        Element element2 = this.info.getTrees().getElement(this.getCurrentPath());
        if (element2 == (element = this.info.getTrees().getElement(treePath))) {
            return true;
        }
        if (element2 == null || element == null) {
            return false;
        }
        return ((Object)element2).equals(element);
    }

    @Override
    public Boolean visitArrayAccess(ArrayAccessTree arrayAccessTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitArrayAccess(arrayAccessTree, treePath);
        }
        ArrayAccessTree arrayAccessTree2 = (ArrayAccessTree)treePath.getLeaf();
        if (!this.scan(arrayAccessTree.getExpression(), arrayAccessTree2.getExpression(), treePath).booleanValue()) {
            return false;
        }
        return this.scan(arrayAccessTree.getIndex(), arrayAccessTree2.getIndex(), treePath);
    }

    @Override
    public Boolean visitLiteral(LiteralTree literalTree, TreePath treePath) {
        Object object;
        if (treePath == null) {
            return (Boolean)super.visitLiteral(literalTree, treePath);
        }
        LiteralTree literalTree2 = (LiteralTree)treePath.getLeaf();
        Object object2 = literalTree.getValue();
        if (object2 == (object = literalTree2.getValue())) {
            return true;
        }
        if (object2 == null || object == null) {
            return false;
        }
        return object2.equals(object);
    }

    @Override
    public Boolean visitNewArray(NewArrayTree newArrayTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitNewArray(newArrayTree, treePath);
        }
        NewArrayTree newArrayTree2 = (NewArrayTree)treePath.getLeaf();
        if (!this.checkLists(newArrayTree.getDimensions(), newArrayTree2.getDimensions(), treePath)) {
            return false;
        }
        if (!this.checkLists(newArrayTree.getInitializers(), newArrayTree2.getInitializers(), treePath)) {
            return false;
        }
        return this.scan(newArrayTree.getType(), newArrayTree2.getType(), treePath);
    }

    @Override
    public Boolean visitNewClass(NewClassTree newClassTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitNewClass(newClassTree, treePath);
        }
        NewClassTree newClassTree2 = (NewClassTree)treePath.getLeaf();
        if (!this.scan(newClassTree.getIdentifier(), newClassTree2.getIdentifier(), treePath).booleanValue()) {
            return false;
        }
        if (!this.scan(newClassTree.getEnclosingExpression(), newClassTree2.getEnclosingExpression(), treePath).booleanValue()) {
            return false;
        }
        if (!this.checkLists(newClassTree.getTypeArguments(), newClassTree2.getTypeArguments(), treePath)) {
            return false;
        }
        if (!this.checkLists(newClassTree.getArguments(), newClassTree2.getArguments(), treePath)) {
            return false;
        }
        return this.scan(newClassTree.getClassBody(), newClassTree2.getClassBody(), treePath);
    }

    @Override
    public Boolean visitParenthesized(ParenthesizedTree parenthesizedTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitParenthesized(parenthesizedTree, treePath);
        }
        ParenthesizedTree parenthesizedTree2 = (ParenthesizedTree)treePath.getLeaf();
        return this.scan(parenthesizedTree.getExpression(), parenthesizedTree2.getExpression(), treePath);
    }

    @Override
    public Boolean visitMemberSelect(MemberSelectTree memberSelectTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitMemberSelect(memberSelectTree, treePath);
        }
        MemberSelectTree memberSelectTree2 = (MemberSelectTree)treePath.getLeaf();
        if (!this.scan(memberSelectTree.getExpression(), memberSelectTree2.getExpression(), treePath).booleanValue()) {
            return false;
        }
        return memberSelectTree.getIdentifier().toString().equals(memberSelectTree2.getIdentifier().toString());
    }

    @Override
    public Boolean visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitParameterizedType(parameterizedTypeTree, treePath);
        }
        ParameterizedTypeTree parameterizedTypeTree2 = (ParameterizedTypeTree)treePath.getLeaf();
        if (!this.scan(parameterizedTypeTree.getType(), parameterizedTypeTree2.getType(), treePath).booleanValue()) {
            return false;
        }
        return this.checkLists(parameterizedTypeTree.getTypeArguments(), parameterizedTypeTree2.getTypeArguments(), treePath);
    }

    @Override
    public Boolean visitTypeCast(TypeCastTree typeCastTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitTypeCast(typeCastTree, treePath);
        }
        TypeCastTree typeCastTree2 = (TypeCastTree)treePath.getLeaf();
        if (!this.scan(typeCastTree.getType(), typeCastTree2.getType(), treePath).booleanValue()) {
            return false;
        }
        return this.scan(typeCastTree.getExpression(), typeCastTree2.getExpression(), treePath);
    }

    @Override
    public Boolean visitPrimitiveType(PrimitiveTypeTree primitiveTypeTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitPrimitiveType(primitiveTypeTree, treePath);
        }
        PrimitiveTypeTree primitiveTypeTree2 = (PrimitiveTypeTree)treePath.getLeaf();
        return primitiveTypeTree.getPrimitiveTypeKind() == primitiveTypeTree2.getPrimitiveTypeKind();
    }

    @Override
    public Boolean visitInstanceOf(InstanceOfTree instanceOfTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitInstanceOf(instanceOfTree, treePath);
        }
        InstanceOfTree instanceOfTree2 = (InstanceOfTree)treePath.getLeaf();
        if (!this.scan(instanceOfTree.getExpression(), instanceOfTree2.getExpression(), treePath).booleanValue()) {
            return false;
        }
        return this.scan(instanceOfTree.getType(), instanceOfTree2.getType(), treePath);
    }

    @Override
    public Boolean visitUnary(UnaryTree unaryTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitUnary(unaryTree, treePath);
        }
        UnaryTree unaryTree2 = (UnaryTree)treePath.getLeaf();
        return this.scan(unaryTree.getExpression(), unaryTree2.getExpression(), treePath);
    }
}

