/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreateFieldFix
implements Fix {
    private FileObject targetFile;
    private ElementHandle<TypeElement> target;
    private TypeMirrorHandle proposedType;
    private ClasspathInfo cpInfo;
    private Set<Modifier> modifiers;
    private String name;
    private String inFQN;

    public CreateFieldFix(CompilationInfo compilationInfo, String string, Set<Modifier> set, TypeElement typeElement, TypeMirror typeMirror, FileObject fileObject) {
        this.name = string;
        this.inFQN = typeElement.getQualifiedName().toString();
        this.cpInfo = compilationInfo.getClasspathInfo();
        this.modifiers = set;
        this.targetFile = fileObject;
        this.target = ElementHandle.create((Element)typeElement);
        if (typeMirror.getKind() == TypeKind.NULL) {
            typeMirror = compilationInfo.getElements().getTypeElement("java.lang.Object").asType();
        }
        this.proposedType = TypeMirrorHandle.create((TypeMirror)typeMirror);
    }

    public String getText() {
        return NbBundle.getMessage(CreateFieldFix.class, (String)"LBL_FIX_Create_Field", (Object)this.name, (Object)this.inFQN);
    }

    public ChangeInfo implement() throws IOException {
        JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[]{this.targetFile});
        ModificationResult modificationResult = javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement typeElement = (TypeElement)CreateFieldFix.this.target.resolve((CompilationInfo)workingCopy);
                if (typeElement == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve target.");
                    return;
                }
                ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                if (classTree == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve target tree: " + typeElement.getQualifiedName() + ".");
                    return;
                }
                TypeMirror typeMirror = CreateFieldFix.this.proposedType.resolve((CompilationInfo)workingCopy);
                if (typeMirror == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve proposed type.");
                    return;
                }
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                TypeMirror typeMirror2 = typeMirror;
                VariableTree variableTree = null;
                if (typeMirror2.getKind() == TypeKind.DECLARED || typeMirror2.getKind() == TypeKind.ARRAY) {
                    variableTree = treeMaker.Variable(treeMaker.Modifiers(CreateFieldFix.this.modifiers), (CharSequence)CreateFieldFix.this.name, treeMaker.Type(typeMirror2), null);
                }
                if (typeMirror2.getKind().isPrimitive()) {
                    variableTree = treeMaker.Variable(treeMaker.Modifiers(CreateFieldFix.this.modifiers), (CharSequence)CreateFieldFix.this.name, treeMaker.Type(typeMirror2), null);
                }
                assert (variableTree != null) : typeMirror2.getKind();
                ClassTree classTree2 = GeneratorUtilities.get((WorkingCopy)workingCopy).insertClassMember(classTree, variableTree);
                workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
            }
        });
        return Utilities.commitAndComputeChangeInfo(this.targetFile, modificationResult, null);
    }

    String toDebugString(CompilationInfo compilationInfo) {
        return "CreateFieldFix:" + this.name + ":" + this.target.getQualifiedName() + ":" + ((Object)this.proposedType.resolve(compilationInfo)).toString() + ":" + this.modifiers;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CreateFieldFix createFieldFix = (CreateFieldFix)object;
        if (!(this.target == createFieldFix.target || this.target != null && this.target.equals(createFieldFix.target))) {
            return false;
        }
        if (!(this.modifiers == createFieldFix.modifiers || this.modifiers != null && ((Object)this.modifiers).equals(createFieldFix.modifiers))) {
            return false;
        }
        return this.name == createFieldFix.name || this.name != null && this.name.equals(createFieldFix.name);
    }

    public int hashCode() {
        int n = 5;
        n = 79 * n + (this.target != null ? this.target.hashCode() : 0);
        n = 79 * n + (this.modifiers != null ? ((Object)this.modifiers).hashCode() : 0);
        n = 79 * n + (this.name != null ? this.name.hashCode() : 0);
        return n;
    }
}

