/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.lang.model.type.TypeMirror;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.WrongStringComparisonCustomizer;
import org.netbeans.modules.java.hints.introduce.CopyFinder;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrongStringComparison
extends AbstractHint {
    private static final String TERNARY_NULL_CHECK = "ternary-null-check";
    private static final String STRING_TYPE = "java.lang.String";
    private static final Set<Tree.Kind> TREE_KINDS = EnumSet.of(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO);
    private AtomicBoolean cancel = new AtomicBoolean();

    public WrongStringComparison() {
        super(true, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return TREE_KINDS;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        TypeMirror typeMirror;
        this.cancel.set(false);
        Tree tree = treePath.getLeaf();
        if (!this.getTreeKinds().contains((Object)tree.getKind())) {
            return null;
        }
        BinaryTree binaryTree = (BinaryTree)tree;
        TreePath treePath2 = new TreePath(treePath, binaryTree.getLeftOperand());
        TreePath treePath3 = new TreePath(treePath, binaryTree.getRightOperand());
        Trees trees = compilationInfo.getTrees();
        TypeMirror typeMirror2 = treePath2 == null ? null : trees.getTypeMirror(treePath2);
        TypeMirror typeMirror3 = typeMirror = treePath3 == null ? null : trees.getTypeMirror(treePath3);
        if (typeMirror2 != null && typeMirror != null && STRING_TYPE.equals(((Object)typeMirror2).toString()) && STRING_TYPE.equals(((Object)typeMirror).toString())) {
            if (this.checkInsideGeneratedEquals(compilationInfo, treePath, treePath2.getLeaf(), treePath3.getLeaf())) {
                return null;
            }
            FileObject fileObject = compilationInfo.getFileObject();
            TreePathHandle treePathHandle = TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo);
            ArrayList<WrongStringComparisonFix> arrayList = new ArrayList<WrongStringComparisonFix>();
            arrayList.add(new WrongStringComparisonFix(fileObject, treePathHandle, this.getTernaryNullCheck()));
            arrayList.add(new WrongStringComparisonFix(fileObject, treePathHandle, null));
            return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)this.getDisplayName(), Collections.unmodifiableList(arrayList), (FileObject)compilationInfo.getFileObject(), (int)((int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), tree)), (int)((int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), tree))));
        }
        return null;
    }

    @Override
    public void cancel() {
        this.cancel.set(true);
    }

    @Override
    public String getId() {
        return "Wrong_String_Comparison";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(WrongStringComparison.class, (String)"LBL_WrongStringComparison");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(WrongStringComparison.class, (String)"DSC_WrongStringComparison");
    }

    public boolean getTernaryNullCheck() {
        return WrongStringComparison.getTernaryNullCheck(this.getPreferences(null));
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return new WrongStringComparisonCustomizer(preferences);
    }

    private boolean checkInsideGeneratedEquals(CompilationInfo compilationInfo, TreePath treePath, Tree tree, Tree tree2) {
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2.getLeaf().getKind() != Tree.Kind.CONDITIONAL_AND) {
            return false;
        }
        SourcePositions sourcePositions = compilationInfo.getTrees().getSourcePositions();
        Scope scope = compilationInfo.getTrees().getScope(treePath2);
        String string = compilationInfo.getText().substring((int)sourcePositions.getStartPosition(compilationInfo.getCompilationUnit(), tree), (int)sourcePositions.getEndPosition(compilationInfo.getCompilationUnit(), tree) + 1);
        String string2 = compilationInfo.getText().substring((int)sourcePositions.getStartPosition(compilationInfo.getCompilationUnit(), tree2), (int)sourcePositions.getEndPosition(compilationInfo.getCompilationUnit(), tree2) + 1);
        String string3 = string + " != " + string2 + " && (" + string + "== null || !" + string + ".equals(" + string2 + "))";
        ExpressionTree expressionTree = compilationInfo.getTreeUtilities().parseExpression(string3, new SourcePositions[1]);
        compilationInfo.getTreeUtilities().attributeTree((Tree)expressionTree, scope);
        TreePath treePath3 = new TreePath(treePath2.getParentPath(), expressionTree);
        String string4 = compilationInfo.getText().substring((int)sourcePositions.getStartPosition(compilationInfo.getCompilationUnit(), treePath2.getLeaf()), (int)sourcePositions.getEndPosition(compilationInfo.getCompilationUnit(), treePath2.getLeaf()) + 1);
        ExpressionTree expressionTree2 = compilationInfo.getTreeUtilities().parseExpression(string4, new SourcePositions[1]);
        compilationInfo.getTreeUtilities().attributeTree((Tree)expressionTree2, scope);
        TreePath treePath4 = new TreePath(treePath2.getParentPath(), expressionTree2);
        return CopyFinder.isDuplicate(compilationInfo, treePath4, treePath3, this.cancel);
    }

    static boolean getTernaryNullCheck(Preferences preferences) {
        return preferences.getBoolean(TERNARY_NULL_CHECK, true);
    }

    static void setTernaryNullCheck(Preferences preferences, boolean bl) {
        preferences.putBoolean(TERNARY_NULL_CHECK, bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WrongStringComparisonFix
    implements Fix,
    Task<WorkingCopy> {
        protected FileObject file;
        protected TreePathHandle tph;
        protected Boolean nullCheck;

        public WrongStringComparisonFix(FileObject fileObject, TreePathHandle treePathHandle, Boolean bl) {
            this.file = fileObject;
            this.tph = treePathHandle;
            this.nullCheck = bl;
        }

        public String getText() {
            if (this.nullCheck == null) {
                return NbBundle.getMessage(WrongStringComparison.class, (String)"FIX_WrongStringComparison_NoNullCheck");
            }
            if (this.nullCheck.booleanValue()) {
                return NbBundle.getMessage(WrongStringComparison.class, (String)"FIX_WrongStringComparison_TernaryNullCheck");
            }
            return NbBundle.getMessage(WrongStringComparison.class, (String)"FIX_WrongStringComparison_NullCheck");
        }

        public ChangeInfo implement() throws Exception {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
            javaSource.runModificationTask((Task)this).commit();
            return null;
        }

        public String toString() {
            return "[WrongStringComparisonFix:" + this.getText() + "]";
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            workingCopy.toPhase(JavaSource.Phase.PARSED);
            TreePath treePath = this.tph.resolve((CompilationInfo)workingCopy);
            if (treePath != null) {
                ExpressionTree expressionTree;
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                BinaryTree binaryTree = (BinaryTree)treePath.getLeaf();
                ExpressionTree expressionTree2 = binaryTree.getLeftOperand();
                ExpressionTree expressionTree3 = binaryTree.getRightOperand();
                MemberSelectTree memberSelectTree = treeMaker.MemberSelect(expressionTree2, (CharSequence)"equals");
                ExpressionTree expressionTree4 = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)memberSelectTree, Collections.singletonList(expressionTree3));
                if (binaryTree.getKind() == Tree.Kind.NOT_EQUAL_TO) {
                    expressionTree4 = treeMaker.Unary(Tree.Kind.LOGICAL_COMPLEMENT, expressionTree4);
                }
                if (this.nullCheck == null) {
                    expressionTree = expressionTree4;
                } else {
                    BinaryTree binaryTree2 = treeMaker.Binary(Tree.Kind.EQUAL_TO, expressionTree2, (ExpressionTree)treeMaker.Identifier((CharSequence)"null"));
                    BinaryTree binaryTree3 = treeMaker.Binary(binaryTree.getKind(), expressionTree3, (ExpressionTree)treeMaker.Identifier((CharSequence)"null"));
                    if (this.nullCheck.booleanValue()) {
                        expressionTree = treeMaker.ConditionalExpression((ExpressionTree)binaryTree2, (ExpressionTree)binaryTree3, expressionTree4);
                    } else {
                        BinaryTree binaryTree4 = treeMaker.Binary(Tree.Kind.NOT_EQUAL_TO, expressionTree2, (ExpressionTree)treeMaker.Identifier((CharSequence)"null"));
                        ParenthesizedTree parenthesizedTree = treeMaker.Parenthesized((ExpressionTree)treeMaker.Binary(Tree.Kind.CONDITIONAL_AND, (ExpressionTree)binaryTree2, (ExpressionTree)binaryTree3));
                        ParenthesizedTree parenthesizedTree2 = treeMaker.Parenthesized((ExpressionTree)treeMaker.Binary(Tree.Kind.CONDITIONAL_AND, (ExpressionTree)binaryTree4, expressionTree4));
                        expressionTree = treeMaker.Binary(Tree.Kind.CONDITIONAL_OR, (ExpressionTree)parenthesizedTree, (ExpressionTree)parenthesizedTree2);
                    }
                    if (treePath.getParentPath().getLeaf().getKind() != Tree.Kind.PARENTHESIZED) {
                        expressionTree = treeMaker.Parenthesized(expressionTree);
                    }
                }
                workingCopy.rewrite((Tree)binaryTree, (Tree)expressionTree);
            }
        }
    }
}

