/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmptyCancelForCancellableTask
extends AbstractHint {
    private static Set<String> typesToCheck = new HashSet<String>(Arrays.asList("org.netbeans.api.java.source.CancellableTask<org.netbeans.api.java.source.CompilationInfo>", "org.netbeans.modules.java.hints.spi.Rule"));

    public EmptyCancelForCancellableTask() {
        super(false, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(EmptyCancelForCancellableTask.class, (String)"DSC_EmptyCancel");
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.METHOD);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        TypeMirror typeMirror;
        Object object;
        Element element = compilationInfo.getTrees().getElement(treePath);
        if (element == null || element.getKind() != ElementKind.METHOD || !"cancel".equals(element.getSimpleName().toString()) || element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return null;
        }
        Element element2 = element.getEnclosingElement();
        if (!element2.getKind().isClass()) {
            return null;
        }
        boolean bl = false;
        block0: for (String object22 : typesToCheck) {
            object = (TypeElement)element2;
            typeMirror = object.asType();
            TypeMirror typeMirror2 = compilationInfo.getTreeUtilities().parseType(object22, (TypeElement)object);
            if (typeMirror2.getKind() != TypeKind.DECLARED) continue;
            TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror2).asElement();
            if (!compilationInfo.getTypes().isSubtype(typeMirror, typeMirror2) || ((Object)typeMirror).equals(typeMirror2)) continue;
            for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                if (!compilationInfo.getElements().overrides((ExecutableElement)element, executableElement, (TypeElement)object)) continue;
                bl = true;
                break block0;
            }
        }
        if (!bl) {
            return null;
        }
        MethodTree methodTree = (MethodTree)treePath.getLeaf();
        if (!methodTree.getBody().getStatements().isEmpty()) {
            return null;
        }
        int[] nArray = compilationInfo.getTreeUtilities().findNameSpan((MethodTree)treePath.getLeaf());
        if (nArray != null) {
            object = NbBundle.getMessage(EmptyCancelForCancellableTask.class, (String)"MSG_EmptyCancel");
            typeMirror = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)object, (FileObject)compilationInfo.getFileObject(), (int)nArray[0], (int)nArray[1]);
            return Collections.singletonList(typeMirror);
        }
        return null;
    }

    @Override
    public String getId() {
        return EmptyCancelForCancellableTask.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(EmptyCancelForCancellableTask.class, (String)"LBL_EmptyCancel");
    }

    @Override
    public void cancel() {
    }
}

