/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.usages;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.lucene.index.IndexReader;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.IndexDocument;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsfpath.api.queries.SourceForBinaryQuery;
import org.netbeans.modules.gsfret.source.SourceAccessor;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.netbeans.modules.gsfret.source.usages.Index;
import org.netbeans.modules.gsfret.source.usages.LuceneIndex;
import org.netbeans.modules.gsfret.source.usages.SourceAnalyser;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentClassIndex
extends ClassIndexImpl {
    private final Index index;
    private final URL root;
    private final boolean isSource;
    private WeakReference<Source> dirty;
    private static final Logger LOGGER = Logger.getLogger(PersistentClassIndex.class.getName());
    private File cacheRoot;
    private Language language;

    private PersistentClassIndex(Language language, URL uRL, File file, boolean bl) throws IOException, IllegalArgumentException {
        assert (uRL != null);
        this.root = uRL;
        this.index = LuceneIndex.create(language, file, this);
        this.isSource = bl;
        this.language = language;
        this.cacheRoot = file;
    }

    @Override
    public SourceAnalyser getSourceAnalyser() {
        return new SourceAnalyser(this.index);
    }

    @Override
    public FileObject[] getSourceRoots() {
        FileObject[] fileObjectArray;
        if (this.isSource) {
            FileObject[] fileObjectArray2;
            FileObject fileObject = URLMapper.findFileObject((URL)this.root);
            if (fileObject == null) {
                fileObjectArray2 = new FileObject[]{};
            } else {
                FileObject[] fileObjectArray3 = new FileObject[1];
                fileObjectArray2 = fileObjectArray3;
                fileObjectArray3[0] = fileObject;
            }
            fileObjectArray = fileObjectArray2;
        } else {
            fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)this.root).getRoots();
        }
        return fileObjectArray;
    }

    public static ClassIndexImpl create(Language language, URL uRL, File file, boolean bl) throws IOException, IllegalArgumentException {
        return new PersistentClassIndex(language, uRL, file, bl);
    }

    @Override
    public synchronized void setDirty(Source source) {
        if (source == null) {
            this.dirty = null;
        } else if (this.dirty == null || this.dirty.get() != source) {
            this.dirty = new WeakReference<Source>(source);
        }
    }

    public String toString() {
        return "CompromiseUQ[" + this.root.toExternalForm() + "]";
    }

    @Override
    protected final void close() throws IOException {
        this.index.close();
    }

    private Void runIndexers(CompilationInfo compilationInfo) throws IOException {
        Indexer indexer = this.language.getIndexer();
        if (indexer == null) {
            return null;
        }
        SourceAnalyser sourceAnalyser = this.getSourceAnalyser();
        long l = System.currentTimeMillis();
        String string = this.language.getMimeType();
        for (ParserResult parserResult : compilationInfo.getEmbeddedResults(string)) {
            assert (parserResult != null);
            if (!parserResult.isValid()) continue;
            sourceAnalyser.analyseUnitAndStore(indexer, parserResult);
        }
        long l2 = System.currentTimeMillis();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDirty() {
        WeakReference<Source> weakReference;
        Object object = this;
        synchronized (object) {
            weakReference = this.dirty;
        }
        if (weakReference != null && (object = (Source)weakReference.get()) != null) {
            long l = System.currentTimeMillis();
            if (SourceAccessor.getINSTANCE().isDispatchThread()) {
                try {
                    ClassIndexManager.writeLock(new ClassIndexManager.ExceptionAction<Void>((Source)object){
                        final /* synthetic */ Source val$js;
                        {
                            this.val$js = source;
                        }

                        @Override
                        public Void run() throws IOException {
                            CompilationInfo compilationInfo = SourceAccessor.getINSTANCE().getCurrentCompilationInfo(this.val$js, Phase.RESOLVED);
                            if (compilationInfo != null) {
                                return PersistentClassIndex.this.runIndexers(compilationInfo);
                            }
                            return null;
                        }
                    });
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            } else {
                try {
                    ((Source)object).runUserActionTask(new CancellableTask<CompilationController>(){

                        public void run(final CompilationController compilationController) {
                            try {
                                ClassIndexManager.writeLock(new ClassIndexManager.ExceptionAction<Void>(){

                                    @Override
                                    public Void run() throws IOException {
                                        compilationController.toPhase(Phase.RESOLVED);
                                        return PersistentClassIndex.this.runIndexers(compilationController);
                                    }
                                });
                            }
                            catch (IOException iOException) {
                                Exceptions.printStackTrace((Throwable)iOException);
                            }
                        }

                        public void cancel() {
                        }
                    }, true);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            PersistentClassIndex persistentClassIndex = this;
            synchronized (persistentClassIndex) {
                this.dirty = null;
            }
            long l2 = System.currentTimeMillis();
            LOGGER.fine("PersistentClassIndex.updateDirty took: " + (l2 - l) + " ms");
        }
    }

    @Override
    public void search(final String string, final String string2, final NameKind nameKind, final Set<Index.SearchScope> set, final Set<Index.SearchResult> set2, final Set<String> set3) throws IOException {
        this.updateDirty();
        ClassIndexManager.readLock(new ClassIndexManager.ExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                PersistentClassIndex.this.index.search(string, string2, nameKind, set, set2, set3);
                return null;
            }
        });
    }

    @Override
    public Map<String, String> getTimeStamps() throws IOException {
        final Map[] mapArray = new Map[1];
        ClassIndexManager.readLock(new ClassIndexManager.ExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                mapArray[0] = PersistentClassIndex.this.index.getTimeStamps();
                return null;
            }
        });
        return mapArray[0];
    }

    @Override
    public File getSegment() {
        return this.cacheRoot;
    }

    @Override
    public URL getRoot() {
        return this.root;
    }

    public IndexReader getDumpIndexReader() throws IOException {
        this.updateDirty();
        final IndexReader[] indexReaderArray = new IndexReader[1];
        ClassIndexManager.readLock(new ClassIndexManager.ExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                indexReaderArray[0] = ((LuceneIndex)PersistentClassIndex.this.index).getDumpIndexReader();
                return null;
            }
        });
        return indexReaderArray[0];
    }

    @Override
    public void storeEmpty() {
        List<IndexDocument> list = Collections.emptyList();
        try {
            this.index.store(null, list);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }
}

