/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.usages;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.IndexDocument;
import org.netbeans.modules.gsf.api.IndexDocumentFactory;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.netbeans.modules.gsfret.source.usages.IndexBatchEntry;
import org.netbeans.modules.gsfret.source.usages.IndexDocumentImpl;
import org.netbeans.modules.gsfret.source.usages.RepositoryUpdater;
import org.netbeans.modules.gsfret.source.usages.SourceAnalyser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingIndexer {
    private static final int CACHE_INDEX_SIZE = 300;
    private static final Logger LOGGER = Logger.getLogger(RepositoryUpdater.class.getName());
    private URL root;
    private int fileCountGuess;
    private Map<Language, LanguageIndex> indices = new HashMap<Language, LanguageIndex>();

    public static CachingIndexer get(URL uRL, int n) {
        return new CachingIndexer(n, uRL);
    }

    public CachingIndexer(int n, URL uRL) {
        this.fileCountGuess = Math.min(2000, n);
        this.root = uRL;
    }

    private LanguageIndex getLanguageIndex(Language language) throws IOException {
        LanguageIndex languageIndex = this.indices.get(language);
        if (languageIndex == null) {
            ClassIndexImpl classIndexImpl = ClassIndexManager.get(language).createUsagesQuery(this.root, true);
            assert (classIndexImpl != null);
            SourceAnalyser sourceAnalyser = classIndexImpl.getSourceAnalyser();
            assert (sourceAnalyser != null);
            ArrayList<IndexBatchEntry> arrayList = new ArrayList<IndexBatchEntry>(this.fileCountGuess);
            boolean bl = sourceAnalyser.hasData();
            languageIndex = new LanguageIndex(sourceAnalyser, arrayList, bl, language);
            this.indices.put(language, languageIndex);
        }
        return languageIndex;
    }

    public void flush() throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "FLUSHING INDEX for root " + this.root);
        }
        for (LanguageIndex languageIndex : this.indices.values()) {
            languageIndex.flush();
        }
    }

    public void index(Language language, File file, Iterable<ParserResult> iterable) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Stashing index documents for file " + file);
        }
        LanguageIndex languageIndex = this.getLanguageIndex(language);
        languageIndex.index(file, iterable);
    }

    public void remove(Language language, String string) throws IOException {
        LanguageIndex languageIndex = this.getLanguageIndex(language);
        languageIndex.remove(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LanguageIndex
    implements IndexDocumentFactory {
        final SourceAnalyser analyzer;
        final List<IndexBatchEntry> entries;
        private int size;
        private boolean create;
        private final Language language;

        public LanguageIndex(SourceAnalyser sourceAnalyser, List<IndexBatchEntry> list, boolean bl, Language language) {
            this.analyzer = sourceAnalyser;
            this.entries = list;
            this.create = bl;
            this.language = language;
        }

        public SourceAnalyser getAnalyzer() {
            return this.analyzer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Flushing index for " + this.language.getDisplayName() + "; the number of stashed documents is " + this.entries.size());
                }
                if (this.entries.size() > 0) {
                    this.analyzer.batchStore(this.entries, this.create);
                    this.entries.clear();
                }
            }
            finally {
                this.create = false;
            }
        }

        public void index(File file, Iterable<ParserResult> iterable) throws IOException {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Stashing index documents for file " + file);
            }
            Indexer indexer = this.language.getIndexer();
            assert (indexer != null) : this.language;
            if (indexer != null) {
                String string = indexer.getPersistentUrl(file);
                for (ParserResult parserResult : iterable) {
                    List<IndexDocumentImpl> list = indexer.index(parserResult, (IndexDocumentFactory)this);
                    if (list == null) {
                        list = Collections.emptyList();
                    }
                    IndexBatchEntry indexBatchEntry = new IndexBatchEntry(string, this.language, list, this.analyzer);
                    this.entries.add(indexBatchEntry);
                }
                ++this.size;
                if (this.size == 300) {
                    this.flush();
                    this.size = 0;
                }
            }
        }

        private void remove(String string) {
            Indexer indexer = this.language.getIndexer();
            assert (indexer != null) : this.language;
            if (indexer != null) {
                IndexBatchEntry indexBatchEntry = new IndexBatchEntry(string, this.language, null, this.analyzer);
                this.entries.add(indexBatchEntry);
                ++this.size;
            }
        }

        public IndexDocument createDocument(int n) {
            return new IndexDocumentImpl(n);
        }

        public IndexDocument createDocument(int n, String string) {
            return new IndexDocumentImpl(n, string);
        }
    }
}

