/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.websvc.manager.api.WebServiceDescriptor;
import org.netbeans.modules.websvc.manager.model.WebServiceData;
import org.netbeans.modules.websvc.manager.util.ManagerUtil;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlServiceProxyDescriptor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceLibReferenceHelper {
    private static final String WEBSERVICE_CLIENTS_SUB_DIR = "webservice_clients";
    private static final AddLibrary DESIGN_RUNTIME_LIBRARY_ADD = new AddLibraryToProject();

    public static void addArchiveRefsToProject(Project project, List<String> list) {
        try {
            FileObject fileObject = ManagerUtil.getProjectLibraryDirectory(project);
            FileObject fileObject2 = fileObject.getFileObject(WEBSERVICE_CLIENTS_SUB_DIR);
            if (fileObject2 == null) {
                fileObject2 = fileObject.createFolder(WEBSERVICE_CLIENTS_SUB_DIR);
            }
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (String string : list) {
                try {
                    String string2 = new File(string).getName();
                    FileObject fileObject3 = fileObject2.getFileObject(string2);
                    if (fileObject3 == null) {
                        fileObject3 = fileObject2.createData(string2);
                        WebServiceLibReferenceHelper.copyJarFile(string, fileObject3);
                    }
                    arrayList.add(new URL(fileObject3.getURL().toExternalForm() + "/"));
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            WebServiceLibReferenceHelper.addRefsToProject(project, arrayList, new AddArchiveReferences(), new URL[0]);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            iOException.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyJarFile(String string, FileObject fileObject) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(new File(string)));
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            byte[] byArray = new byte[1024];
            int n = dataInputStream.read(byArray);
            while (n > -1) {
                dataOutputStream.write(byArray, 0, n);
                n = dataInputStream.read(byArray);
            }
            dataOutputStream.flush();
            dataOutputStream.close();
            outputStream.close();
            dataInputStream.close();
        }
        finally {
            fileLock.releaseLock();
        }
    }

    public static void addLibRefsToProject(Project project, List<Library> list, String string) {
        WebServiceLibReferenceHelper.addRefsToProject(project, list, new AddLibraryFromRole(string), new Library[0]);
    }

    public static void addLibRefsToProject(Project project, List<Library> list) {
        WebServiceLibReferenceHelper.addRefsToProject(project, list, DESIGN_RUNTIME_LIBRARY_ADD, new Library[0]);
    }

    private static <T> void addRefsToProject(Project project, List<T> list, AddLibrary<T> addLibrary, T[] TArray) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : list) {
            if (addLibrary.hasLibraryReference(project, t)) continue;
            arrayList.add(t);
        }
        try {
            addLibrary.addLibraryReferences(project, arrayList.toArray(TArray));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().getInstance("org.netbeans.modules.websvc.manager.node.WebServiceLibReferenceHelper").log(65536, "Failed to add library references to project. IOException");
            iOException.printStackTrace();
        }
    }

    public static void addDefaultJaxWsClientJar(Project project, WebServiceData webServiceData) {
        List<String> list = WebServiceLibReferenceHelper.getDefaultJaxWsClientJars(webServiceData);
        WebServiceLibReferenceHelper.addArchiveRefsToProject(project, list);
    }

    public static List<String> getDefaultJaxWsClientJars(WebServiceData webServiceData) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(WebServiceDescriptor.WEBSVC_HOME, webServiceData.getJaxWsDescriptorPath()).getParentFile();
        for (WsdlServiceProxyDescriptor.JarEntry jarEntry : webServiceData.getJaxWsDescriptor().getJars()) {
            if (!jarEntry.getType().equals("proxy")) continue;
            File file2 = new File(file, jarEntry.getName());
            arrayList.add(file2.getAbsolutePath());
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddLibraryToProject
    implements AddLibrary<Library> {
        @Override
        public boolean hasLibraryReference(Project project, Library library) {
            return ManagerUtil.hasLibraryReference(project, library, null);
        }

        public void addLibraryReferences(Project project, Library[] libraryArray) throws IOException {
            ManagerUtil.addLibraryReferences(project, libraryArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddArchiveReferences
    implements AddLibrary<URL> {
        @Override
        public boolean hasLibraryReference(Project project, URL uRL) {
            return ManagerUtil.hasRootReference(project, uRL);
        }

        public void addLibraryReferences(Project project, URL[] uRLArray) throws IOException {
            ManagerUtil.addRootReferences(project, uRLArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddLibraryFromRole
    implements AddLibrary<Library> {
        private String role;

        public AddLibraryFromRole(String string) {
            this.role = string;
        }

        @Override
        public boolean hasLibraryReference(Project project, Library library) {
            return ManagerUtil.hasLibraryReference(project, library, this.role);
        }

        public void addLibraryReferences(Project project, Library[] libraryArray) throws IOException {
            ManagerUtil.addLibraryReferences(project, libraryArray, this.role);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface AddLibrary<T> {
        public boolean hasLibraryReference(Project var1, T var2);

        public void addLibraryReferences(Project var1, T[] var2) throws IOException;
    }
}

