/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.ui.treeview;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;

public class MultiStateCheckBox
extends JCheckBox {
    protected final MultiStateModel model;
    private static final String PROP_PRESSED = "pressed";
    private static final String PROP_RELEASED = "released";

    public MultiStateCheckBox(String string, State state) {
        super(string);
        super.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                MultiStateCheckBox.this.grabFocus();
                MultiStateCheckBox.this.model.nextState();
            }
        });
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put(PROP_PRESSED, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiStateCheckBox.this.grabFocus();
                MultiStateCheckBox.this.model.nextState();
            }
        });
        actionMapUIResource.put(PROP_RELEASED, null);
        SwingUtilities.replaceUIActionMap(this, actionMapUIResource);
        this.model = new MultiStateModel(this.getModel());
        this.setModel(this.model);
        this.setState(state);
    }

    public MultiStateCheckBox(String string) {
        this(string, (State)null);
    }

    public MultiStateCheckBox() {
        this((String)null);
    }

    public void addMouseListener(MouseListener mouseListener) {
    }

    public final void setState(State state) {
        this.model.setState(state);
    }

    public State getState() {
        return this.model.getState();
    }

    private class MultiStateModel
    implements ButtonModel {
        private final ButtonModel other;

        private MultiStateModel(ButtonModel buttonModel) {
            this.other = buttonModel;
        }

        protected void setState(State state) {
            if (state == State.MIXED) {
                this.other.setArmed(true);
                this.setPressed(true);
                this.setSelected(true);
            } else if (state == State.SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(true);
            } else {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(false);
            }
        }

        protected State getState() {
            if (this.isSelected() && !this.isArmed()) {
                return State.SELECTED;
            }
            if (this.isSelected() && this.isArmed()) {
                return State.MIXED;
            }
            return State.UNSELECTED;
        }

        protected void nextState() {
            this.setState(this.getState() == State.UNSELECTED ? State.SELECTED : State.UNSELECTED);
        }

        public void setArmed(boolean bl) {
        }

        public void setEnabled(boolean bl) {
            MultiStateCheckBox.this.setFocusable(bl);
            this.other.setEnabled(bl);
        }

        public boolean isArmed() {
            return this.other.isArmed();
        }

        public boolean isSelected() {
            return this.other.isSelected();
        }

        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        public boolean isPressed() {
            return this.other.isPressed();
        }

        public boolean isRollover() {
            return this.other.isRollover();
        }

        public void setSelected(boolean bl) {
            this.other.setSelected(bl);
        }

        public void setPressed(boolean bl) {
            this.other.setPressed(bl);
        }

        public void setRollover(boolean bl) {
            this.other.setRollover(bl);
        }

        public void setMnemonic(int n) {
            this.other.setMnemonic(n);
        }

        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        public void setActionCommand(String string) {
            this.other.setActionCommand(string);
        }

        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        public void setGroup(ButtonGroup buttonGroup) {
            this.other.setGroup(buttonGroup);
        }

        public void addActionListener(ActionListener actionListener) {
            this.other.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.other.removeActionListener(actionListener);
        }

        public void addItemListener(ItemListener itemListener) {
            this.other.addItemListener(itemListener);
        }

        public void removeItemListener(ItemListener itemListener) {
            this.other.removeItemListener(itemListener);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.other.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.other.removeChangeListener(changeListener);
        }

        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        SELECTED,
        UNSELECTED,
        MIXED;

    }
}

