/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.mapping;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.javon.JavonMapping;
import org.netbeans.modules.mobility.javon.JavonSerializer;
import org.netbeans.modules.mobility.javon.Traversable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveTypeSerializer
implements JavonSerializer {
    private final ClassData voidClassData = new ClassData("", "void", true, false, (JavonSerializer)this);
    private final ClassData booleanClassData = new ClassData("", "boolean", true, false, (JavonSerializer)this);
    private final ClassData BooleanClassData = new ClassData("java.lang", "Boolean", false, false, (JavonSerializer)this);
    private final ClassData byteClassData = new ClassData("", "byte", true, false, (JavonSerializer)this);
    private final ClassData ByteClassData = new ClassData("java.lang", "Byte", false, false, (JavonSerializer)this);
    private final ClassData charClassData = new ClassData("", "char", true, false, (JavonSerializer)this);
    private final ClassData CharClassData = new ClassData("java.lang", "Character", false, false, (JavonSerializer)this);
    private final ClassData intClassData = new ClassData("", "int", true, false, (JavonSerializer)this);
    private final ClassData IntClassData = new ClassData("java.lang", "Integer", false, false, (JavonSerializer)this);
    private final ClassData longClassData = new ClassData("", "long", true, false, (JavonSerializer)this);
    private final ClassData LongClassData = new ClassData("java.lang", "Long", false, false, (JavonSerializer)this);
    private final ClassData shortClassData = new ClassData("", "short", true, false, (JavonSerializer)this);
    private final ClassData ShortClassData = new ClassData("java.lang", "Short", false, false, (JavonSerializer)this);
    private final ClassData stringClassData = new ClassData("java.lang", "String", false, false, (JavonSerializer)this);

    @Override
    public String getName() {
        return "Primitive type serializer";
    }

    @Override
    public boolean isTypeSupported(Traversable traversable, TypeMirror typeMirror, Map<String, ClassData> map) {
        if (TypeKind.VOID == typeMirror.getKind()) {
            return true;
        }
        if (TypeKind.BOOLEAN == typeMirror.getKind()) {
            return true;
        }
        if (TypeKind.BYTE == typeMirror.getKind()) {
            return true;
        }
        if (TypeKind.CHAR == typeMirror.getKind()) {
            return true;
        }
        if (TypeKind.INT == typeMirror.getKind()) {
            return true;
        }
        if (TypeKind.LONG == typeMirror.getKind()) {
            return true;
        }
        if (TypeKind.SHORT == typeMirror.getKind()) {
            return true;
        }
        if (TypeKind.DECLARED == typeMirror.getKind()) {
            TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            String string = typeElement.getQualifiedName().toString();
            if ("java.lang.String".equals(string)) {
                return true;
            }
            if ("java.lang.Boolean".equals(string)) {
                return true;
            }
            if ("java.lang.Byte".equals(string)) {
                return true;
            }
            if ("java.lang.Character".equals(string)) {
                return true;
            }
            if ("java.lang.Integer".equals(string)) {
                return true;
            }
            if ("java.lang.Long".equals(string)) {
                return true;
            }
            if ("java.lang.Short".equals(string)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ClassData getType(Traversable traversable, TypeMirror typeMirror, Map<String, ClassData> map) {
        if (TypeKind.VOID == typeMirror.getKind()) {
            return this.voidClassData;
        }
        if (TypeKind.BOOLEAN == typeMirror.getKind()) {
            return this.booleanClassData;
        }
        if (TypeKind.BYTE == typeMirror.getKind()) {
            return this.byteClassData;
        }
        if (TypeKind.CHAR == typeMirror.getKind()) {
            return this.charClassData;
        }
        if (TypeKind.INT == typeMirror.getKind()) {
            return this.intClassData;
        }
        if (TypeKind.LONG == typeMirror.getKind()) {
            return this.longClassData;
        }
        if (TypeKind.SHORT == typeMirror.getKind()) {
            return this.shortClassData;
        }
        if (TypeKind.DECLARED == typeMirror.getKind()) {
            TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            String string = typeElement.getQualifiedName().toString();
            if ("java.lang.String".equals(string)) {
                return this.stringClassData;
            }
            if ("java.lang.Boolean".equals(string)) {
                return this.BooleanClassData;
            }
            if ("java.lang.Byte".equals(string)) {
                return this.ByteClassData;
            }
            if ("java.lang.Character".equals(string)) {
                return this.CharClassData;
            }
            if ("java.lang.Integer".equals(string)) {
                return this.IntClassData;
            }
            if ("java.lang.Long".equals(string)) {
                return this.LongClassData;
            }
            if ("java.lang.Short".equals(string)) {
                return this.ShortClassData;
            }
        }
        return null;
    }

    @Override
    public String instanceOf(JavonMapping javonMapping, ClassData classData) {
        if (this.booleanClassData.equals(classData)) {
            return "boolean";
        }
        if (this.BooleanClassData.equals(classData)) {
            return "Boolean";
        }
        if (this.byteClassData.equals(classData)) {
            return "byte";
        }
        if (this.ByteClassData.equals(classData)) {
            return "Byte";
        }
        if (this.charClassData.equals(classData)) {
            return "char";
        }
        if (this.CharClassData.equals(classData)) {
            return "Character";
        }
        if (this.intClassData.equals(classData)) {
            return "int";
        }
        if (this.IntClassData.equals(classData)) {
            return "Integer";
        }
        if (this.longClassData.equals(classData)) {
            return "long";
        }
        if (this.LongClassData.equals(classData)) {
            return "Long";
        }
        if (this.shortClassData.equals(classData)) {
            return "short";
        }
        if (this.ShortClassData.equals(classData)) {
            return "Short";
        }
        if (this.stringClassData.equals(classData)) {
            return "String";
        }
        if (this.voidClassData.equals(classData)) {
            return "void";
        }
        throw new IllegalArgumentException("Invalid type: " + classData.getName());
    }

    @Override
    public String toObject(JavonMapping javonMapping, ClassData classData, String string) {
        if (this.booleanClassData.equals(classData)) {
            return "new Boolean(" + string + ")";
        }
        if (this.byteClassData.equals(classData)) {
            return "new Byte(" + string + ")";
        }
        if (this.charClassData.equals(classData)) {
            return "new Character(" + string + ")";
        }
        if (this.intClassData.equals(classData)) {
            return "new Integer(" + string + ")";
        }
        if (this.longClassData.equals(classData)) {
            return "new Long(" + string + ")";
        }
        if (this.shortClassData.equals(classData)) {
            return "new Short(" + string + ")";
        }
        if (this.stringClassData.equals(classData)) {
            return "(String)" + string;
        }
        if (this.voidClassData.equals(classData)) {
            return "void";
        }
        if (this.BooleanClassData.equals(classData)) {
            return "(Boolean)" + string;
        }
        if (this.ByteClassData.equals(classData)) {
            return "(Byte)" + string;
        }
        if (this.CharClassData.equals(classData)) {
            return "(Character)" + string;
        }
        if (this.IntClassData.equals(classData)) {
            return "(Integer)" + string;
        }
        if (this.LongClassData.equals(classData)) {
            return "(Long)" + string;
        }
        if (this.ShortClassData.equals(classData)) {
            return "(Short)" + string;
        }
        throw new IllegalArgumentException("Invalid type: " + classData.getName());
    }

    @Override
    public String fromObject(JavonMapping javonMapping, ClassData classData, String string) {
        if (this.booleanClassData.equals(classData)) {
            return "((Boolean)" + string + ").booleanValue()";
        }
        if (this.byteClassData.equals(classData)) {
            return "((Byte)" + string + ").byteValue()";
        }
        if (this.charClassData.equals(classData)) {
            return "((Character)" + string + ").charValue()";
        }
        if (this.intClassData.equals(classData)) {
            return "((Integer)" + string + ").intValue()";
        }
        if (this.longClassData.equals(classData)) {
            return "((Long)" + string + ").longValue()";
        }
        if (this.shortClassData.equals(classData)) {
            return "((Short)" + string + ").shortValue()";
        }
        if (this.stringClassData.equals(classData)) {
            return "(String)" + string;
        }
        if (this.voidClassData.equals(classData)) {
            return "void";
        }
        if (this.BooleanClassData.equals(classData)) {
            return "(Boolean)" + string;
        }
        if (this.ByteClassData.equals(classData)) {
            return "(Byte)" + string;
        }
        if (this.CharClassData.equals(classData)) {
            return "(Character)" + string;
        }
        if (this.IntClassData.equals(classData)) {
            return "(Integer)" + string;
        }
        if (this.LongClassData.equals(classData)) {
            return "(Long)" + string;
        }
        if (this.ShortClassData.equals(classData)) {
            return "(Short)" + string;
        }
        throw new IllegalArgumentException("Invalid type: " + classData.getName());
    }

    @Override
    public String toStream(JavonMapping javonMapping, ClassData classData, String string, String string2) {
        if (this.booleanClassData.equals(classData)) {
            return string + ".writeBoolean(" + string2 + ");";
        }
        if (this.byteClassData.equals(classData)) {
            return string + ".writeByte(" + string2 + ");";
        }
        if (this.charClassData.equals(classData)) {
            return string + ".writeChar(" + string2 + ");";
        }
        if (this.intClassData.equals(classData)) {
            return string + ".writeInt(" + string2 + ");";
        }
        if (this.longClassData.equals(classData)) {
            return string + ".writeLong(" + string2 + ");";
        }
        if (this.shortClassData.equals(classData)) {
            return string + ".writeShort(" + string2 + ");";
        }
        if (this.stringClassData.equals(classData)) {
            return string + ".writeUTF(" + this.fromObject(javonMapping, classData, string2) + ");";
        }
        if (this.voidClassData.equals(classData)) {
            throw new IllegalArgumentException("Void object is not serializable");
        }
        if (this.BooleanClassData.equals(classData)) {
            return string + ".writeBoolean(" + this.fromObject(javonMapping, this.booleanClassData, string2) + ");";
        }
        if (this.ByteClassData.equals(classData)) {
            return string + ".writeByte(" + this.fromObject(javonMapping, this.byteClassData, string2) + ");";
        }
        if (this.CharClassData.equals(classData)) {
            return string + ".writeChar(" + this.fromObject(javonMapping, this.charClassData, string2) + ");";
        }
        if (this.IntClassData.equals(classData)) {
            return string + ".writeInt(" + this.fromObject(javonMapping, this.intClassData, string2) + ");";
        }
        if (this.LongClassData.equals(classData)) {
            return string + ".writeLong(" + this.fromObject(javonMapping, this.longClassData, string2) + ");";
        }
        if (this.ShortClassData.equals(classData)) {
            return string + ".writeShort(" + this.fromObject(javonMapping, this.shortClassData, string2) + ");";
        }
        throw new IllegalArgumentException("Invalid type: " + classData.getName());
    }

    @Override
    public String fromStream(JavonMapping javonMapping, ClassData classData, String string, String string2) {
        String string3 = "";
        if (string2 != null) {
            string3 = string2 + " = ";
        }
        if (this.voidClassData.equals(classData)) {
            return string2 + " = _;";
        }
        if (this.booleanClassData.equals(classData)) {
            string3 = string3 + string + ".readBoolean()";
        } else if (this.BooleanClassData.equals(classData)) {
            string3 = string3 + this.toObject(javonMapping, this.booleanClassData, string + ".readBoolean()");
        } else if (this.byteClassData.equals(classData)) {
            string3 = string3 + string + ".readByte()";
        } else if (this.ByteClassData.equals(classData)) {
            string3 = string3 + this.toObject(javonMapping, this.byteClassData, string + ".readByte()");
        } else if (this.charClassData.equals(classData)) {
            string3 = string3 + string + ".readChar()";
        } else if (this.CharClassData.equals(classData)) {
            string3 = string3 + this.toObject(javonMapping, this.charClassData, string + ".readChar()");
        } else if (this.intClassData.equals(classData)) {
            string3 = string3 + string + ".readInt()";
        } else if (this.IntClassData.equals(classData)) {
            string3 = string3 + this.toObject(javonMapping, this.intClassData, string + ".readInt()");
        } else if (this.longClassData.equals(classData)) {
            string3 = string3 + string + ".readLong()";
        } else if (this.LongClassData.equals(classData)) {
            string3 = string3 + this.toObject(javonMapping, this.longClassData, string + ".readLong()");
        } else if (this.shortClassData.equals(classData)) {
            string3 = string3 + string + ".readShort()";
        } else if (this.ShortClassData.equals(classData)) {
            string3 = string3 + this.toObject(javonMapping, this.shortClassData, string + ".readShort()");
        } else if (this.stringClassData.equals(classData)) {
            string3 = string3 + string + ".readUTF()";
        }
        if ("".equals(string3)) {
            throw new IllegalArgumentException("Invalid type: " + classData.getName());
        }
        if (string2 != null) {
            string3 = string3 + ";";
        }
        return string3;
    }

    @Override
    public Set<ClassData> getReferencedTypes(ClassData classData, Set<ClassData> set) {
        return Collections.singleton(classData);
    }
}

