/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.e2e.classdata.ClassDataRegistry;
import org.netbeans.modules.mobility.e2e.classdata.MethodData;
import org.netbeans.modules.mobility.e2e.classdata.MethodParameter;
import org.netbeans.modules.mobility.javon.JavonMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavonMappingImpl
implements JavonMapping {
    private Client clientMapping;
    private Server serverMapping;
    private Service serviceMapping;
    private Map<String, Service> serviceMappings;
    private ClassDataRegistry registry;
    private Map<String, Object> properties;
    private String servletURL;

    public JavonMappingImpl(ClassDataRegistry classDataRegistry) {
        this.registry = classDataRegistry;
        this.serviceMappings = new HashMap<String, Service>();
        this.properties = new HashMap<String, Object>();
    }

    private JavonMappingImpl() {
    }

    @Override
    public ClassDataRegistry getRegistry() {
        return this.registry;
    }

    public void setClientMapping(Client client) {
        this.clientMapping = client;
    }

    @Override
    public Client getClientMapping() {
        return this.clientMapping;
    }

    public void setServerMapping(Server server) {
        this.serverMapping = server;
    }

    @Override
    public JavonMapping.Server getServerMapping() {
        return this.serverMapping;
    }

    public void addServiceMaping(Service service) {
        this.serviceMappings.put(service.getType(), service);
    }

    @Override
    public JavonMapping.Service getServiceMapping(String string) {
        return this.serviceMappings.get(string);
    }

    @Override
    public Set<JavonMapping.Service> getServiceMappings() {
        return new HashSet<JavonMapping.Service>(this.serviceMappings.values());
    }

    public void setServletURL(String string) {
        this.servletURL = string;
    }

    @Override
    public String getServletURL() {
        return this.servletURL;
    }

    @Override
    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    @Override
    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Service
    implements JavonMapping.Service {
        public static final String STUB = "stub";
        public static final String SYNCHRONOUS = "synchronous";
        public static final String GROUPING = "grouping";
        private String packageName;
        private String className;
        private Set<MethodData> methods = new HashSet<MethodData>();

        public void setPackageName(String string) {
            this.packageName = string;
        }

        @Override
        public String getPackageName() {
            return this.packageName;
        }

        public void setClassName(String string) {
            this.className = string;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public String getType() {
            if (this.packageName.length() > 0) {
                return this.packageName + "." + this.className;
            }
            return this.className;
        }

        @Override
        public Set<MethodData> getMethods() {
            return Collections.unmodifiableSet(this.methods);
        }

        public void addMethod(MethodData methodData) {
            this.methods.add(methodData);
        }

        @Override
        public Set<ClassData> getParameterTypes() {
            HashSet<ClassData> hashSet = new HashSet<ClassData>();
            for (MethodData methodData : this.methods) {
                for (MethodParameter methodParameter : methodData.getParameters()) {
                    ClassData classData = methodParameter.getType();
                    hashSet.addAll(classData.getSerializer().getReferencedTypes(classData, hashSet));
                }
            }
            return Collections.unmodifiableSet(hashSet);
        }

        @Override
        public Set<ClassData> getReturnTypes() {
            HashSet<ClassData> hashSet = new HashSet<ClassData>();
            for (MethodData methodData : this.methods) {
                ClassData classData = methodData.getReturnType();
                hashSet.addAll(classData.getSerializer().getReferencedTypes(classData, hashSet));
            }
            return Collections.unmodifiableSet(hashSet);
        }

        @Override
        public Set<ClassData> getSupportedTypes() {
            HashSet<ClassData> hashSet = new HashSet<ClassData>();
            hashSet.addAll(this.getParameterTypes());
            hashSet.addAll(this.getReturnTypes());
            return hashSet;
        }
    }

    public static class Server
    implements JavonMapping.Server {
        private String location;
        private String port;
        private String servletLocation;
        private String projectName;
        private String packageName;
        private String className;
        private String outputDirectory;

        public void setLocation(String string) {
            this.location = string;
        }

        public String getLocation() {
            return this.location;
        }

        public void setPort(String string) {
            this.port = string;
        }

        public String getPort() {
            return this.port;
        }

        public void setServletLocation(String string) {
            this.servletLocation = string;
        }

        public String getServletLocation() {
            return this.servletLocation;
        }

        public void setProjectName(String string) {
            this.projectName = string;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public void setPackageName(String string) {
            this.packageName = string;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setClassName(String string) {
            this.className = string;
        }

        public String getClassName() {
            return this.className;
        }

        public void setOutputDirectory(String string) {
            this.outputDirectory = string;
        }

        public String getOutputDirectory() {
            return this.outputDirectory;
        }
    }

    public static class Client
    implements JavonMapping.Client {
        private String packageName;
        private String outputDirectory;
        private String className;

        public void setPackageName(String string) {
            this.packageName = string;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setOutputDirectory(String string) {
            this.outputDirectory = string;
        }

        public String getOutputDirectory() {
            return this.outputDirectory;
        }

        public void setClassName(String string) {
            this.className = string;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

