/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ContextRootConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.ConfigUtil;
import org.netbeans.modules.j2ee.weblogic9.config.gen.WeblogicWebApp;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class WarDeploymentConfiguration
implements ModuleConfiguration,
ContextRootConfiguration,
DeploymentPlanConfiguration,
PropertyChangeListener {
    private final File file;
    private final J2eeModule j2eeModule;
    private final DataObject dataObject;
    private WeblogicWebApp webLogicWebApp;

    public WarDeploymentConfiguration(J2eeModule j2eeModule) {
        this.j2eeModule = j2eeModule;
        this.file = j2eeModule.getDeploymentConfigurationFile("WEB-INF/weblogic.xml");
        this.getWeblogicWebApp();
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)FileUtil.toFileObject((File)this.file));
            dataObject.addPropertyChangeListener((PropertyChangeListener)this);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        this.dataObject = dataObject;
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public J2eeModule getJ2eeModule() {
        return this.j2eeModule;
    }

    public void dispose() {
        if (this.dataObject != null) {
            this.dataObject.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "modified" && propertyChangeEvent.getNewValue() == Boolean.FALSE) {
            WarDeploymentConfiguration warDeploymentConfiguration = this;
            synchronized (warDeploymentConfiguration) {
                this.webLogicWebApp = null;
            }
        }
    }

    public synchronized WeblogicWebApp getWeblogicWebApp() {
        if (this.webLogicWebApp == null) {
            try {
                if (this.file.exists()) {
                    try {
                        this.webLogicWebApp = WeblogicWebApp.createGraph(this.file);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    catch (RuntimeException runtimeException) {}
                } else {
                    this.webLogicWebApp = this.genereateWeblogicWebApp();
                    ConfigUtil.writefile(this.file, this.webLogicWebApp);
                }
            }
            catch (ConfigurationException configurationException) {
                Exceptions.printStackTrace((Throwable)configurationException);
            }
        }
        return this.webLogicWebApp;
    }

    public void save(OutputStream outputStream) throws ConfigurationException {
        WeblogicWebApp weblogicWebApp = this.getWeblogicWebApp();
        if (weblogicWebApp == null) {
            String string = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_cannotSaveNotParseableConfFile", (Object)this.file.getPath());
            throw new ConfigurationException(string);
        }
        try {
            weblogicWebApp.write(outputStream);
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.file.getPath());
            throw new ConfigurationException(string, (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyWeblogicWebApp(WeblogicWebAppModifier weblogicWebAppModifier) throws ConfigurationException {
        assert (this.dataObject != null) : "DataObject has not been initialized yet";
        try {
            Object object;
            EditorCookie editorCookie = (EditorCookie)this.dataObject.getCookie(EditorCookie.class);
            StyledDocument styledDocument = editorCookie.getDocument();
            if (styledDocument == null) {
                styledDocument = editorCookie.openDocument();
            }
            WeblogicWebApp weblogicWebApp = null;
            try {
                byte[] byArray = styledDocument.getText(0, styledDocument.getLength()).getBytes();
                weblogicWebApp = WeblogicWebApp.createGraph(new ByteArrayInputStream(byArray));
            }
            catch (RuntimeException runtimeException) {
                object = this.getWeblogicWebApp();
                if (object == null) {
                    String string = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_configFileCannotParse", (Object)this.file.getPath());
                    throw new ConfigurationException(string);
                }
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_weblogicXmlNotValid"), 2);
                Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (object2 == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                weblogicWebApp = object;
            }
            weblogicWebAppModifier.modify(weblogicWebApp);
            boolean bl = this.dataObject.isModified();
            this.replaceDocument(styledDocument, weblogicWebApp);
            if (!bl && (object = (SaveCookie)this.dataObject.getCookie(SaveCookie.class)) != null) {
                object.save();
            }
            object = this;
            synchronized (object) {
                this.webLogicWebApp = weblogicWebApp;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.file.getPath());
            throw new ConfigurationException(string, (Throwable)iOException);
        }
    }

    private WeblogicWebApp genereateWeblogicWebApp() {
        WeblogicWebApp weblogicWebApp = new WeblogicWebApp();
        weblogicWebApp.createAttribute("xmlns:j2ee", "xmlns:j2ee", 513, null, null);
        weblogicWebApp.setAttributeValue("xmlns:j2ee", "http://java.sun.com/xml/ns/j2ee");
        weblogicWebApp.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        weblogicWebApp.setAttributeValue("xsi:schemaLocation", "http://www.bea.com/ns/weblogic/90 http://www.bea.com/ns/weblogic/90/weblogic-web-app.xsd");
        weblogicWebApp.setContextRoot(new String[]{""});
        return weblogicWebApp;
    }

    private void replaceDocument(final StyledDocument styledDocument, BaseBean baseBean) {
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            baseBean.write((OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)new Runnable(){

            public void run() {
                try {
                    styledDocument.remove(0, styledDocument.getLength());
                    styledDocument.insertString(0, byteArrayOutputStream.toString(), null);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
        });
    }

    private boolean isCorrectCP(String string) {
        boolean bl = true;
        if (!string.equals("") && !string.startsWith("/")) {
            bl = false;
        } else if (string.endsWith("/")) {
            bl = false;
        } else if (string.indexOf("//") >= 0) {
            bl = false;
        }
        return bl;
    }

    public String getContextRoot() throws ConfigurationException {
        WeblogicWebApp weblogicWebApp = this.getWeblogicWebApp();
        if (weblogicWebApp == null) {
            String string = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotReadContextRoot", (Object)this.file.getPath());
            throw new ConfigurationException(string);
        }
        return weblogicWebApp.getContextRoot(0);
    }

    public void setContextRoot(String string) throws ConfigurationException {
        String string2;
        if (!this.isCorrectCP(string)) {
            string2 = string;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append("/" + stringTokenizer.nextToken());
            }
            string2 = stringBuffer.toString();
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_invalidCP", (Object)string), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            string = string2;
        }
        string2 = string;
        this.modifyWeblogicWebApp(new WeblogicWebAppModifier(){

            public void modify(WeblogicWebApp weblogicWebApp) {
                weblogicWebApp.setContextRoot(new String[]{string2});
            }
        });
    }

    private static interface WeblogicWebAppModifier {
        public void modify(WeblogicWebApp var1);
    }
}

