/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.cnd.remote.support.RemoteConnectionSupport;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.openide.util.Exceptions;

public class RemoteCopySupport
extends RemoteConnectionSupport {
    public RemoteCopySupport(ExecutionEnvironment executionEnvironment) {
        super(executionEnvironment);
    }

    public static boolean copyFrom(ExecutionEnvironment executionEnvironment, String string, String string2) {
        RemoteCopySupport remoteCopySupport = new RemoteCopySupport(executionEnvironment);
        return remoteCopySupport.copyFrom(string, string2);
    }

    public boolean copyFrom(String string, String string2) {
        boolean bl;
        long l = System.currentTimeMillis();
        Future future = CommonTasksSupport.downloadFile((String)string, (ExecutionEnvironment)this.executionEnvironment, (String)string2, null);
        try {
            int n = (Integer)future.get();
            bl = n == 0;
        }
        catch (InterruptedException interruptedException) {
            bl = false;
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
            bl = false;
        }
        RemoteUtil.LOGGER.finest("Copying: size=" + new File(string2).length() + ", file=" + string2 + " took " + (System.currentTimeMillis() - l) + " ms");
        return bl;
    }

    public static boolean copyTo(ExecutionEnvironment executionEnvironment, String string, String string2) {
        RemoteCopySupport remoteCopySupport = new RemoteCopySupport(executionEnvironment);
        return remoteCopySupport.copyTo(string, string2);
    }

    public boolean copyTo(String string, String string2) {
        Future future = CommonTasksSupport.uploadFile((String)string, (ExecutionEnvironment)this.executionEnvironment, (String)string2, (int)509, null);
        try {
            Integer n = (Integer)future.get();
            if (n != null) {
                return n == 0;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            Exceptions.printStackTrace((Throwable)executionException);
        }
        return false;
    }

    private static int checkAck(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == 0) {
            return n;
        }
        if (n == -1) {
            return n;
        }
        if (n == 1 || n == 2) {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            do {
                n2 = inputStream.read();
                stringBuilder.append((char)n2);
            } while (n2 != 10);
            if (n == 1) {
                RemoteUtil.LOGGER.warning("Error: Invalid value during reading remote string: " + stringBuilder.toString());
            }
            if (n == 2) {
                RemoteUtil.LOGGER.warning("Fatal error: Invalid value during reading remote string: " + stringBuilder.toString());
            }
        }
        return n;
    }
}

