/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProvider;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProviderLinux;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProviderSamba;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProviderSolaris;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProviderWindows;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostMappingsAnalyzer {
    private final PlatformInfo secondPI;
    private final PlatformInfo firstPI;
    private static final List<HostMappingProvider> pairedProviders = new ArrayList<HostMappingProvider>();
    private static final List<HostMappingProvider> singularProviders = new ArrayList<HostMappingProvider>();

    public HostMappingsAnalyzer(ExecutionEnvironment executionEnvironment) {
        this(executionEnvironment, ExecutionEnvironmentFactory.getLocal());
    }

    private HostMappingsAnalyzer(ExecutionEnvironment executionEnvironment, ExecutionEnvironment executionEnvironment2) {
        this.secondPI = PlatformInfo.getDefault((ExecutionEnvironment)executionEnvironment);
        this.firstPI = PlatformInfo.getDefault((ExecutionEnvironment)executionEnvironment2);
    }

    public Map<String, String> getMappings() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map<String, String> map = this.populateMappingsList(this.firstPI, this.secondPI);
        Map<String, String> map2 = this.populateMappingsList(this.secondPI, this.firstPI);
        if (map.size() > 0 && map2.size() > 0) {
            for (Map.Entry object : map.entrySet()) {
                for (Map.Entry<String, String> entry : map2.entrySet()) {
                    if (!((String)object.getKey()).equals(entry.getKey())) continue;
                    hashMap.put((String)object.getValue(), entry.getValue());
                }
            }
        }
        for (HostMappingProvider hostMappingProvider : singularProviders) {
            Map<String, String> map3;
            if (hostMappingProvider.isApplicable(this.secondPI, this.firstPI)) {
                map3 = hostMappingProvider.findMappings(this.secondPI.getExecutionEnvironment(), this.firstPI.getExecutionEnvironment());
                hashMap.putAll(map3);
            }
            if (!hostMappingProvider.isApplicable(this.firstPI, this.secondPI)) continue;
            map3 = hostMappingProvider.findMappings(this.firstPI.getExecutionEnvironment(), this.secondPI.getExecutionEnvironment());
            hashMap.putAll(map3);
        }
        return hashMap;
    }

    private Map<String, String> populateMappingsList(PlatformInfo platformInfo, PlatformInfo platformInfo2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (HostMappingProvider hostMappingProvider : pairedProviders) {
            if (!hostMappingProvider.isApplicable(platformInfo, platformInfo2)) continue;
            hashMap.putAll(hostMappingProvider.findMappings(platformInfo.getExecutionEnvironment(), platformInfo2.getExecutionEnvironment()));
        }
        return hashMap;
    }

    static {
        pairedProviders.add(new HostMappingProviderWindows());
        pairedProviders.add(new HostMappingProviderSamba());
        singularProviders.add(new HostMappingProviderSolaris());
        singularProviders.add(new HostMappingProviderLinux());
    }
}

