/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.internal.parsing.AttributeNode;
import oracle.toplink.essentials.internal.parsing.BinaryOperatorNode;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.TypeHelper;

public class EqualsAssignmentNode
extends BinaryOperatorNode {
    public void validate(ParseTreeContext context) {
        super.validate(context);
        this.validateTarget(this.left, context);
    }

    private void validateTarget(Node node, ParseTreeContext context) {
        if (node.isDotNode()) {
            AttributeNode attributeNode;
            String attribute;
            Node path;
            Object type;
            TypeHelper typeHelper = context.getTypeHelper();
            if (typeHelper.isSingleValuedRelationship(type = (path = node.getLeft()).getType(), attribute = (attributeNode = (AttributeNode)node.getRight()).getAttributeName()) || typeHelper.isSimpleStateAttribute(type, attribute)) {
                this.validateNavigation(path, context);
            } else {
                throw EJBQLException.invalidSetClauseTarget(context.getQueryInfo(), attributeNode.getLine(), attributeNode.getColumn(), path.getAsString(), attribute);
            }
        }
    }

    private void validateNavigation(Node qualifier, ParseTreeContext context) {
        if (qualifier.isDotNode()) {
            TypeHelper typeHelper = context.getTypeHelper();
            Node left = qualifier.getLeft();
            AttributeNode attributeNode = (AttributeNode)qualifier.getRight();
            String attribute = attributeNode.getAttributeName();
            Object type = left.getType();
            if (!typeHelper.isEmbeddedAttribute(type, attribute)) {
                throw EJBQLException.invalidSetClauseNavigation(context.getQueryInfo(), attributeNode.getLine(), attributeNode.getColumn(), qualifier.getAsString(), attribute);
            }
            this.validateNavigation(left, context);
        }
    }
}

