/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.api.support.DataModelSchemeProvider;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.dataprovider.StackDataProvider;
import org.netbeans.modules.dlight.core.stack.ui.MultipleCallStackPanel;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.util.ui.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StackRenderer
implements Renderer<DataRow> {
    private final Lock lock = new Lock();
    private final List<DataTableMetadata.Column> stackColumns;
    private boolean stackDataProviderSearched;
    private StackDataProvider stackDataProvider;

    public StackRenderer(List<DataTableMetadata.Column> list) {
        this.stackColumns = Collections.unmodifiableList(new ArrayList<DataTableMetadata.Column>(list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JComponent render(final DataRow dataRow) {
        Lock lock = this.lock;
        synchronized (lock) {
            final StackDataProvider stackDataProvider = this.findStackDataProvider();
            final MultipleCallStackPanel multipleCallStackPanel = MultipleCallStackPanel.createInstance(stackDataProvider);
            if (stackDataProvider != null) {
                DLightExecutorService.submit((Runnable)new Runnable(){

                    public void run() {
                        final Vector<List<FunctionCall>> vector = new Vector<List<FunctionCall>>();
                        vector.setSize(StackRenderer.this.stackColumns.size());
                        final DataTableMetadata.Column[] columnArray = StackRenderer.this.stackColumns.toArray(new DataTableMetadata.Column[0]);
                        int n = columnArray.length;
                        for (int i = 0; i < n; ++i) {
                            DataTableMetadata.Column column = columnArray[i];
                            int n2 = DataUtil.toInt((Object)dataRow.getData(column.getColumnName()));
                            if (0 >= n2) continue;
                            vector.set(i, stackDataProvider.getCallStack(n2));
                        }
                        UIThread.invoke((Runnable)new Runnable(){

                            public void run() {
                                int n = columnArray.length;
                                for (int i = 0; i < n; ++i) {
                                    DataTableMetadata.Column column = columnArray[i];
                                    List list = (List)vector.get(i);
                                    if (list == null) continue;
                                    multipleCallStackPanel.add(column.getColumnUName(), true, (List<FunctionCall>)list);
                                }
                                multipleCallStackPanel.expandAll();
                            }
                        });
                    }
                }, (String)"Fill-in panel for a stack in StackRenderer");
            }
            return multipleCallStackPanel;
        }
    }

    private synchronized StackDataProvider findStackDataProvider() {
        if (this.stackDataProvider == null && !this.stackDataProviderSearched) {
            DLightSession dLightSession = DLightManager.getDefault().getActiveSession();
            this.stackDataProvider = (StackDataProvider)dLightSession.createDataProvider(DataModelSchemeProvider.getInstance().getScheme("model:stack"), null);
            this.stackDataProviderSearched = true;
        }
        return this.stackDataProvider;
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

