/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.Controller;
import freemind.main.XMLParseException;
import freemind.view.MapModule;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;

public class LastOpenedList {
    private Controller c;
    private int maxEntries = 25;
    private List lastOpenedList = new LinkedList();
    private Map mRestorableToMapName = new HashMap();

    LastOpenedList(Controller c, String restored) {
        this.c = c;
        this.maxEntries = new Integer(c.getFrame().getProperty("last_opened_list_length"));
        this.load(restored);
    }

    void mapOpened(MapModule mapModule) {
        if (mapModule == null || mapModule.getModel() == null) {
            return;
        }
        String restoreString = mapModule.getModel().getRestoreable();
        if (restoreString == null) {
            return;
        }
        if (this.lastOpenedList.contains(restoreString)) {
            this.lastOpenedList.remove(restoreString);
        }
        this.lastOpenedList.add(0, restoreString);
        this.mRestorableToMapName.put(restoreString, mapModule.toString());
        while (this.lastOpenedList.size() > this.maxEntries) {
            this.lastOpenedList.remove(this.lastOpenedList.size() - 1);
        }
    }

    void mapClosed(MapModule map) {
    }

    String save() {
        String str = new String();
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            str = str.concat((String)it.next() + ";");
        }
        return str;
    }

    void load(String data) {
        if (data != null) {
            StringTokenizer token = new StringTokenizer(data, ";");
            while (token.hasMoreTokens()) {
                this.lastOpenedList.add(token.nextToken());
            }
        }
    }

    public void open(String restoreable) throws FileNotFoundException, XMLParseException, MalformedURLException, IOException, URISyntaxException {
        String mode;
        StringTokenizer token;
        boolean changedToMapModule = this.c.getMapModuleManager().tryToChangeToMapModule((String)this.mRestorableToMapName.get(restoreable));
        if (restoreable != null && !changedToMapModule && (token = new StringTokenizer(restoreable, ":")).hasMoreTokens() && this.c.createNewMode(mode = token.nextToken())) {
            String fileName = token.nextToken("").substring(1);
            this.c.getMode().restore(fileName);
        }
    }

    ListIterator listIterator() {
        return this.lastOpenedList.listIterator();
    }
}

