/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.wizard;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.limewire.core.api.Application;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.components.ToggleExtenderListener;
import org.limewire.ui.swing.options.LearnMoreButton;
import org.limewire.ui.swing.wizard.SetupComponentDecorator;

public abstract class WizardPage
extends JPanel {
    private final SetupComponentDecorator decorator;
    private final Application application;

    public WizardPage(SetupComponentDecorator decorator, Application application) {
        this.decorator = decorator;
        this.application = application;
    }

    public abstract void applySettings();

    public abstract String getLine1();

    public abstract String getLine2();

    public abstract String getFooter();

    protected JLabel createAndDecorateHeader(String text) {
        JLabel label = new JLabel("<html>" + text + "</html>");
        this.decorator.decorateHeadingText(label);
        return label;
    }

    protected JLabel createAndDecorateMultiLine(String text, JCheckBox checkBox) {
        MultiLineLabel label = new MultiLineLabel(text, 500);
        label.addMouseListener(new ToggleExtenderListener(checkBox));
        this.decorator.decorateNormalText(label);
        return label;
    }

    protected Component createAndDecorateMultiLine(String text) {
        MultiLineLabel label = new MultiLineLabel(text, 500);
        this.decorator.decorateNormalText(label);
        return label;
    }

    protected Component createAndDecorateSubHeading(String text) {
        MultiLineLabel label = new MultiLineLabel(text, 500);
        this.decorator.decorateSubHeading(label);
        return label;
    }

    protected JCheckBox createAndDecorateCheckBox(boolean isSelected) {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setSelected(isSelected);
        this.decorator.decorateLargeCheckBox(checkBox);
        return checkBox;
    }

    protected HyperlinkButton createAndDecorateHyperlink(String url) {
        LearnMoreButton learnMoreButton = new LearnMoreButton(url, this.application);
        this.decorator.decorateLink(learnMoreButton);
        return learnMoreButton;
    }
}

