/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.shell;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.limewire.ui.swing.shell.FileTypeAssociation;
import org.limewire.ui.swing.shell.LimeAssociationOption;
import org.limewire.ui.swing.shell.MagnetAssociation;
import org.limewire.ui.swing.shell.OSXFileTypeAssociation;
import org.limewire.ui.swing.shell.OSXURLSchemeAssociation;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.ResourceUtils;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;

public class LimeAssociations {
    private static final String PROGRAM = OSUtils.isWindows() ? "LimeWire" : (OSUtils.isUnix() ? System.getProperty("unix.executable", "") : "");
    private static final String UNSUPPORTED_PLATFORM = "";
    private static Map<AssociationType, LimeAssociationOption> fileAssociations = null;

    public static synchronized boolean anyAssociationsSupported() {
        return LimeAssociations.isTorrentAssociationSupported() || LimeAssociations.isMagnetAssociationSupported();
    }

    public static synchronized boolean isTorrentAssociationSupported() {
        return LimeAssociations.getTorrentAssociation() != null;
    }

    public static synchronized boolean isMagnetAssociationSupported() {
        return LimeAssociations.getMagnetAssociation() != null;
    }

    public static LimeAssociationOption getTorrentAssociation() {
        return LimeAssociations.getSupportedAssociations().get((Object)AssociationType.TORRENT);
    }

    public static LimeAssociationOption getMagnetAssociation() {
        return LimeAssociations.getSupportedAssociations().get((Object)AssociationType.MAGNET);
    }

    private static Map<AssociationType, LimeAssociationOption> getSupportedAssociations() {
        if (fileAssociations == null) {
            if (OSUtils.isWindows() || OSUtils.isLinux()) {
                if (!ResourceUtils.isJdicLibraryLoaded()) {
                    fileAssociations = Collections.emptyMap();
                } else {
                    String runningPath;
                    fileAssociations = new HashMap<AssociationType, LimeAssociationOption>();
                    String fileOpener = null;
                    String fileIcon = null;
                    String protocolOpener = null;
                    if (OSUtils.isWindows() && (runningPath = SystemUtils.getRunningPath()) != null && runningPath.endsWith(PROGRAM + ".exe")) {
                        protocolOpener = runningPath;
                        fileOpener = "\"" + runningPath + "\" \"%1\"";
                        fileIcon = runningPath + ",1";
                    }
                    if (fileOpener != null) {
                        FileTypeAssociation file = new FileTypeAssociation("torrent", "application/x-bittorrent", fileOpener, "open", "LimeWire Torrent", fileIcon);
                        LimeAssociationOption torrent = new LimeAssociationOption(file, ".torrent", I18n.tr("\".torrent\" files"));
                        fileAssociations.put(AssociationType.TORRENT, torrent);
                    }
                    if (protocolOpener != null) {
                        MagnetAssociation mag = new MagnetAssociation(PROGRAM, protocolOpener);
                        LimeAssociationOption magOption = new LimeAssociationOption(mag, "magnet:", I18n.tr("\"magnet:\" links"));
                        fileAssociations.put(AssociationType.MAGNET, magOption);
                    }
                }
            } else if (OSUtils.isMacOSX()) {
                fileAssociations = new HashMap<AssociationType, LimeAssociationOption>();
                if (OSXFileTypeAssociation.isNativeLibraryLoadedCorrectly()) {
                    LimeAssociationOption torrent = new LimeAssociationOption(new OSXFileTypeAssociation("torrent"), ".torrent", I18n.tr("\".torrent\" files"));
                    fileAssociations.put(AssociationType.TORRENT, torrent);
                    LimeAssociationOption magnet = new LimeAssociationOption(new OSXURLSchemeAssociation("magnet"), "magnet:", I18n.tr("\".magnet:\" links"));
                    fileAssociations.put(AssociationType.MAGNET, magnet);
                }
            }
        }
        return Collections.unmodifiableMap(fileAssociations);
    }

    private static enum AssociationType {
        TORRENT,
        MAGNET;

    }
}

