/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXTable;
import org.limewire.bittorrent.Torrent;
import org.limewire.bittorrent.TorrentStatus;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadPropertyKey;
import org.limewire.core.api.download.DownloadSourceInfo;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.ui.swing.components.decorators.TableDecorator;
import org.limewire.ui.swing.properties.FileInfoDialog;
import org.limewire.ui.swing.properties.FileInfoPanel;
import org.limewire.ui.swing.table.DefaultLimeTableCellRenderer;
import org.limewire.ui.swing.util.FontUtils;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class FileInfoTransfersPanel
implements FileInfoPanel {
    @Resource
    private Icon lockIcon;
    @Resource
    private Color foreground;
    @Resource
    private Font smallFont;
    private final JPanel component;
    private final FileInfoDialog.FileInfoType type;
    private final DownloadItem download;
    private DownloadStatusListener downloadStatus;
    private final JXTable infoTable;
    private final Timer refreshTimer;
    private final JLabel leechersLabel;
    private final JLabel seedersLabel;

    public FileInfoTransfersPanel(FileInfoDialog.FileInfoType type, DownloadItem download, TableDecorator tableDecorator) {
        this.type = type;
        this.download = download;
        GuiUtils.assignResources(this);
        this.component = new JPanel(new MigLayout("fillx, gap 0"));
        this.infoTable = new JXTable();
        tableDecorator.decorate(this.infoTable);
        this.infoTable.setSortable(false);
        this.infoTable.setCellSelectionEnabled(false);
        this.infoTable.setShowGrid(false, false);
        this.infoTable.setEditable(false);
        this.component.add((Component)new JScrollPane(this.infoTable), "gaptop 10, span, grow, wrap");
        this.component.add((Component)this.createBoldLabel(I18n.tr("Total Completed:")), "split 2, gaptop 10");
        JLabel percentLabel = this.createPlainLabel("");
        this.component.add((Component)percentLabel, "wrap");
        this.downloadStatus = new DownloadStatusListener(percentLabel);
        download.addPropertyChangeListener(this.downloadStatus);
        if (download.getDownloadItemType() == DownloadItem.DownloadItemType.BITTORRENT) {
            this.component.add((Component)this.createBoldLabel(I18n.tr("Total Leechers:")), "split 2");
            this.leechersLabel = this.createPlainLabel("");
            this.component.add((Component)this.leechersLabel, "wrap");
            this.component.add((Component)this.createBoldLabel(I18n.tr("Total Seeders:")), "split 2");
            this.seedersLabel = this.createPlainLabel("");
            this.component.add((Component)this.seedersLabel, "wrap");
        } else {
            this.leechersLabel = null;
            this.seedersLabel = null;
        }
        this.init();
        this.refreshTimer = new Timer(1500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileInfoTransfersPanel.this.init();
            }
        });
        this.refreshTimer.start();
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public void save() {
    }

    @Override
    public void updatePropertiableFile(PropertiableFile file) {
    }

    @Override
    public void dispose() {
        this.refreshTimer.stop();
        if (this.downloadStatus != null) {
            this.download.removePropertyChangeListener(this.downloadStatus);
        }
    }

    private void init() {
        switch (this.type) {
            case DOWNLOADING_FILE: {
                DefaultTableModel model = new DefaultTableModel();
                model.setColumnIdentifiers(new Object[]{I18n.tr("Address"), "", I18n.tr("Client"), I18n.tr("Upload"), I18n.tr("Download")});
                for (DownloadSourceInfo info : this.download.getSourcesDetails()) {
                    model.addRow(new Object[]{info.getIPAddress(), info.isEncyrpted(), info.getClientName(), GuiUtils.formatUnitFromBytesPerSec(Math.round(info.getUploadSpeed())), GuiUtils.formatUnitFromBytesPerSec(Math.round(info.getDownloadSpeed()))});
                }
                this.infoTable.setModel(model);
                TableColumn column = this.infoTable.getColumn(1);
                column.setCellRenderer(new LockRenderer());
                column.setMaxWidth(12);
                column.setMinWidth(12);
                column.setWidth(12);
                if (this.download.getDownloadItemType() != DownloadItem.DownloadItemType.BITTORRENT) break;
                Torrent torrent = (Torrent)this.download.getDownloadProperty(DownloadPropertyKey.TORRENT);
                TorrentStatus status = torrent.getStatus();
                this.seedersLabel.setText(status.getNumComplete() < 0 ? "?" : "" + status.getNumComplete());
                this.leechersLabel.setText(status.getNumIncomplete() < 0 ? "?" : "" + status.getNumIncomplete());
            }
        }
    }

    private JLabel createBoldLabel(String text) {
        JLabel label = this.createPlainLabel(text);
        FontUtils.bold(label);
        return label;
    }

    private JLabel createPlainLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(this.smallFont);
        label.setForeground(this.foreground);
        return label;
    }

    private class LockRenderer
    extends DefaultLimeTableCellRenderer {
        public LockRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == Boolean.TRUE) {
                this.setIcon(FileInfoTransfersPanel.this.lockIcon);
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    private class DownloadStatusListener
    implements PropertyChangeListener {
        private final JLabel label;

        public DownloadStatusListener(JLabel label) {
            this.label = label;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DownloadStatusListener.this.label.setText(I18n.tr("{0}%", FileInfoTransfersPanel.this.download.getPercentComplete()));
                }
            });
        }
    }
}

