/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.limewire.setting.Setting;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;

public class OptionPanelStateManager {
    private final Map<Setting, Object> activeSettingMap = new HashMap<Setting, Object>();
    private final Map<Setting, SettingListener> settingListeners = new HashMap<Setting, SettingListener>();
    private final Set<SettingChangedListener> listeners = new HashSet<SettingChangedListener>();

    @Inject
    public OptionPanelStateManager() {
    }

    public Object getValue(Setting setting) {
        Object value = this.activeSettingMap.get(setting);
        if (value != null) {
            return value;
        }
        return setting.get();
    }

    public void setValue(Setting setting, Object value) {
        Object savedValue = this.activeSettingMap.get(setting);
        if (savedValue == null || !savedValue.equals(value)) {
            this.activeSettingMap.put(setting, value);
            this.fireChanges(setting);
        }
    }

    public void saveSettings() {
        for (Setting key : this.activeSettingMap.keySet()) {
            Object value = this.activeSettingMap.get(key);
            if (value == null) continue;
            key.set(value);
        }
    }

    public boolean hasPendingChanges() {
        for (Setting key : this.activeSettingMap.keySet()) {
            Object savedValue = this.activeSettingMap.get(key);
            if (savedValue == null || savedValue.equals(key.get())) continue;
            return true;
        }
        return false;
    }

    private void fireChanges(Setting setting) {
        for (SettingChangedListener listener : this.listeners) {
            listener.settingChanged(setting);
        }
    }

    public void addSettingChangedListener(SettingChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSettingChangedListener(SettingChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void registerSettingListener(final Setting setting) {
        SettingListener settingListener = this.settingListeners.get(setting);
        if (settingListener == null) {
            settingListener = new SettingListener(){

                @Override
                public void settingChanged(SettingEvent evt) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OptionPanelStateManager.this.setValue(setting, setting.get());
                        }
                    });
                }
            };
            setting.addSettingListener(settingListener);
            this.settingListeners.put(setting, settingListener);
        }
    }

    public void initOptions() {
        for (Setting setting : this.activeSettingMap.keySet()) {
            this.setValue(setting, setting.get());
        }
    }

    public static interface SettingChangedListener {
        public void settingChanged(Setting var1);
    }
}

