/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.limewire.core.api.library.LibraryFileList;
import org.limewire.core.api.library.LocalFileList;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.library.LibrarySelected;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.I18n;

class RemoveFromAllListAction
extends AbstractAction {
    private final Provider<List<File>> selectedFiles;
    private final SharedFileListManager manager;

    @Inject
    public RemoveFromAllListAction(@LibrarySelected Provider<List<File>> selectedFiles, @LibrarySelected Provider<LocalFileList> selectedLocalFileList, SharedFileListManager manager) {
        if (selectedLocalFileList == null || selectedLocalFileList.get() instanceof LibraryFileList) {
            this.putValue("Name", I18n.tr("Remove from All Other Lists"));
        } else {
            this.putValue("Name", I18n.tr("Remove from All Lists"));
        }
        this.selectedFiles = selectedFiles;
        this.manager = manager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final ArrayList files = new ArrayList(this.selectedFiles.get());
        int confirmation = FocusJOptionPane.showConfirmDialog(null, this.getMessage(files.size()), I18n.tr("Remove from Lists"), 2);
        if (confirmation == 0) {
            final ArrayList<SharedFileList> sharedFileLists = new ArrayList<SharedFileList>(this.manager.getModel());
            BackgroundExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    for (File file : files) {
                        for (SharedFileList sharedFileList : sharedFileLists) {
                            sharedFileList.removeFile(file);
                        }
                    }
                }
            });
        }
    }

    private String getMessage(int selectedCount) {
        if (selectedCount == 1) {
            return I18n.tr("Remove this file from All Lists?");
        }
        return I18n.tr("Remove {0} files from All Lists?", selectedCount);
    }
}

