/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.sharing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.application.Resource;
import org.limewire.friend.api.Network;
import org.limewire.ui.swing.library.sharing.EditableSharingData;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

class LibrarySharingEditableRendererEditor
extends JCheckBox
implements TableCellRenderer,
TableCellEditor {
    @Resource
    private Font font;
    @Resource
    private Color fontColor;
    @Resource
    private Color backgroundColor;
    @Resource
    private Icon checkedCheckBox;
    @Resource
    private Icon uncheckedCheckBox;
    private final List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
    private EditableSharingData data;

    public LibrarySharingEditableRendererEditor() {
        GuiUtils.assignResources(this);
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.setIcon(this.uncheckedCheckBox);
        this.setSelectedIcon(this.checkedCheckBox);
        this.setOpaque(false);
        this.setIconTextGap(6);
        this.setFont(this.font);
        this.setFocusPainted(false);
        this.setForeground(this.fontColor);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LibrarySharingEditableRendererEditor.this.data != null) {
                    LibrarySharingEditableRendererEditor.this.data.setSelected(LibrarySharingEditableRendererEditor.this.isSelected());
                }
                LibrarySharingEditableRendererEditor.this.stopCellEditing();
            }
        });
        this.setBackground(this.backgroundColor);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof EditableSharingData) {
            this.data = (EditableSharingData)value;
            this.setText(this.textFor(this.data));
            this.setSelected(this.data.isSelected());
            this.setToolTipText(this.getToolTipText(this.data));
        } else {
            this.setText("");
            this.setSelected(false);
            this.setToolTipText("");
        }
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof EditableSharingData) {
            EditableSharingData data = (EditableSharingData)value;
            this.setText(this.textFor(data));
            this.setSelected(data.isSelected());
            this.setToolTipText(this.getToolTipText(data));
        } else {
            this.setText("");
            this.setSelected(false);
            this.setToolTipText("");
        }
        return this;
    }

    private String getToolTipText(EditableSharingData data) {
        if (data.getFriend() != null) {
            if (data.getFriend().getNetwork().getType() != Network.Type.FACEBOOK) {
                return data.getFriend().getRenderName() + " <" + data.getFriend().getId() + ">";
            }
            return data.getFriend().getRenderName();
        }
        return I18n.tr("{0} friends from other accounts", data.getIds().size());
    }

    private String textFor(EditableSharingData data) {
        if (data.getFriend() != null) {
            return data.getFriend().getRenderName();
        }
        return I18n.tr("{0} friends from other accounts", data.getIds().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCellEditorListener(CellEditorListener lis) {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(lis)) {
                this.listeners.add(lis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelCellEditing() {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            int N = this.listeners.size();
            for (int i = 0; i < N; ++i) {
                this.listeners.get(i).editingCanceled(new ChangeEvent(this));
            }
        }
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCellEditorListener(CellEditorListener lis) {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(lis)) {
                this.listeners.remove(lis);
            }
        }
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopCellEditing() {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            int N = this.listeners.size();
            for (int i = 0; i < N; ++i) {
                this.listeners.get(i).editingStopped(new ChangeEvent(this));
            }
        }
        return true;
    }
}

