/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.library.navigator.LibraryNavItem;
import org.limewire.ui.swing.library.navigator.LibraryNavigatorPanel;
import org.limewire.ui.swing.util.FileChooser;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.warnings.LibraryWarningController;

public class AddFileAction
extends AbstractAction {
    private final Provider<LibraryNavigatorPanel> libraryNavigatorPanel;
    private final LibraryWarningController librarySupport;

    @Inject
    public AddFileAction(Provider<LibraryNavigatorPanel> libraryNavigatorPanel, LibraryWarningController librarySupport) {
        super(I18n.tr("Add Files"));
        this.libraryNavigatorPanel = libraryNavigatorPanel;
        this.librarySupport = librarySupport;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LibraryNavItem item;
        List<File> files = FileChooser.getInput(GuiUtils.getMainFrame(), I18n.tr("Add File(s)"), I18n.tr("Add File(s)"), FileChooser.getLastInputDirectory(), 2, 0, true, new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.exists();
            }

            @Override
            public String getDescription() {
                return I18n.tr("All Files and Folders");
            }
        });
        if (files != null && (item = this.libraryNavigatorPanel.get().getSelectedNavItem()) != null) {
            this.librarySupport.addFiles(item.getLocalFileList(), files);
        }
    }
}

