/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.promotion;

import com.google.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.limewire.promotion.KeywordUtil;
import org.limewire.util.ByteUtils;
import org.limewire.util.I18NConvert;
import org.limewire.util.StringUtils;

@Singleton
public final class KeywordUtilImpl
implements KeywordUtil {
    private final Set<String> stopwords = new HashSet<String>();

    public KeywordUtilImpl() {
        this.initEnglishStopwords();
    }

    @Override
    public List<String> splitKeywords(String keywords) {
        ArrayList<String> list = new ArrayList<String>();
        for (String word : keywords.split("\t")) {
            list.add(this.normalizeQuery(word));
        }
        return list;
    }

    private void initEnglishStopwords() {
        for (String word : new String[]{"i", "a", "s", "about", "an", "are", "as", "at", "be", "by", "com", "de", "en", "for", "from", "how", "in", "is", "it", "la", "of", "on", "or", "that", "the", "this", "to", "was", "what", "when", "where", "who", "will", "with", "und", "www"}) {
            this.addEnglishStopword(word);
        }
    }

    public void addEnglishStopword(String word) {
        this.stopwords.add(word);
    }

    String stripPunctuation(String query) {
        return query.replaceAll("[,.!?<>:;\\*'\"\\$\\s]", " ");
    }

    @Override
    public String normalizeQuery(String query) {
        if (query == null) {
            return null;
        }
        query = this.stripPunctuation(query);
        query = I18NConvert.instance().getNorm(query);
        String[] queryArray = this.sortAlphabetically(query.split(" "));
        queryArray = this.stripEnglishStopWords(queryArray);
        return this.unsplitString(queryArray);
    }

    String unsplitString(String[] words) {
        StringBuilder builder = new StringBuilder();
        for (String word : words) {
            builder.append(word).append(' ');
        }
        return builder.substring(0, builder.length() - 1);
    }

    String[] sortAlphabetically(String[] words) {
        String[] sorted = new String[words.length];
        System.arraycopy(words, 0, sorted, 0, words.length);
        class AlphaComparator
        implements Comparator<String> {
            AlphaComparator() {
            }

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        }
        Arrays.sort(sorted, new AlphaComparator());
        return sorted;
    }

    String[] stripEnglishStopWords(String[] words) {
        ArrayList<String> strippedWords = new ArrayList<String>();
        for (String word : words) {
            if (this.stopwords.contains(word)) continue;
            strippedWords.add(word);
        }
        if (strippedWords.size() >= 2) {
            return strippedWords.toArray(new String[strippedWords.size()]);
        }
        return words;
    }

    String[] sortByLength(String[] words) {
        String[] sorted = new String[words.length];
        System.arraycopy(words, 0, sorted, 0, words.length);
        class LengthComparator
        implements Comparator<String> {
            LengthComparator() {
            }

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() == o2.length()) {
                    return o1.compareToIgnoreCase(o2);
                }
                return o2.length() - o1.length();
            }
        }
        Arrays.sort(sorted, new LengthComparator());
        return sorted;
    }

    @Override
    public long getHashValue(String query) {
        query = this.normalizeQuery(query);
        String[] words = this.sortByLength(query.split(" "));
        query = "";
        if (words.length > 0) {
            query = words[0];
        }
        if (words.length > 1) {
            query = query + " " + words[1];
        }
        byte[] sha1 = this.computeSHA1(query);
        byte[] hashArray = new byte[8];
        System.arraycopy(sha1, 0, hashArray, 0, 8);
        hashArray[0] = (byte)(hashArray[0] & 0x7F);
        return ByteUtils.beb2long(hashArray, 0, 8);
    }

    private byte[] computeSHA1(String input) {
        try {
            int bytesRead;
            MessageDigest outputSHA1 = MessageDigest.getInstance("SHA-1");
            byte[] data = new byte[65536];
            ByteArrayInputStream in = new ByteArrayInputStream(StringUtils.toUTF8Bytes(this.normalizeQuery(input)));
            while ((bytesRead = in.read(data)) >= 0) {
                outputSHA1.update(data, 0, bytesRead);
            }
            return outputSHA1.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("NoSuchAlgorithmException during computation: ", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Impossible IOException during computation: ", ex);
        }
    }
}

