/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.nio.ByteBufferCache;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.NIOSocket;
import org.limewire.nio.channel.ChannelReader;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.channel.ThrottleReader;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.ssl.SSLReadWriteChannel;
import org.limewire.nio.ssl.SSLUtils;
import org.limewire.nio.ssl.TLSNIOSocket;

public abstract class AbstractSSLSocket
extends NIOSocket {
    private static final Log LOG = LogFactory.getLog(TLSNIOSocket.class);
    private volatile SSLReadWriteChannel sslLayer;
    private volatile InterestReadableByteChannel baseReader;
    private volatile InterestWritableByteChannel baseWriter;

    public AbstractSSLSocket(InetAddress addr, int port, InetAddress localAddr, int localPort) throws IOException {
        super(addr, port, localAddr, localPort);
    }

    public AbstractSSLSocket(InetAddress addr, int port) throws IOException {
        super(addr, port);
    }

    public AbstractSSLSocket(String addr, int port, InetAddress localAddr, int localPort) throws IOException {
        super(addr, port, localAddr, localPort);
    }

    public AbstractSSLSocket(String addr, int port) throws UnknownHostException, IOException {
        super(addr, port);
    }

    public AbstractSSLSocket() throws IOException {
    }

    AbstractSSLSocket(Socket socket) {
        super(socket);
    }

    protected abstract SSLContext getSSLContext();

    protected Executor getSSLExecutor() {
        return SSLUtils.getExecutor();
    }

    protected ByteBufferCache getByteBufferCache() {
        return NIODispatcher.instance().getBufferCache();
    }

    protected Executor getNetworkExecutor() {
        return NIODispatcher.instance().getScheduledExecutorService();
    }

    protected abstract String[] getCipherSuites();

    @Override
    public boolean connect(SocketAddress addr, int timeout, ConnectObserver observer) {
        return super.connect(addr, timeout, new SSLConnectInitializer(addr, observer));
    }

    @Override
    protected InterestReadableByteChannel getBaseReadChannel() {
        if (this.baseReader == null) {
            this.sslLayer.setReadChannel(super.getBaseReadChannel());
            this.baseReader = this.sslLayer;
        }
        return this.baseReader;
    }

    @Override
    protected InterestWritableByteChannel getBaseWriteChannel() {
        if (this.baseWriter == null) {
            this.sslLayer.setWriteChannel(super.getBaseWriteChannel());
            this.baseWriter = this.sslLayer;
        }
        return this.baseWriter;
    }

    @Override
    protected void installThrottle(ThrottleReader throttle, ChannelReader reader) {
        ChannelReader lastChannel = reader;
        while (lastChannel.getReadChannel() instanceof ChannelReader) {
            lastChannel = (ChannelReader)((Object)lastChannel.getReadChannel());
        }
        if (throttle != lastChannel) {
            lastChannel.setReadChannel(throttle);
            throttle.setReadChannel(super.getBaseReadChannel());
        }
    }

    @Override
    protected void initIncomingSocket() {
        super.initIncomingSocket();
        this.sslLayer = new SSLReadWriteChannel(this.getSSLContext(), this.getSSLExecutor(), this.getByteBufferCache(), this.getNetworkExecutor());
        this.sslLayer.initialize(this.getRemoteSocketAddress(), SSLUtils.getTLSCipherSuites(), false, false);
    }

    @Override
    protected void initOutgoingSocket() throws IOException {
        super.initOutgoingSocket();
        this.sslLayer = new SSLReadWriteChannel(this.getSSLContext(), this.getSSLExecutor(), this.getByteBufferCache(), this.getNetworkExecutor());
    }

    @Override
    protected void shutdownObservers() {
        if (this.sslLayer != null) {
            this.sslLayer.shutdown();
        }
        super.shutdownObservers();
    }

    SSLReadWriteChannel getSSLChannel() {
        return this.sslLayer;
    }

    @Override
    public long getReadTimeout() {
        if (this.sslLayer != null && this.sslLayer.isHandshaking()) {
            try {
                return this.getSoTimeout();
            }
            catch (SocketException se) {
                return 0L;
            }
        }
        return super.getReadTimeout();
    }

    private class SSLConnectInitializer
    implements ConnectObserver {
        private final ConnectObserver delegate;
        private final SocketAddress addr;

        public SSLConnectInitializer(SocketAddress addr, ConnectObserver delegate) {
            this.delegate = delegate;
            this.addr = addr;
        }

        @Override
        public void handleConnect(Socket socket) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initializing SSL/TLS connection to " + AbstractSSLSocket.this.getInetAddress().getHostAddress() + ":" + AbstractSSLSocket.this.getPort() + ", open " + AbstractSSLSocket.this.sslLayer.isOpen() + ", handshaking " + AbstractSSLSocket.this.sslLayer.isHandshaking());
            }
            AbstractSSLSocket.this.sslLayer.initialize(this.addr, AbstractSSLSocket.this.getCipherSuites(), true, false);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initialized SSL/TLS connection to " + AbstractSSLSocket.this.getInetAddress().getHostAddress() + ":" + AbstractSSLSocket.this.getPort() + ", open " + AbstractSSLSocket.this.sslLayer.isOpen() + ", handshaking " + AbstractSSLSocket.this.sslLayer.isHandshaking());
            }
            this.delegate.handleConnect(socket);
        }

        @Override
        public void handleIOException(IOException iox) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(iox + ", " + AbstractSSLSocket.this.getInetAddress().getHostAddress() + ":" + AbstractSSLSocket.this.getPort() + ", open " + AbstractSSLSocket.this.sslLayer.isOpen() + ", handshaking " + AbstractSSLSocket.this.sslLayer.isHandshaking());
            }
            this.delegate.handleIOException(iox);
        }

        @Override
        public void shutdown() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Shutting down SSL/TLS connection to " + AbstractSSLSocket.this.getInetAddress().getHostAddress() + ":" + AbstractSSLSocket.this.getPort() + ", open " + AbstractSSLSocket.this.sslLayer.isOpen() + ", handshaking " + AbstractSSLSocket.this.sslLayer.isHandshaking());
            }
            this.delegate.shutdown();
        }
    }
}

