/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.security.Signature;
import java.security.SignatureException;
import org.limewire.io.ByteBufferOutputStream;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;

abstract class AbstractDHTMessage
implements DHTMessage {
    protected final Context context;
    private final DHTMessage.OpCode opcode;
    private final Contact contact;
    private final MessageID messageId;
    private final Version msgVersion;
    private byte[] payload;

    public AbstractDHTMessage(Context context, DHTMessage.OpCode opcode, Contact contact, MessageID messageId, Version msgVersion) {
        if (opcode == null) {
            throw new NullPointerException("OpCode is null");
        }
        if (contact == null) {
            throw new NullPointerException("Contact is null");
        }
        if (messageId == null) {
            throw new NullPointerException("MessageID is null");
        }
        if (msgVersion == null) {
            throw new NullPointerException("Version is null");
        }
        this.context = context;
        this.opcode = opcode;
        this.contact = contact;
        this.messageId = messageId;
        this.msgVersion = msgVersion;
    }

    public AbstractDHTMessage(Context context, DHTMessage.OpCode opcode, SocketAddress src, MessageID messageId, Version msgVersion, MessageInputStream in) throws IOException {
        if (opcode == null) {
            throw new NullPointerException("OpCode is null");
        }
        if (messageId == null) {
            throw new NullPointerException("MessageID is null");
        }
        if (msgVersion == null) {
            throw new NullPointerException("Version is null");
        }
        this.context = context;
        this.opcode = opcode;
        this.messageId = messageId;
        this.msgVersion = msgVersion;
        Vendor vendor = in.readVendor();
        Version version = in.readVersion();
        KUID nodeId = in.readKUID();
        InetSocketAddress contactAddress = in.readSocketAddress();
        if (contactAddress == null) {
            throw new UnknownHostException("Contact Address is null");
        }
        int instanceId = in.readUnsignedByte();
        int flags = in.readUnsignedByte();
        this.contact = this.createContact(src, vendor, version, nodeId, contactAddress, instanceId, flags);
        int extensionsLength = in.readUnsignedShort();
        in.skip(extensionsLength);
    }

    protected abstract Contact createContact(SocketAddress var1, Vendor var2, Version var3, KUID var4, SocketAddress var5, int var6, int var7);

    public Context getContext() {
        return this.context;
    }

    @Override
    public DHTMessage.OpCode getOpCode() {
        return this.opcode;
    }

    @Override
    public Contact getContact() {
        return this.contact;
    }

    @Override
    public MessageID getMessageID() {
        return this.messageId;
    }

    @Override
    public Version getMessageVersion() {
        return this.msgVersion;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.serialize();
        MessageOutputStream out = new MessageOutputStream(os);
        this.messageId.write(out);
        out.writeByte(68);
        out.writeVersion(this.getMessageVersion());
        out.write(this.payload.length & 0xFF);
        out.write(this.payload.length >> 8 & 0xFF);
        out.write(this.payload.length >> 16 & 0xFF);
        out.write(this.payload.length >> 24 & 0xFF);
        out.write(this.payload, 0, this.payload.length);
    }

    private synchronized void serialize() throws IOException {
        if (this.payload != null) {
            return;
        }
        ByteBufferOutputStream baos = new ByteBufferOutputStream(640);
        MessageOutputStream out = new MessageOutputStream(baos);
        this.writeHeader(out);
        this.writeBody(out);
        out.close();
        this.payload = baos.toByteArray();
    }

    protected void writeHeader(MessageOutputStream out) throws IOException {
        out.writeOpCode(this.getOpCode());
        out.writeVendor(this.getContact().getVendor());
        out.writeVersion(this.getContact().getVersion());
        out.writeKUID(this.getContact().getNodeID());
        out.writeSocketAddress(this.getContact().getContactAddress());
        out.writeByte(this.getContact().getInstanceID());
        out.writeByte(this.getContact().getFlags());
        this.writeExtendedHeader(out);
    }

    private void writeExtendedHeader(MessageOutputStream out) throws IOException {
        out.writeShort(0);
    }

    protected abstract void writeBody(MessageOutputStream var1) throws IOException;

    protected void initSignature(Signature signature) throws SignatureException {
        try {
            SocketAddress myExternalAddress = this.context.getContactAddress();
            signature.update(NetworkUtils.getBytes(myExternalAddress, ByteOrder.BIG_ENDIAN));
            SocketAddress contactAddress = this.getContact().getContactAddress();
            signature.update(NetworkUtils.getBytes(contactAddress, ByteOrder.BIG_ENDIAN));
        }
        catch (UnknownHostException err) {
            throw new SignatureException(err);
        }
    }

    @Override
    public final int getLength() {
        try {
            this.serialize();
            return this.payload.length;
        }
        catch (IOException impossible) {
            return -1;
        }
    }
}

