/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.properties;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.limewire.core.api.properties.PropertyDictionary;
import org.limewire.util.NameValue;

@Singleton
class PropertyDictionaryImpl
implements PropertyDictionary {
    private final Provider<LimeXMLSchemaRepository> schemaRepository;
    private List<String> audioGenres;
    private List<String> videoGenres;
    private List<String> videoRatings;
    private List<String> applicationPlatforms;

    @Inject
    public PropertyDictionaryImpl(Provider<LimeXMLSchemaRepository> schemaRepository) {
        this.schemaRepository = schemaRepository;
    }

    @Override
    public List<String> getAudioGenres() {
        if (this.audioGenres == null) {
            this.audioGenres = Collections.unmodifiableList(this.getValueList("audio", "genre"));
        }
        return this.audioGenres;
    }

    @Override
    public List<String> getVideoRatings() {
        if (this.videoRatings == null) {
            this.videoRatings = Collections.unmodifiableList(this.getValueList("video", "rating"));
        }
        return this.videoRatings;
    }

    @Override
    public List<String> getVideoGenres() {
        if (this.videoGenres == null) {
            this.videoGenres = Collections.unmodifiableList(this.getValueList("video", "type"));
        }
        return this.videoGenres;
    }

    @Override
    public List<String> getApplicationPlatforms() {
        if (this.applicationPlatforms == null) {
            this.applicationPlatforms = Collections.unmodifiableList(this.getValueList("application", "platform"));
        }
        return this.applicationPlatforms;
    }

    private List<String> getValueList(String schemaDescription, String enumerationName) {
        ArrayList<String> values = new ArrayList<String>();
        for (LimeXMLSchema schema : this.schemaRepository.get().getAvailableSchemas()) {
            if (!schemaDescription.equals(schema.getDescription())) continue;
            for (SchemaFieldInfo info : schema.getEnumerationFields()) {
                String canonicalizedFieldName = info.getCanonicalizedFieldName();
                if (canonicalizedFieldName == null || !canonicalizedFieldName.endsWith("__" + enumerationName + "__")) continue;
                for (NameValue<String> nameValue : info.getEnumerationList()) {
                    values.add(nameValue.getName());
                }
                if (values.contains("")) continue;
                values.add(0, "");
            }
        }
        Collections.sort(values);
        return values;
    }
}

