/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import com.lti.utils.synchronization.CloseableThread;
import com.lti.utils.synchronization.ProducerConsumerQueue;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import net.sf.fmj.media.AsyncSourceTransferHandlerNotifier;
import net.sf.fmj.utility.LoggerSingleton;

public class SimpleSocketInputStream
extends CloseableThread
implements PushSourceStream {
    private static final Logger logger = LoggerSingleton.logger;
    private DatagramSocket socket = null;
    private boolean eos = false;
    private static final int QUEUE_SIZE = 100;
    private final ProducerConsumerQueue q = new ProducerConsumerQueue(100);
    private final AsyncSourceTransferHandlerNotifier asyncBufferTransferHandlerNotifier = new AsyncSourceTransferHandlerNotifier(this);

    public SimpleSocketInputStream(DatagramSocket socket) {
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buffer, int offset, int length) throws IOException {
        Object o;
        if (this.eos) {
            return -1;
        }
        try {
            ProducerConsumerQueue producerConsumerQueue = this.q;
            synchronized (producerConsumerQueue) {
                if (this.q.isEmpty()) {
                    return 0;
                }
                o = this.q.get();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        if (o instanceof DatagramPacket) {
            DatagramPacket packet = (DatagramPacket)o;
            if (length < packet.getLength()) {
                throw new IllegalArgumentException("Length must be at least " + packet.getLength());
            }
            System.arraycopy(packet.getData(), packet.getOffset(), buffer, offset, packet.getLength());
            logger.finer("packet length: " + packet.getLength());
            return packet.getLength();
        }
        if (o instanceof IOException) {
            throw (IOException)o;
        }
        throw new RuntimeException("Unknown object in queue: " + o);
    }

    public int getMinimumTransferSize() {
        return 2048;
    }

    public void setTransferHandler(SourceTransferHandler transferHandler) {
        this.asyncBufferTransferHandlerNotifier.setTransferHandler(transferHandler);
    }

    public void notifyTransferHandlerAsync() throws InterruptedException {
        this.asyncBufferTransferHandlerNotifier.notifyTransferHandlerAsync();
    }

    public ContentDescriptor getContentDescriptor() {
        return null;
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean endOfStream() {
        return this.eos;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String controlType) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!this.isClosing()) {
                byte[] data = new byte[this.getMinimumTransferSize()];
                DatagramPacket packet = new DatagramPacket(data, data.length);
                try {
                    this.socket.receive(packet);
                    ProducerConsumerQueue producerConsumerQueue = this.q;
                    synchronized (producerConsumerQueue) {
                        if (this.q.isFull()) {
                            logger.fine("Dropping buffered UDP packet");
                            this.q.get();
                        }
                        this.q.put(packet);
                    }
                    this.notifyTransferHandlerAsync();
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "" + e, e);
                    ProducerConsumerQueue producerConsumerQueue = this.q;
                    synchronized (producerConsumerQueue) {
                        if (this.q.isFull()) {
                            logger.fine("Dropping buffered UDP packet");
                            this.q.get();
                        }
                        this.q.put(e);
                    }
                    this.eos = true;
                    break;
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.setClosed();
        }
    }

    public void kill() {
        this.asyncBufferTransferHandlerNotifier.dispose();
        this.close();
        this.socket.close();
    }
}

