/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.KUID;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.concurrent.DHTExecutorService;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureAdapter;
import org.limewire.mojito.concurrent.DHTFutureListener;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.routing.Bucket;
import org.limewire.mojito.routing.ClassfulNetworkCounter;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;

class PassiveDHTNodeRouteTable
implements RouteTable {
    private static final Log LOG = LogFactory.getLog(PassiveDHTNodeRouteTable.class);
    private final MojitoDHT dht;
    private final RouteTable delegate;
    private final Map<SocketAddress, KUID> leafDHTNodes = new HashMap<SocketAddress, KUID>();

    public PassiveDHTNodeRouteTable(MojitoDHT dht) {
        assert (dht.isFirewalled());
        this.dht = dht;
        this.delegate = dht.getRouteTable();
    }

    public void addLeafDHTNode(String host, int port) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pinging leaf: " + host + ": " + port);
        }
        final InetSocketAddress addr = new InetSocketAddress(host, port);
        DHTFuture<PingResult> future = this.dht.ping(addr);
        DHTFutureAdapter<PingResult> listener = new DHTFutureAdapter<PingResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleFutureSuccess(PingResult result) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ping succeeded to: " + result);
                }
                Contact node = result.getContact();
                PassiveDHTNodeRouteTable passiveDHTNodeRouteTable = PassiveDHTNodeRouteTable.this;
                synchronized (passiveDHTNodeRouteTable) {
                    KUID previous = PassiveDHTNodeRouteTable.this.leafDHTNodes.put(addr, node.getNodeID());
                    if (previous == null || !previous.equals(node.getNodeID())) {
                        node.setTimeStamp(0x7FFFFFFFFFFFFFFEL);
                        PassiveDHTNodeRouteTable.this.add(node);
                    }
                }
            }

            @Override
            public void handleExecutionException(ExecutionException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ping failed to: " + addr, e);
                }
            }
        };
        future.addDHTFutureListener((DHTFutureListener<PingResult>)listener);
    }

    public synchronized SocketAddress removeLeafDHTNode(String host, int port) {
        InetSocketAddress addr = new InetSocketAddress(host, port);
        KUID nodeId = this.leafDHTNodes.remove(addr);
        if (nodeId != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removed leaf: " + host + ": " + port);
            }
            this.removeAndReplaceWithMRSCachedContact(nodeId);
            return addr;
        }
        return null;
    }

    private synchronized void removeAndReplaceWithMRSCachedContact(KUID nodeId) {
        Bucket bucket = this.getBucket(nodeId);
        boolean removed = bucket.removeActiveContact(nodeId);
        if (removed) {
            if (bucket.getCacheSize() > 0) {
                ClassfulNetworkCounter counter = bucket.getClassfulNetworkCounter();
                Contact mrs = null;
                while ((mrs = bucket.getMostRecentlySeenCachedContact()) != null) {
                    removed = bucket.removeCachedContact(mrs.getNodeID());
                    assert (removed);
                    if (counter != null && !counter.isOkayToAdd(mrs)) continue;
                    bucket.addActiveContact(mrs);
                    break;
                }
            }
        } else {
            bucket.removeCachedContact(nodeId);
        }
    }

    public synchronized boolean hasDHTLeaves() {
        return !this.leafDHTNodes.isEmpty();
    }

    public synchronized Set<SocketAddress> getDHTLeaves() {
        return Collections.unmodifiableSet(this.leafDHTNodes.keySet());
    }

    @Override
    public synchronized void add(Contact node) {
        this.delegate.add(node);
    }

    @Override
    public synchronized void addRouteTableListener(RouteTable.RouteTableListener l) {
        this.delegate.addRouteTableListener(l);
    }

    @Override
    public synchronized void removeRouteTableListener(RouteTable.RouteTableListener l) {
        this.delegate.removeRouteTableListener(l);
    }

    @Override
    public synchronized Contact get(KUID nodeId) {
        return this.delegate.get(nodeId);
    }

    @Override
    public synchronized Collection<Contact> getActiveContacts() {
        return this.delegate.getActiveContacts();
    }

    @Override
    public synchronized Bucket getBucket(KUID nodeId) {
        return this.delegate.getBucket(nodeId);
    }

    @Override
    public synchronized Collection<Bucket> getBuckets() {
        return this.delegate.getBuckets();
    }

    @Override
    public synchronized Collection<Contact> getCachedContacts() {
        return this.delegate.getCachedContacts();
    }

    @Override
    public synchronized Collection<Contact> getContacts() {
        return this.delegate.getContacts();
    }

    @Override
    public synchronized Contact getLocalNode() {
        return this.delegate.getLocalNode();
    }

    @Override
    public synchronized Collection<KUID> getRefreshIDs(boolean bootstrapping) {
        return this.delegate.getRefreshIDs(bootstrapping);
    }

    @Override
    public synchronized void handleFailure(KUID nodeId, SocketAddress address) {
        this.delegate.handleFailure(nodeId, address);
    }

    @Override
    public synchronized boolean isLocalNode(Contact node) {
        return this.delegate.isLocalNode(node);
    }

    @Override
    public synchronized void purge(long elapsedTimeSinceLastContact) {
        this.delegate.purge(elapsedTimeSinceLastContact);
    }

    @Override
    public synchronized void purge(RouteTable.PurgeMode first, RouteTable.PurgeMode ... rest) {
        this.delegate.purge(first, rest);
    }

    @Override
    public synchronized Contact select(KUID nodeId) {
        return this.delegate.select(nodeId);
    }

    @Override
    public synchronized Collection<Contact> select(KUID nodeId, int count, RouteTable.SelectMode mode) {
        return this.delegate.select(nodeId, count, mode);
    }

    @Override
    public synchronized void setContactPinger(RouteTable.ContactPinger pinger) {
        this.delegate.setContactPinger(pinger);
    }

    @Override
    public synchronized void setNotifier(DHTExecutorService e) {
        this.delegate.setNotifier(e);
    }

    @Override
    public synchronized int size() {
        return this.delegate.size();
    }

    @Override
    public synchronized void clear() {
        this.delegate.clear();
    }

    public synchronized String toString() {
        return "Passive RouteTable: " + this.delegate.toString();
    }
}

