/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.connection.MessageQueue;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.util.LimeWireUtils;

public abstract class AbstractMessageQueue
implements MessageQueue {
    private final int _cycleSize;
    private int _leftInCycle;
    private int _timeout;
    protected int _dropped;
    private final Message.MessageCounter messageCounter = new Message.MessageCounter(LimeWireUtils.isBetaRelease() || LimeWireUtils.isAlphaRelease() ? 5 : 1);

    protected AbstractMessageQueue(int cycle, int timeout) throws IllegalArgumentException {
        if (timeout <= 0) {
            throw new IllegalArgumentException("Timeout too small: " + cycle);
        }
        if (cycle <= 0) {
            throw new IllegalArgumentException("Cycle too small: " + cycle);
        }
        this._cycleSize = cycle;
        this._leftInCycle = cycle;
        this._timeout = timeout;
    }

    @Override
    public void add(Message m) {
        Message dropmsg = this.addInternal(m);
        if (dropmsg != null) {
            this.drop(dropmsg);
        }
    }

    private void drop(Message m) {
        ++this._dropped;
        this.messageCounter.countMessage(m);
    }

    @Override
    public final Object getDroppedStats() {
        return this.messageCounter.inspect();
    }

    protected abstract Message addInternal(Message var1);

    @Override
    public Message removeNext() {
        Message m;
        if (this._leftInCycle == 0) {
            return null;
        }
        long expireTime = System.currentTimeMillis() - (long)this._timeout;
        while (true) {
            if ((m = this.removeNextInternal()) == null) {
                return null;
            }
            if (m.getCreationTime() >= expireTime) break;
            this.drop(m);
        }
        --this._leftInCycle;
        return m;
    }

    protected abstract Message removeNextInternal();

    @Override
    public void resetCycle() {
        this._leftInCycle = this._cycleSize;
    }

    @Override
    public final int resetDropped() {
        int ret = this._dropped;
        this._dropped = 0;
        return ret;
    }

    @Override
    public abstract int size();

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }
}

