/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.handlers.socks;

import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.proxy.handlers.socks.AbstractSocksLogicHandler;
import org.apache.mina.proxy.handlers.socks.SocksProxyConstants;
import org.apache.mina.proxy.handlers.socks.SocksProxyRequest;
import org.apache.mina.proxy.session.ProxyIoSession;
import org.apache.mina.proxy.utils.ByteUtilities;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Socks5LogicHandler
extends AbstractSocksLogicHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Socks5LogicHandler.class);
    private static final String SELECTED_AUTH_METHOD = Socks5LogicHandler.class.getName() + ".SelectedAuthMethod";
    private static final String HANDSHAKE_STEP = Socks5LogicHandler.class.getName() + ".HandshakeStep";
    private static final String GSS_CONTEXT = Socks5LogicHandler.class.getName() + ".GSSContext";
    private static final String GSS_TOKEN = Socks5LogicHandler.class.getName() + ".GSSToken";

    public Socks5LogicHandler(ProxyIoSession proxyIoSession) {
        super(proxyIoSession);
        this.getSession().setAttribute(HANDSHAKE_STEP, 0);
    }

    public synchronized void doHandshake(IoFilter.NextFilter nextFilter) {
        LOGGER.debug(" doHandshake()");
        this.writeRequest(nextFilter, this.request, (Integer)this.getSession().getAttribute(HANDSHAKE_STEP));
    }

    private IoBuffer encodeInitialGreetingPacket(SocksProxyRequest socksProxyRequest) {
        byte by = (byte)SocksProxyConstants.SUPPORTED_AUTH_METHODS.length;
        IoBuffer ioBuffer = IoBuffer.allocate(2 + by);
        ioBuffer.put(socksProxyRequest.getProtocolVersion());
        ioBuffer.put(by);
        ioBuffer.put(SocksProxyConstants.SUPPORTED_AUTH_METHODS);
        return ioBuffer;
    }

    private IoBuffer encodeProxyRequestPacket(SocksProxyRequest socksProxyRequest) throws UnsupportedEncodingException {
        int n = 6;
        InetSocketAddress inetSocketAddress = socksProxyRequest.getEndpointAddress();
        byte by = 0;
        byte[] byArray = null;
        if (inetSocketAddress != null && !inetSocketAddress.isUnresolved()) {
            if (inetSocketAddress.getAddress() instanceof Inet6Address) {
                n += 16;
                by = 4;
            } else if (inetSocketAddress.getAddress() instanceof Inet4Address) {
                n += 4;
                by = 1;
            }
        } else {
            byte[] byArray2 = byArray = socksProxyRequest.getHost() != null ? socksProxyRequest.getHost().getBytes("ASCII") : null;
            if (byArray != null) {
                n += 1 + byArray.length;
                by = 3;
            } else {
                throw new IllegalArgumentException("SocksProxyRequest object has no suitable endpoint information");
            }
        }
        IoBuffer ioBuffer = IoBuffer.allocate(n);
        ioBuffer.put(socksProxyRequest.getProtocolVersion());
        ioBuffer.put(socksProxyRequest.getCommandCode());
        ioBuffer.put((byte)0);
        ioBuffer.put(by);
        if (byArray == null) {
            ioBuffer.put(socksProxyRequest.getIpAddress());
        } else {
            ioBuffer.put((byte)byArray.length);
            ioBuffer.put(byArray);
        }
        ioBuffer.put(socksProxyRequest.getPort());
        return ioBuffer;
    }

    private IoBuffer encodeAuthenticationPacket(SocksProxyRequest socksProxyRequest) throws UnsupportedEncodingException, GSSException {
        byte by = (Byte)this.getSession().getAttribute(SELECTED_AUTH_METHOD);
        switch (by) {
            case 0: {
                this.getSession().setAttribute(HANDSHAKE_STEP, 2);
                break;
            }
            case 1: {
                return this.encodeGSSAPIAuthenticationPacket(socksProxyRequest);
            }
            case 2: {
                byte[] byArray = socksProxyRequest.getUserName().getBytes("ASCII");
                byte[] byArray2 = socksProxyRequest.getPassword().getBytes("ASCII");
                IoBuffer ioBuffer = IoBuffer.allocate(3 + byArray.length + byArray2.length);
                ioBuffer.put((byte)1);
                ioBuffer.put((byte)byArray.length);
                ioBuffer.put(byArray);
                ioBuffer.put((byte)byArray2.length);
                ioBuffer.put(byArray2);
                return ioBuffer;
            }
        }
        return null;
    }

    private IoBuffer encodeGSSAPIAuthenticationPacket(SocksProxyRequest socksProxyRequest) throws GSSException {
        Object object;
        Object object2;
        GSSContext gSSContext = (GSSContext)this.getSession().getAttribute(GSS_CONTEXT);
        if (gSSContext == null) {
            object2 = GSSManager.getInstance();
            object = ((GSSManager)object2).createName(socksProxyRequest.getServiceKerberosName(), null);
            Oid oid = new Oid("1.2.840.113554.1.2.2");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Available mechs:");
                for (Oid oid2 : ((GSSManager)object2).getMechs()) {
                    if (oid2.equals(oid)) {
                        LOGGER.debug("Found Kerberos V OID available");
                    }
                    LOGGER.debug("{} with oid = {}", (Object)((GSSManager)object2).getNamesForMech(oid2), (Object)oid2);
                }
            }
            gSSContext = ((GSSManager)object2).createContext((GSSName)object, oid, null, 0);
            gSSContext.requestMutualAuth(true);
            gSSContext.requestConf(false);
            gSSContext.requestInteg(false);
            this.getSession().setAttribute(GSS_CONTEXT, gSSContext);
        }
        if ((object2 = (Object)((byte[])this.getSession().getAttribute(GSS_TOKEN))) != null) {
            LOGGER.debug("  Received Token[{}] = {}", (Object)((Object)object2).length, (Object)ByteUtilities.asHex((byte[])object2));
        }
        object = null;
        if (!gSSContext.isEstablished()) {
            if (object2 == null) {
                object2 = new byte[32];
            }
            if ((object2 = (Object)gSSContext.initSecContext((byte[])object2, 0, ((Object)object2).length)) != null) {
                LOGGER.debug("  Sending Token[{}] = {}", (Object)((Object)object2).length, (Object)ByteUtilities.asHex((byte[])object2));
                this.getSession().setAttribute(GSS_TOKEN, object2);
                object = IoBuffer.allocate(4 + ((Object)object2).length);
                ((IoBuffer)object).put(new byte[]{1, 1});
                ((IoBuffer)object).put(ByteUtilities.intToNetworkByteOrder(((Object)object2).length, 2));
                ((IoBuffer)object).put((byte[])object2);
            }
        }
        return object;
    }

    private void writeRequest(IoFilter.NextFilter nextFilter, SocksProxyRequest socksProxyRequest, int n) {
        try {
            IoBuffer ioBuffer = null;
            if (n == 0) {
                ioBuffer = this.encodeInitialGreetingPacket(socksProxyRequest);
            } else if (n == 1 && (ioBuffer = this.encodeAuthenticationPacket(socksProxyRequest)) == null) {
                n = 2;
            }
            if (n == 2) {
                ioBuffer = this.encodeProxyRequestPacket(socksProxyRequest);
            }
            ioBuffer.flip();
            this.writeData(nextFilter, ioBuffer);
        }
        catch (Exception exception) {
            this.closeSession("Unable to send Socks request: ", exception);
        }
    }

    public synchronized void messageReceived(IoFilter.NextFilter nextFilter, IoBuffer ioBuffer) {
        try {
            int n = (Integer)this.getSession().getAttribute(HANDSHAKE_STEP);
            if (n == 0 && ioBuffer.get(0) != 5) {
                throw new IllegalStateException("Wrong socks version running on server");
            }
            if ((n == 0 || n == 1) && ioBuffer.remaining() >= 2) {
                this.handleResponse(nextFilter, ioBuffer, n);
            } else if (n == 2 && ioBuffer.remaining() >= 5) {
                this.handleResponse(nextFilter, ioBuffer, n);
            }
        }
        catch (Exception exception) {
            this.closeSession("Proxy handshake failed: ", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void handleResponse(IoFilter.NextFilter nextFilter, IoBuffer ioBuffer, int n) throws Exception {
        Object object;
        int n2;
        byte by;
        int n3 = 2;
        if (n == 0) {
            by = ioBuffer.get(1);
            if (by == -1) {
                throw new IllegalStateException("No acceptable authentication method to use with the socks proxy server");
            }
            this.getSession().setAttribute(SELECTED_AUTH_METHOD, new Byte(by));
        } else if (n == 1) {
            by = (Byte)this.getSession().getAttribute(SELECTED_AUTH_METHOD);
            if (by == 1) {
                n2 = ioBuffer.position();
                if (ioBuffer.get(0) != 1) {
                    throw new IllegalStateException("Authentication failed");
                }
                if (ioBuffer.get(1) == 255) {
                    throw new IllegalStateException("Authentication failed: GSS API Security Context Failure");
                }
                if (ioBuffer.remaining() < 2) {
                    ioBuffer.position(n2);
                    return;
                }
                object = new byte[2];
                ioBuffer.get((byte[])object);
                int n4 = ByteUtilities.makeIntFromByte2((byte[])object);
                if (ioBuffer.remaining() < n4) {
                    return;
                }
                byte[] byArray = new byte[n4];
                ioBuffer.get(byArray);
                this.getSession().setAttribute(GSS_TOKEN, byArray);
                n3 = 0;
            } else if (ioBuffer.get(1) != 0) {
                throw new IllegalStateException("Authentication failed");
            }
        } else if (n == 2) {
            byte by2 = ioBuffer.get(3);
            n3 = 6;
            if (by2 == 4) {
                n3 += 16;
            } else if (by2 == 1) {
                n3 += 4;
            } else {
                if (by2 != 3) {
                    throw new IllegalStateException("Unknwon address type");
                }
                n3 += 1 + ioBuffer.get(4);
            }
            if (ioBuffer.remaining() < n3) {
                return;
            }
            byte by3 = ioBuffer.get(1);
            LOGGER.debug("  response status: {}", (Object)SocksProxyConstants.getReplyCodeAsString(by3));
            if (by3 == 0) {
                ioBuffer.position(ioBuffer.position() + n3);
                this.setHandshakeComplete();
                return;
            }
            throw new Exception("Proxy handshake failed - Code: 0x" + ByteUtilities.asHex(new byte[]{by3}));
        }
        if (n3 > 0) {
            ioBuffer.position(ioBuffer.position() + n3);
        }
        by = 0;
        if (!(n != 1 || (n2 = (int)((Byte)this.getSession().getAttribute(SELECTED_AUTH_METHOD)).byteValue()) != 1 || (object = (GSSContext)this.getSession().getAttribute(GSS_CONTEXT)) != null && object.isEstablished())) {
            by = 1;
        }
        if (by == 0) {
            this.getSession().setAttribute(HANDSHAKE_STEP, ++n);
        }
        this.doHandshake(nextFilter);
    }

    protected void closeSession(String string) {
        GSSContext gSSContext = (GSSContext)this.getSession().getAttribute(GSS_CONTEXT);
        if (gSSContext != null) {
            try {
                gSSContext.dispose();
            }
            catch (GSSException gSSException) {
                gSSException.printStackTrace();
                super.closeSession(string, gSSException);
                return;
            }
        }
        super.closeSession(string);
    }
}

