/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.dic;

import java.io.InputStream;
import org.ansj.dic.impl.File2Stream;
import org.ansj.dic.impl.Jar2Stream;
import org.ansj.dic.impl.Jdbc2Stream;
import org.ansj.dic.impl.Url2Stream;
import org.ansj.exception.LibraryException;

public abstract class PathToStream {
    public static InputStream stream(String path) {
        try {
            if (path.startsWith("file://")) {
                return new File2Stream().toStream(path);
            }
            if (path.startsWith("jdbc://")) {
                return new Jdbc2Stream().toStream(path);
            }
            if (path.startsWith("jar://")) {
                return new Jar2Stream().toStream(path);
            }
            if (!path.startsWith("class://")) {
                if (path.startsWith("http://") || path.startsWith("https://")) {
                    return new Url2Stream().toStream(path);
                }
                return new File2Stream().toStream(path);
            }
            ((PathToStream)Class.forName(path.substring(8).split("\\|")[0]).newInstance()).toStream(path);
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
        throw new LibraryException("not find method type in path " + path);
    }

    public abstract InputStream toStream(String var1);
}

