/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.instructions.branches;

import edsim51sh.Memory;
import edsim51sh.Text;
import edsim51sh.instructions.branches.Branch;

public class Jbc
extends Branch {
    public Jbc() {
        this.mneumonic = "JBC";
        this.size = 3;
        this.cycles = 2;
        this.isByteInstruction = false;
    }

    @Override
    public int execute(Memory ram, int pc) throws Exception {
        if ((pc += this.size) > 65535) {
            pc -= 65536;
        }
        if (ram.getBit(this.operand0) == 1) {
            ram.clearBit(this.operand0);
            if ((pc += ram.toSignedNumber(this.operand1)) > 65535) {
                pc -= 65536;
            } else if (pc < 0) {
                pc = 65536 + pc;
            }
        }
        return pc;
    }

    @Override
    public void extractOperand0String(String line) throws Exception {
        int commaIndex = (line = line.replaceFirst(this.mneumonic, "").trim()).indexOf(44);
        line = commaIndex == -1 ? "" : line.substring(0, commaIndex).trim();
        this.setOperand0String(line);
    }

    @Override
    public void extractOperand1String(String line) throws Exception {
        int commaIndex = (line = line.replaceFirst(this.mneumonic, "").trim()).indexOf(44);
        line = commaIndex == -1 ? "" : line.substring(commaIndex + 1).trim();
        this.setOperand1String(line);
    }

    @Override
    public String toString() {
        return "JBC " + Text.inHex(this.operand0, false) + "H," + Text.inHex(this.operand1, false) + "H";
    }

    @Override
    public int getOpcode() {
        return 16;
    }
}

