/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.application.surfacing;
import org.forester.go.GoId;
import org.forester.go.GoTerm;
import org.forester.protein.BinaryDomainCombination;
import org.forester.protein.Protein;
import org.forester.species.Species;
import org.forester.surfacing.BasicCombinableDomains;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.SurfacingConstants;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.ForesterUtil;

public final class DomainCountsDifferenceUtil {
    private static final COPY_CALCULATION_MODE COPY_CALC_MODE_FOR_HIGH_COPY_BASE_SPECIES = COPY_CALCULATION_MODE.MIN;
    private static final COPY_CALCULATION_MODE COPY_CALC_MODE_FOR_HIGH_COPY_TARGET_SPECIES = COPY_CALCULATION_MODE.MIN;
    private static final COPY_CALCULATION_MODE COPY_CALC_MODE_FOR_LOW_COPY_SPECIES = COPY_CALCULATION_MODE.MAX;
    private static final String PLUS_MINUS_PROTEINS_FILE_DOM_SUFFIX = ".prot";

    public static void calculateCopyNumberDifferences(List<GenomeWideCombinableDomains> list, SortedMap<Species, List<Protein>> sortedMap, List<String> list2, List<String> list3, List<String> list4, int n, Double d, File file, File file2, File file3, Map<String, List<GoId>> map, Map<GoId, GoTerm> map2, File file4, File file5, File file6) throws IOException {
        String string;
        if (list.size() < 1) {
            throw new IllegalArgumentException("attempt to use empty list of genomes for domain difference calculation");
        }
        if (list2.size() < 1 || list4.size() < 1) {
            throw new IllegalArgumentException("attempt to use empty list of species for domain difference calculation");
        }
        if (list2.contains(list3) || list4.contains(list3)) {
            throw new IllegalArgumentException("species [" + list3 + "] appears in other list as well");
        }
        if (n < 0) {
            throw new IllegalArgumentException("attempt to use negative addition [" + n + "]");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("attempt to use factor equal or smaller than 0.0 [" + d + "]");
        }
        SurfacingUtil.checkForOutputFileWriteability(file);
        SurfacingUtil.checkForOutputFileWriteability(file2);
        SurfacingUtil.checkForOutputFileWriteability(file3);
        SurfacingUtil.checkForOutputFileWriteability(file4);
        SurfacingUtil.checkForOutputFileWriteability(file5);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(file2));
        BufferedWriter bufferedWriter3 = new BufferedWriter(new FileWriter(file3));
        BufferedWriter bufferedWriter4 = new BufferedWriter(new FileWriter(file4));
        BufferedWriter bufferedWriter5 = new BufferedWriter(new FileWriter(file5));
        TreeMap<String, Double> treeMap = new TreeMap<String, Double>();
        TreeMap<String, Double> treeMap2 = new TreeMap<String, Double>();
        TreeMap<String, Double> treeMap3 = new TreeMap<String, Double>();
        TreeMap<String, List<Integer>> treeMap4 = new TreeMap<String, List<Integer>>();
        TreeMap<String, List<Integer>> treeMap5 = new TreeMap<String, List<Integer>>();
        TreeMap<String, List<Integer>> treeMap6 = new TreeMap<String, List<Integer>>();
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeMap<BinaryDomainCombination, Double> treeMap7 = new TreeMap<BinaryDomainCombination, Double>();
        TreeMap<BinaryDomainCombination, Double> treeMap8 = new TreeMap<BinaryDomainCombination, Double>();
        TreeMap<BinaryDomainCombination, Double> treeMap9 = new TreeMap<BinaryDomainCombination, Double>();
        TreeMap<BinaryDomainCombination, List<Integer>> treeMap10 = new TreeMap<BinaryDomainCombination, List<Integer>>();
        TreeMap<BinaryDomainCombination, List<Integer>> treeMap11 = new TreeMap<BinaryDomainCombination, List<Integer>>();
        TreeMap<BinaryDomainCombination, List<Integer>> treeMap12 = new TreeMap<BinaryDomainCombination, List<Integer>>();
        TreeSet<BinaryDomainCombination> treeSet2 = new TreeSet<BinaryDomainCombination>();
        HashMap<String, Set<BinaryDomainCombination>> hashMap = new HashMap<String, Set<BinaryDomainCombination>>();
        TreeSet<GoId> treeSet3 = new TreeSet<GoId>();
        TreeSet<GoId> treeSet4 = new TreeSet<GoId>();
        for (GenomeWideCombinableDomains object : list) {
            Iterator<GenomeWideCombinableDomains> iterator = object.getAllDomainIds();
            SortedSet<BinaryDomainCombination> sortedSet = object.toBinaryDomainCombinations();
            string = object.getSpecies().getSpeciesId();
            hashMap.put(string, object.toBinaryDomainCombinations());
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                Object object2 = (String)iterator2.next();
                treeSet.add((String)object2);
                if (!map.containsKey(object2)) continue;
                treeSet4.addAll((Collection)map.get(object2));
            }
            for (Object object2 : sortedSet) {
                treeSet2.add((BinaryDomainCombination)object2);
            }
        }
        for (String string2 : treeSet) {
            for (GenomeWideCombinableDomains genomeWideCombinableDomains : list) {
                string = genomeWideCombinableDomains.getSpecies().getSpeciesId();
                if (list2.contains(string)) {
                    DomainCountsDifferenceUtil.addCounts(treeMap4, string2, genomeWideCombinableDomains);
                }
                if (list3.contains(string)) {
                    DomainCountsDifferenceUtil.addCounts(treeMap5, string2, genomeWideCombinableDomains);
                }
                if (!list4.contains(string)) continue;
                DomainCountsDifferenceUtil.addCounts(treeMap6, string2, genomeWideCombinableDomains);
            }
        }
        for (BinaryDomainCombination binaryDomainCombination : treeSet2) {
            for (GenomeWideCombinableDomains genomeWideCombinableDomains : list) {
                string = genomeWideCombinableDomains.getSpecies().getSpeciesId();
                if (list2.contains(string)) {
                    DomainCountsDifferenceUtil.addCounts(treeMap10, binaryDomainCombination, genomeWideCombinableDomains, (Set)hashMap.get(string));
                }
                if (list3.contains(string)) {
                    DomainCountsDifferenceUtil.addCounts(treeMap11, binaryDomainCombination, genomeWideCombinableDomains, (Set)hashMap.get(string));
                }
                if (!list4.contains(string)) continue;
                DomainCountsDifferenceUtil.addCounts(treeMap12, binaryDomainCombination, genomeWideCombinableDomains, (Set)hashMap.get(string));
            }
        }
        for (String string3 : treeSet) {
            DomainCountsDifferenceUtil.calculateDomainCountsBasedValue(treeMap2, treeMap5, string3, COPY_CALC_MODE_FOR_HIGH_COPY_TARGET_SPECIES);
            DomainCountsDifferenceUtil.calculateDomainCountsBasedValue(treeMap, treeMap4, string3, COPY_CALC_MODE_FOR_HIGH_COPY_BASE_SPECIES);
            DomainCountsDifferenceUtil.calculateDomainCountsBasedValue(treeMap3, treeMap6, string3, COPY_CALC_MODE_FOR_LOW_COPY_SPECIES);
        }
        for (BinaryDomainCombination binaryDomainCombination : treeSet2) {
            DomainCountsDifferenceUtil.calculateDomainCountsBasedValue(treeMap8, treeMap11, binaryDomainCombination, COPY_CALC_MODE_FOR_HIGH_COPY_TARGET_SPECIES);
            DomainCountsDifferenceUtil.calculateDomainCountsBasedValue(treeMap7, treeMap10, binaryDomainCombination, COPY_CALC_MODE_FOR_HIGH_COPY_BASE_SPECIES);
            DomainCountsDifferenceUtil.calculateDomainCountsBasedValue(treeMap9, treeMap12, binaryDomainCombination, COPY_CALC_MODE_FOR_LOW_COPY_SPECIES);
        }
        DomainCountsDifferenceUtil.writeDomainValuesToFiles(list, list2, list3, list4, n, d, map, map2, bufferedWriter, bufferedWriter2, file6, treeMap, treeMap2, treeMap3, treeSet, treeSet3, sortedMap);
        DomainCountsDifferenceUtil.writeDomainCombinationValuesToFiles(list, list2, list3, list4, n, d, bufferedWriter3, treeMap7, treeMap8, treeMap9, treeSet2, hashMap);
        DomainCountsDifferenceUtil.writeGoIdsToFile(bufferedWriter4, treeSet4);
        DomainCountsDifferenceUtil.writeGoIdsToFile(bufferedWriter5, treeSet3);
    }

    private static void addCounts(SortedMap<BinaryDomainCombination, List<Integer>> sortedMap, BinaryDomainCombination binaryDomainCombination, GenomeWideCombinableDomains genomeWideCombinableDomains, Set<BinaryDomainCombination> set) {
        if (!sortedMap.containsKey(binaryDomainCombination)) {
            sortedMap.put(binaryDomainCombination, new ArrayList());
        }
        if (set.contains(binaryDomainCombination) && ((BasicCombinableDomains)genomeWideCombinableDomains.get(binaryDomainCombination.getId0())).getCombiningDomains().get(binaryDomainCombination.getId1()) != null) {
            int n = ((BasicCombinableDomains)genomeWideCombinableDomains.get(binaryDomainCombination.getId0())).getCombiningDomains().get(binaryDomainCombination.getId1());
            ((List)sortedMap.get(binaryDomainCombination)).add(n);
        } else {
            ((List)sortedMap.get(binaryDomainCombination)).add(0);
        }
    }

    private static void addCounts(SortedMap<String, List<Integer>> sortedMap, String string, GenomeWideCombinableDomains genomeWideCombinableDomains) {
        if (!sortedMap.containsKey(string)) {
            sortedMap.put(string, new ArrayList());
        }
        if (genomeWideCombinableDomains.contains(string)) {
            ((List)sortedMap.get(string)).add(genomeWideCombinableDomains.get(string).getKeyDomainProteinsCount());
        } else {
            ((List)sortedMap.get(string)).add(0);
        }
    }

    private static StringBuilder addGoInformation(String string, Map<String, List<GoId>> map, Map<GoId, GoTerm> map2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (map == null || map.isEmpty() || !map.containsKey(string)) {
            return stringBuilder;
        }
        List<GoId> list = map.get(string);
        for (int i = 0; i < list.size(); ++i) {
            GoId goId = list.get(i);
            if (map2.containsKey(goId)) {
                DomainCountsDifferenceUtil.appendGoTerm(stringBuilder, map2.get(goId));
                stringBuilder.append("<br>");
                continue;
            }
            stringBuilder.append("go id \"" + goId + "\" not found [" + string + "]");
        }
        return stringBuilder;
    }

    private static void appendGoTerm(StringBuilder stringBuilder, GoTerm goTerm) {
        GoId goId = goTerm.getGoId();
        stringBuilder.append("<a href=\"http://amigo.geneontology.org/cgi-bin/amigo/go.cgi?view=details&search_constraint=terms&query=" + goId + "\" target=\"amigo_window\">" + goId + "</a>");
        stringBuilder.append(":");
        stringBuilder.append(goTerm.getName());
        stringBuilder.append(" [");
        stringBuilder.append(goTerm.getGoNameSpace().toShortString());
        stringBuilder.append("]");
    }

    private static void calculateDomainCountsBasedValue(SortedMap<BinaryDomainCombination, Double> sortedMap, SortedMap<BinaryDomainCombination, List<Integer>> sortedMap2, BinaryDomainCombination binaryDomainCombination, COPY_CALCULATION_MODE cOPY_CALCULATION_MODE) {
        block7: {
            block6: {
                if (!sortedMap2.containsKey(binaryDomainCombination)) break block6;
                switch (cOPY_CALCULATION_MODE) {
                    case MAX: {
                        DomainCountsDifferenceUtil.calculateMaxCount(sortedMap, sortedMap2, binaryDomainCombination);
                        break block7;
                    }
                    case MIN: {
                        DomainCountsDifferenceUtil.calculateMinCount(sortedMap, sortedMap2, binaryDomainCombination);
                        break block7;
                    }
                    case MEAN: {
                        DomainCountsDifferenceUtil.calculateMeanCount(sortedMap, sortedMap2, binaryDomainCombination);
                        break block7;
                    }
                    case MEDIAN: {
                        DomainCountsDifferenceUtil.calculateMedianCount(sortedMap, sortedMap2, binaryDomainCombination);
                        break block7;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            sortedMap.put(binaryDomainCombination, 0.0);
        }
    }

    private static void calculateDomainCountsBasedValue(SortedMap<String, Double> sortedMap, SortedMap<String, List<Integer>> sortedMap2, String string, COPY_CALCULATION_MODE cOPY_CALCULATION_MODE) {
        block7: {
            block6: {
                if (!sortedMap2.containsKey(string)) break block6;
                switch (cOPY_CALCULATION_MODE) {
                    case MAX: {
                        DomainCountsDifferenceUtil.calculateMaxCount(sortedMap, sortedMap2, string);
                        break block7;
                    }
                    case MIN: {
                        DomainCountsDifferenceUtil.calculateMinCount(sortedMap, sortedMap2, string);
                        break block7;
                    }
                    case MEAN: {
                        DomainCountsDifferenceUtil.calculateMeanCount(sortedMap, sortedMap2, string);
                        break block7;
                    }
                    case MEDIAN: {
                        DomainCountsDifferenceUtil.calculateMedianCount(sortedMap, sortedMap2, string);
                        break block7;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            sortedMap.put(string, 0.0);
        }
    }

    private static void calculateMaxCount(SortedMap<BinaryDomainCombination, Double> sortedMap, SortedMap<BinaryDomainCombination, List<Integer>> sortedMap2, BinaryDomainCombination binaryDomainCombination) {
        List list = (List)sortedMap2.get(binaryDomainCombination);
        int n = 0;
        for (Integer n2 : list) {
            if (n2 <= n) continue;
            n = n2;
        }
        sortedMap.put(binaryDomainCombination, Double.valueOf(n));
    }

    private static void calculateMaxCount(SortedMap<String, Double> sortedMap, SortedMap<String, List<Integer>> sortedMap2, String string) {
        List list = (List)sortedMap2.get(string);
        int n = 0;
        for (Integer n2 : list) {
            if (n2 <= n) continue;
            n = n2;
        }
        sortedMap.put(string, Double.valueOf(n));
    }

    private static void calculateMeanCount(SortedMap<BinaryDomainCombination, Double> sortedMap, SortedMap<BinaryDomainCombination, List<Integer>> sortedMap2, BinaryDomainCombination binaryDomainCombination) {
        List list = (List)sortedMap2.get(binaryDomainCombination);
        int n = 0;
        for (Integer n2 : list) {
            n += n2.intValue();
        }
        sortedMap.put(binaryDomainCombination, (double)n / (double)list.size());
    }

    private static void calculateMeanCount(SortedMap<String, Double> sortedMap, SortedMap<String, List<Integer>> sortedMap2, String string) {
        List list = (List)sortedMap2.get(string);
        int n = 0;
        for (Integer n2 : list) {
            n += n2.intValue();
        }
        sortedMap.put(string, (double)n / (double)list.size());
    }

    private static void calculateMedianCount(SortedMap<BinaryDomainCombination, Double> sortedMap, SortedMap<BinaryDomainCombination, List<Integer>> sortedMap2, BinaryDomainCombination binaryDomainCombination) {
        List list = (List)sortedMap2.get(binaryDomainCombination);
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (Integer n : list) {
            basicDescriptiveStatistics.addValue(n.intValue());
        }
        sortedMap.put(binaryDomainCombination, basicDescriptiveStatistics.median());
    }

    private static void calculateMedianCount(SortedMap<String, Double> sortedMap, SortedMap<String, List<Integer>> sortedMap2, String string) {
        List list = (List)sortedMap2.get(string);
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (Integer n : list) {
            basicDescriptiveStatistics.addValue(n.intValue());
        }
        sortedMap.put(string, basicDescriptiveStatistics.median());
    }

    private static void calculateMinCount(SortedMap<BinaryDomainCombination, Double> sortedMap, SortedMap<BinaryDomainCombination, List<Integer>> sortedMap2, BinaryDomainCombination binaryDomainCombination) {
        List list = (List)sortedMap2.get(binaryDomainCombination);
        int n = Integer.MAX_VALUE;
        for (Integer n2 : list) {
            if (n2 >= n) continue;
            n = n2;
        }
        sortedMap.put(binaryDomainCombination, Double.valueOf(n));
    }

    private static void calculateMinCount(SortedMap<String, Double> sortedMap, SortedMap<String, List<Integer>> sortedMap2, String string) {
        List list = (List)sortedMap2.get(string);
        int n = Integer.MAX_VALUE;
        for (Integer n2 : list) {
            if (n2 >= n) continue;
            n = n2;
        }
        sortedMap.put(string, Double.valueOf(n));
    }

    private static String combinableDomaindToString(CombinableDomains combinableDomains) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(combinableDomains.getKeyDomainProteinsCount());
        return stringBuilder.toString();
    }

    private static String combinableDomaindToStringHtml(CombinableDomains combinableDomains) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(combinableDomains.getKeyDomainCount());
        stringBuilder.append(", <b>");
        stringBuilder.append(combinableDomains.getKeyDomainProteinsCount());
        stringBuilder.append("</b>, ");
        stringBuilder.append(combinableDomains.getNumberOfCombinableDomains());
        stringBuilder.append("]</td><td>");
        stringBuilder.append((CharSequence)combinableDomains.getCombiningDomainIdsAsStringBuilder());
        return stringBuilder.toString();
    }

    private static void writeCopyNumberValues(SortedMap<BinaryDomainCombination, Double> sortedMap, BinaryDomainCombination binaryDomainCombination, GenomeWideCombinableDomains genomeWideCombinableDomains, Map<String, Set<BinaryDomainCombination>> map, String string, Writer writer, String string2) throws IOException {
        writer.write("<td> ");
        if (!ForesterUtil.isEmpty(string2)) {
            writer.write("<font color=\"" + string2 + "\">");
        }
        writer.write("<b>" + string + ":</b> ");
        if (!ForesterUtil.isEmpty(string2)) {
            writer.write("</font>");
        }
        writer.write("</td><td>");
        if (map.get(string).contains(binaryDomainCombination) && (Double)sortedMap.get(binaryDomainCombination) > 0.0) {
            int n = ((BasicCombinableDomains)genomeWideCombinableDomains.get(binaryDomainCombination.getId0())).getCombiningDomains().get(binaryDomainCombination.getId1());
            writer.write(n + "");
        } else {
            writer.write("0");
        }
        writer.write("</td>");
    }

    private static void writeCopyNumberValues(SortedMap<String, Double> sortedMap, String string, GenomeWideCombinableDomains genomeWideCombinableDomains, String string2, Writer writer, Writer writer2, String string3) throws IOException {
        writer.write("  " + string2 + "\t");
        writer2.write("<td> ");
        if (!ForesterUtil.isEmpty(string3)) {
            writer2.write("<font color=\"" + string3 + "\">");
        }
        writer2.write("<b>" + string2 + ":</b> ");
        if (!ForesterUtil.isEmpty(string3)) {
            writer2.write("</font>");
        }
        writer2.write("</td><td>");
        if (genomeWideCombinableDomains.contains(string) && (Double)sortedMap.get(string) > 0.0) {
            writer.write(DomainCountsDifferenceUtil.combinableDomaindToString(genomeWideCombinableDomains.get(string)));
            writer2.write(DomainCountsDifferenceUtil.combinableDomaindToStringHtml(genomeWideCombinableDomains.get(string)));
        } else {
            writer.write("0");
            writer2.write("0");
        }
        writer2.write("</td>");
        writer.write(SurfacingConstants.NL);
    }

    private static void writeDomainCombinationValuesToFiles(List<GenomeWideCombinableDomains> list, List<String> list2, List<String> list3, List<String> list4, int n, Double d, Writer writer, SortedMap<BinaryDomainCombination, Double> sortedMap, SortedMap<BinaryDomainCombination, Double> sortedMap2, SortedMap<BinaryDomainCombination, Double> sortedMap3, SortedSet<BinaryDomainCombination> sortedSet, Map<String, Set<BinaryDomainCombination>> map) throws IOException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        SurfacingUtil.writeHtmlHead(writer, "Binary Domain Combination Copy Differences");
        writer.write("<body><table>");
        for (BinaryDomainCombination binaryDomainCombination : sortedSet) {
            if (!((Double)sortedMap.get(binaryDomainCombination) > 0.0) || !((Double)sortedMap2.get(binaryDomainCombination) > 0.0) || !((Double)sortedMap.get(binaryDomainCombination) >= (Double)sortedMap3.get(binaryDomainCombination)) || !((Double)sortedMap2.get(binaryDomainCombination) >= (double)n + d * (Double)sortedMap3.get(binaryDomainCombination))) continue;
            if ((Double)sortedMap3.get(binaryDomainCombination) <= 0.0) {
                ++n3;
            } else {
                ++n4;
            }
            ++n2;
            writer.write("<tr><td><a href=\"http://pfam.xfam.org/family/" + binaryDomainCombination.getId0() + "\">" + binaryDomainCombination.getId0() + "</a> = <a href=\"" + "http://pfam.xfam.org/family/" + binaryDomainCombination.getId1() + "\">" + binaryDomainCombination.getId1() + "</a>");
            writer.write("</td><td>");
            writer.write("<table>");
            for (GenomeWideCombinableDomains genomeWideCombinableDomains : list) {
                String string = genomeWideCombinableDomains.getSpecies().getSpeciesId();
                if (list3.contains(string)) {
                    writer.write("<tr>");
                    DomainCountsDifferenceUtil.writeCopyNumberValues(sortedMap2, binaryDomainCombination, genomeWideCombinableDomains, map, string, writer, "#0000FF");
                    writer.write("</tr>");
                    continue;
                }
                if (list4.contains(string)) {
                    writer.write("<tr>");
                    DomainCountsDifferenceUtil.writeCopyNumberValues(sortedMap3, binaryDomainCombination, genomeWideCombinableDomains, map, string, writer, "#A0A0A0");
                    writer.write("</tr>");
                    continue;
                }
                if (!list2.contains(string)) continue;
                writer.write("<tr>");
                DomainCountsDifferenceUtil.writeCopyNumberValues(sortedMap, binaryDomainCombination, genomeWideCombinableDomains, map, string, writer, "#404040");
                writer.write("</tr>");
            }
            writer.write("</table>");
            writer.write("</td></tr>");
            writer.write(SurfacingConstants.NL);
        }
        writer.write("</table>");
        writer.write(SurfacingConstants.NL);
        writer.write("<hr>");
        writer.write(SurfacingConstants.NL);
        writer.write("Rule 1: high-copy-base > 0 && high-copy-target > 0 && high-copy-base >= low-copy");
        writer.write("<br>");
        writer.write(SurfacingConstants.NL);
        writer.write("Rule 2: high-copy-target >= minimal-difference + ( factor * low-copy )");
        writer.write("<br>");
        writer.write(SurfacingConstants.NL);
        writer.write("Calculation mode for high copy target : " + (Object)((Object)COPY_CALC_MODE_FOR_HIGH_COPY_TARGET_SPECIES));
        writer.write(SurfacingConstants.NL);
        writer.write("<br>");
        writer.write("Calculation mode for high copy base : " + (Object)((Object)COPY_CALC_MODE_FOR_HIGH_COPY_BASE_SPECIES));
        writer.write(SurfacingConstants.NL);
        writer.write("<br>");
        writer.write("Calculation mode for low copy : " + (Object)((Object)COPY_CALC_MODE_FOR_LOW_COPY_SPECIES));
        writer.write(SurfacingConstants.NL);
        writer.write("<br>");
        writer.write("Minimal difference : " + n);
        writer.write(SurfacingConstants.NL);
        writer.write("<br>");
        writer.write("Factor : " + d);
        writer.write(SurfacingConstants.NL);
        writer.write("<br>");
        writer.write("Lower copy binary domain combinations : " + n2);
        writer.write(SurfacingConstants.NL);
        writer.write("<br>");
        writer.write("Total absence : " + n3);
        writer.write(SurfacingConstants.NL);
        writer.write("<br>");
        writer.write("Not total absence : " + n4);
        writer.write(SurfacingConstants.NL);
        writer.write("<br>");
        writer.write("Total binary domain combinations : " + sortedSet.size());
        writer.write(SurfacingConstants.NL);
        writer.write("<hr>");
        writer.write(SurfacingConstants.NL);
        writer.write("</body></html>");
        writer.write(SurfacingConstants.NL);
        writer.close();
    }

    private static void writeDomainValuesToFiles(List<GenomeWideCombinableDomains> list, List<String> list2, List<String> list3, List<String> list4, int n, Double d, Map<String, List<GoId>> map, Map<GoId, GoTerm> map2, Writer writer, Writer writer2, File file, SortedMap<String, Double> sortedMap, SortedMap<String, Double> sortedMap2, SortedMap<String, Double> sortedMap3, SortedSet<String> sortedSet, SortedSet<GoId> sortedSet2, SortedMap<Species, List<Protein>> sortedMap4) throws IOException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        SurfacingUtil.writeHtmlHead(writer2, "Domain Copy Differences");
        writer2.write("<body><table>");
        for (String string : sortedSet) {
            if (!((Double)sortedMap.get(string) > 0.0) || !((Double)sortedMap2.get(string) > 0.0) || !((Double)sortedMap.get(string) >= (Double)sortedMap3.get(string)) || !((Double)sortedMap2.get(string) >= (double)n + d * (Double)sortedMap3.get(string))) continue;
            if ((Double)sortedMap3.get(string) <= 0.0) {
                ++n3;
            } else {
                ++n4;
            }
            ++n2;
            DomainCountsDifferenceUtil.writeProteinsToFile(file, sortedMap4, string);
            if (map.containsKey(string)) {
                sortedSet2.addAll((Collection<GoId>)map.get(string));
            }
            writer.write(string);
            writer.write(SurfacingConstants.NL);
            writer2.write("<tr><td><a href=\"http://pfam.xfam.org/family/" + string + "\">" + string + "</a></td><td>");
            writer2.write(DomainCountsDifferenceUtil.addGoInformation(string, map, map2).toString());
            writer2.write("</td><td>");
            writer2.write("<table>");
            for (GenomeWideCombinableDomains genomeWideCombinableDomains : list) {
                String string2 = genomeWideCombinableDomains.getSpecies().getSpeciesId();
                if (list3.contains(string2)) {
                    writer2.write("<tr>");
                    DomainCountsDifferenceUtil.writeCopyNumberValues(sortedMap2, string, genomeWideCombinableDomains, string2, writer, writer2, "#0000FF");
                    writer2.write("</tr>");
                    continue;
                }
                if (list4.contains(string2)) {
                    writer2.write("<tr>");
                    DomainCountsDifferenceUtil.writeCopyNumberValues(sortedMap3, string, genomeWideCombinableDomains, string2, writer, writer2, "#A0A0A0");
                    writer2.write("</tr>");
                    continue;
                }
                if (!list2.contains(string2)) continue;
                writer2.write("<tr>");
                DomainCountsDifferenceUtil.writeCopyNumberValues(sortedMap, string, genomeWideCombinableDomains, string2, writer, writer2, "#404040");
                writer2.write("</tr>");
            }
            writer2.write("</table>");
            writer2.write("</td></tr>");
            writer2.write(SurfacingConstants.NL);
            writer.write(SurfacingConstants.NL);
        }
        writer2.write("</table>");
        writer2.write(SurfacingConstants.NL);
        writer2.write("<hr>");
        writer2.write(SurfacingConstants.NL);
        writer2.write("Rule 1: high-copy-base > 0 && high-copy-target > 0 && high-copy-base >= low-copy");
        writer2.write("<br>");
        writer2.write(SurfacingConstants.NL);
        writer2.write("Rule 2: high-copy-target >= minimal-difference + ( factor * low-copy )");
        writer2.write("<br>");
        writer2.write(SurfacingConstants.NL);
        writer2.write("Calculation mode for high copy target : " + (Object)((Object)COPY_CALC_MODE_FOR_HIGH_COPY_TARGET_SPECIES));
        writer2.write(SurfacingConstants.NL);
        writer2.write("<br>");
        writer2.write("Calculation mode for high copy base : " + (Object)((Object)COPY_CALC_MODE_FOR_HIGH_COPY_BASE_SPECIES));
        writer2.write(SurfacingConstants.NL);
        writer2.write("<br>");
        writer2.write("Calculation mode for low copy : " + (Object)((Object)COPY_CALC_MODE_FOR_LOW_COPY_SPECIES));
        writer2.write(SurfacingConstants.NL);
        writer2.write("<br>");
        writer2.write("Minimal difference : " + n);
        writer2.write(SurfacingConstants.NL);
        writer2.write("<br>");
        writer2.write("Factor : " + d);
        writer2.write(SurfacingConstants.NL);
        writer2.write("<br>");
        writer2.write("Lower copy domains : " + n2);
        writer2.write(SurfacingConstants.NL);
        writer2.write("<br>");
        writer2.write("Total absence : " + n3);
        writer2.write(SurfacingConstants.NL);
        writer2.write("<br>");
        writer2.write("Not total absence : " + n4);
        writer2.write(SurfacingConstants.NL);
        writer2.write("<br>");
        writer2.write("Total domains : " + sortedSet.size());
        writer2.write(SurfacingConstants.NL);
        writer2.write("<hr>");
        writer2.write(SurfacingConstants.NL);
        writer2.write("</body></html>");
        writer2.write(SurfacingConstants.NL);
        writer2.close();
        writer.write("# Rule 1: high-copy-base > 0 && high-copy-target > 0 && high-copy-base >= low-copy");
        writer.write(SurfacingConstants.NL);
        writer.write("# Rule 2: high-copy-target >= minimal-difference + ( factor * low-copy )");
        writer.write(SurfacingConstants.NL);
        writer.write("# Calculation mode for high copy target: " + (Object)((Object)COPY_CALC_MODE_FOR_HIGH_COPY_TARGET_SPECIES));
        writer.write(SurfacingConstants.NL);
        writer.write("# Calculation mode for high copy base  : " + (Object)((Object)COPY_CALC_MODE_FOR_HIGH_COPY_BASE_SPECIES));
        writer.write(SurfacingConstants.NL);
        writer.write("# Calculation mode for low copy        : " + (Object)((Object)COPY_CALC_MODE_FOR_LOW_COPY_SPECIES));
        writer.write(SurfacingConstants.NL);
        writer.write("# Minimal difference: " + n);
        writer.write(SurfacingConstants.NL);
        writer.write("# Factor            : " + d);
        writer.write(SurfacingConstants.NL);
        writer.write("# Lower copy domains: " + n2);
        writer.write(SurfacingConstants.NL);
        writer.write("# Total absence     : " + n3);
        writer.write(SurfacingConstants.NL);
        writer.write("# Not total absence : " + n4);
        writer.write(SurfacingConstants.NL);
        writer.write("# Total domains     : " + sortedSet.size());
        writer.write(SurfacingConstants.NL);
        writer.close();
    }

    private static void writeGoIdsToFile(Writer writer, SortedSet<GoId> sortedSet) throws IOException {
        for (GoId goId : sortedSet) {
            writer.write(goId.toString());
            writer.write(SurfacingConstants.NL);
        }
        writer.close();
    }

    private static void writeProteinsToFile(File file, SortedMap<Species, List<Protein>> sortedMap, String string) throws IOException {
        File file2 = new File(file.getParentFile() + ForesterUtil.FILE_SEPARATOR + string + PLUS_MINUS_PROTEINS_FILE_DOM_SUFFIX);
        SurfacingUtil.checkForOutputFileWriteability(file2);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        SurfacingUtil.extractProteinNames(sortedMap, string, bufferedWriter, "\t", surfacing.LIMIT_SPEC_FOR_PROT_EX, -1.0);
        ((Writer)bufferedWriter).close();
        System.out.println("Wrote proteins list to \"" + file2 + "\"");
    }

    public static enum COPY_CALCULATION_MODE {
        MAX,
        MEAN,
        MEDIAN,
        MIN;

    }
}

