/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.ColorSchemeChooser;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.ControlPanel;
import org.forester.archaeopteryx.DefaultFilter;
import org.forester.archaeopteryx.FontChooser;
import org.forester.archaeopteryx.GraphicsFileFilter;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.MsaFileFilter;
import org.forester.archaeopteryx.NHFilter;
import org.forester.archaeopteryx.NHXFilter;
import org.forester.archaeopteryx.NexusFilter;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.PdfExporter;
import org.forester.archaeopteryx.PdfFilter;
import org.forester.archaeopteryx.Printer;
import org.forester.archaeopteryx.SequencesFileFilter;
import org.forester.archaeopteryx.TextFrame;
import org.forester.archaeopteryx.TolFilter;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreeFontSet;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.UrlTreeReader;
import org.forester.archaeopteryx.XMLFilter;
import org.forester.archaeopteryx.tools.AncestralTaxonomyInferrer;
import org.forester.archaeopteryx.tools.InferenceManager;
import org.forester.archaeopteryx.tools.ProcessPool;
import org.forester.archaeopteryx.tools.ProcessRunning;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.NodeDataField;
import org.forester.phylogeny.data.NodeVisualData;
import org.forester.sdi.GSDI;
import org.forester.sdi.GSDIR;
import org.forester.sdi.SDIException;
import org.forester.util.ForesterUtil;
import org.forester.util.WindowsUtils;

public abstract class MainFrame
extends JFrame
implements ActionListener {
    static final NHFilter nhfilter = new NHFilter();
    static final NHXFilter nhxfilter = new NHXFilter();
    static final XMLFilter xmlfilter = new XMLFilter();
    static final TolFilter tolfilter = new TolFilter();
    static final NexusFilter nexusfilter = new NexusFilter();
    static final PdfFilter pdffilter = new PdfFilter();
    static final GraphicsFileFilter graphicsfilefilter = new GraphicsFileFilter();
    static final MsaFileFilter msafilter = new MsaFileFilter();
    static final SequencesFileFilter seqsfilter = new SequencesFileFilter();
    static final DefaultFilter defaultfilter = new DefaultFilter();
    static final String USE_MOUSEWHEEL_SHIFT_TO_ROTATE = "rotate with mousewheel + Shift (or A and S), D toggles between horizontal and radial labels";
    static final String PHYLOXML_REF_TOOL_TIP = "Han MV and Zmasek CM (2009): \"phyloXML: XML for evolutionary biology and comparative genomics\", BMC Bioinformatics 10:356";
    static final String APTX_REF_TOOL_TIP = "Zmasek...";
    private static final long serialVersionUID = 3655000897845508358L;
    static final Font menu_font = new Font(Configuration.getDefaultFontFamilyName(), 0, 10);
    static final String TYPE_MENU_HEADER = "Type";
    static final String RECTANGULAR_TYPE_CBMI_LABEL = "Rectangular";
    static final String EURO_TYPE_CBMI_LABEL = "Euro Type";
    static final String CURVED_TYPE_CBMI_LABEL = "Curved";
    static final String TRIANGULAR_TYPE_CBMI_LABEL = "Triangular";
    static final String CONVEX_TYPE_CBMI_LABEL = "Convex";
    static final String ROUNDED_TYPE_CBMI_LABEL = "Rounded";
    static final String UNROOTED_TYPE_CBMI_LABEL = "Unrooted (alpha)";
    static final String CIRCULAR_TYPE_CBMI_LABEL = "Circular (alpha)";
    static final String OPTIONS_HEADER = "Options";
    static final String SEARCH_SUBHEADER = "Search:";
    static final String DISPLAY_SUBHEADER = "Display:";
    static final String SEARCH_TERMS_ONLY_LABEL = "Words";
    static final String SEARCH_REGEX_LABEL = "Regex";
    static final String SEARCH_CASE_SENSITIVE_LABEL = "Match Case";
    static final String INVERSE_SEARCH_RESULT_LABEL = "Inverse";
    static final String COLOR_BY_TAXONOMIC_GROUP = "Colorize by Taxonomic Group";
    static final String DISPLAY_SCALE_LABEL = "Scale";
    static final String NON_LINED_UP_CLADOGRAMS_LABEL = "Non-Lined Up Cladogram";
    static final String LABEL_DIRECTION_LABEL = "Radial Labels";
    static final String LABEL_DIRECTION_TIP = "To use radial node labels in radial and unrooted display types";
    static final String SEARCH_WITH_REGEX_TIP = "To search using regular expressions (~Java/Perl syntax). For example, use \"^B.+\\d{2,}$\" to search for everything starting with a B and ending with at least two digits.";
    static final String SCREEN_ANTIALIAS_LABEL = "Antialias";
    static final String COLOR_LABELS_LABEL = "Colorize Labels Same as Parent Branch";
    static final String BG_GRAD_LABEL = "Background Color Gradient";
    static final String DISPLAY_NODE_BOXES_LABEL_EXT = "Shapes for External Nodes";
    static final String DISPLAY_NODE_BOXES_LABEL_INT = "Shapes for Internal Nodes";
    static final String DISPLAY_NODE_BOXES_LABEL_MARKED = "Shapes for Nodes with Visual Data";
    static final String SHOW_OVERVIEW_LABEL = "Overview";
    static final String FONT_SIZE_MENU_LABEL = "Font Size";
    static final String NONUNIFORM_CLADOGRAMS_LABEL = "Lined Up Cladogram";
    static final String SHOW_DOMAIN_LABELS_LABEL = "Domain Labels";
    static final String SHOW_ANN_REF_SOURCE_LABEL = "Seq Annotation Ref Sources";
    static final String COLOR_LABELS_TIP = "To use parent branch colors for node labels as well, need to turn off taxonomy dependent colorization and turn on branch colorization for this to become apparent";
    static final String ABBREV_SN_LABEL = "Abbreviate Scientific Taxonomic Names";
    static final String TAXONOMY_COLORIZE_NODE_SHAPES_LABEL = "Colorize Node Shapes According to Taxonomy";
    static final String CYCLE_NODE_SHAPE_LABEL = "Cycle Node Shapes";
    static final String CYCLE_NODE_FILL_LABEL = "Cycle Node Fill Type";
    static final String CHOOSE_NODE_SIZE_LABEL = "Choose Node Shape Size";
    static final String SHOW_CONF_STDDEV_LABEL = "Confidence Standard Deviations";
    static final String USE_BRACKETS_FOR_CONF_IN_NH_LABEL = "Use Brackets for Confidence Values";
    static final String USE_INTERNAL_NAMES_FOR_CONF_IN_NH_LABEL = "Use Internal Node Names for Confidence Values";
    static final String SHOW_BASIC_TREE_INFORMATION_LABEL = "Basic Tree Information";
    static final String RIGHT_LINE_UP_DOMAINS = "Right-align Domain Architectures";
    static final String LINE_UP_RENDERABLE_DATA = "Line Up Diagrams (such as Domain Architectures)";
    static final String INFER_ANCESTOR_TAXONOMIES = "Infer Ancestor Taxonomies";
    static final String OBTAIN_DETAILED_TAXONOMIC_INFORMATION = "Obtain Detailed Taxonomic Information";
    JMenuBar _jmenubar;
    JMenu _file_jmenu;
    JMenu _tools_menu;
    JMenu _view_jmenu;
    JMenu _options_jmenu;
    JMenu _font_size_menu;
    JMenu _help_jmenu;
    JMenuItem[] _load_phylogeny_from_webservice_menu_items;
    JMenu _analysis_menu;
    JMenuItem _load_species_tree_item;
    JMenuItem _gsdi_item;
    JMenuItem _gsdir_item;
    JMenuItem _lineage_inference;
    JMenuItem _open_item;
    JMenuItem _open_url_item;
    JMenuItem _save_item;
    JMenuItem _save_all_item;
    JMenuItem _close_item;
    JMenuItem _exit_item;
    JMenuItem _new_item;
    JMenuItem _print_item;
    JMenuItem _write_to_pdf_item;
    JMenuItem _write_to_jpg_item;
    JMenuItem _write_to_gif_item;
    JMenuItem _write_to_tif_item;
    JMenuItem _write_to_png_item;
    JMenuItem _write_to_bmp_item;
    JMenuItem _midpoint_root_item;
    JMenuItem _taxcolor_item;
    JMenuItem _confcolor_item;
    JMenuItem _color_rank_jmi;
    JMenuItem _collapse_species_specific_subtrees;
    JMenuItem _obtain_detailed_taxonomic_information_jmi;
    JMenuItem _obtain_detailed_taxonomic_information_deleting_jmi;
    JMenuItem _obtain_seq_information_jmi;
    JMenuItem _move_node_names_to_tax_sn_jmi;
    JMenuItem _move_node_names_to_seq_names_jmi;
    JMenuItem _extract_tax_code_from_node_names_jmi;
    JMenuItem _annotate_item;
    JMenuItem _remove_branch_color_item;
    JMenuItem _remove_visual_styles_item;
    JMenuItem _delete_selected_nodes_item;
    JMenuItem _delete_not_selected_nodes_item;
    JMenuItem _super_tiny_fonts_item;
    JMenuItem _tiny_fonts_item;
    JMenuItem _small_fonts_item;
    JMenuItem _medium_fonts_item;
    JMenuItem _large_fonts_item;
    JMenuItem _choose_font_mi;
    JMenuItem _switch_colors_mi;
    JCheckBoxMenuItem _label_direction_cbmi;
    JCheckBoxMenuItem _screen_antialias_cbmi;
    JCheckBoxMenuItem _background_gradient_cbmi;
    JRadioButtonMenuItem _non_lined_up_cladograms_rbmi;
    JRadioButtonMenuItem _ext_node_dependent_cladogram_rbmi;
    JCheckBoxMenuItem _color_by_taxonomic_group_cbmi;
    JCheckBoxMenuItem _show_scale_cbmi;
    JCheckBoxMenuItem _show_overview_cbmi;
    JCheckBoxMenuItem _show_domain_labels;
    JCheckBoxMenuItem _show_annotation_ref_source;
    JCheckBoxMenuItem _abbreviate_scientific_names;
    JCheckBoxMenuItem _color_labels_same_as_parent_branch;
    JMenuItem _overview_placment_mi;
    JMenuItem _choose_minimal_confidence_mi;
    JCheckBoxMenuItem _show_default_node_shapes_internal_cbmi;
    JCheckBoxMenuItem _show_default_node_shapes_external_cbmi;
    JCheckBoxMenuItem _show_default_node_shapes_for_marked_cbmi;
    JMenuItem _cycle_node_shape_mi;
    JMenuItem _cycle_node_fill_mi;
    JMenuItem _choose_node_size_mi;
    JMenuItem _cycle_data_return;
    JCheckBoxMenuItem _show_confidence_stddev_cbmi;
    JCheckBoxMenuItem _right_line_up_domains_cbmi;
    JCheckBoxMenuItem _line_up_renderable_data_cbmi;
    JCheckBoxMenuItem _collapsed_with_average_height_cbmi;
    JCheckBoxMenuItem _show_abbreviated_labels_for_collapsed_nodes_cbmi;
    JCheckBoxMenuItem _graphics_export_visible_only_cbmi;
    JCheckBoxMenuItem _antialias_print_cbmi;
    JCheckBoxMenuItem _print_black_and_white_cbmi;
    JMenuItem _choose_pdf_width_mi;
    JCheckBoxMenuItem _internal_number_are_confidence_for_nh_parsing_cbmi;
    JRadioButtonMenuItem _extract_taxonomy_no_rbmi;
    JRadioButtonMenuItem _extract_taxonomy_agressive_rbmi;
    JRadioButtonMenuItem _extract_taxonomy_pfam_strict_rbmi;
    JRadioButtonMenuItem _extract_taxonomy_pfam_relaxed_rbmi;
    JCheckBoxMenuItem _replace_underscores_cbmi;
    JCheckBoxMenuItem _allow_errors_in_distance_to_parent_cbmi;
    JCheckBoxMenuItem _use_brackets_for_conf_in_nh_export_cbmi;
    JCheckBoxMenuItem _use_internal_names_for_conf_in_nh_export_cbmi;
    JCheckBoxMenuItem _parse_beast_style_extended_nexus_tags_cbmi;
    JCheckBoxMenuItem _search_case_senstive_cbmi;
    JCheckBoxMenuItem _search_whole_words_only_cbmi;
    JCheckBoxMenuItem _inverse_search_result_cbmi;
    JCheckBoxMenuItem _search_with_regex_cbmi;
    JCheckBoxMenuItem _color_all_found_nodes_when_coloring_subtree_cbmi;
    JMenu _type_menu;
    JCheckBoxMenuItem _rectangular_type_cbmi;
    JCheckBoxMenuItem _triangular_type_cbmi;
    JCheckBoxMenuItem _curved_type_cbmi;
    JCheckBoxMenuItem _convex_type_cbmi;
    JCheckBoxMenuItem _euro_type_cbmi;
    JCheckBoxMenuItem _rounded_type_cbmi;
    JCheckBoxMenuItem _unrooted_type_cbmi;
    JCheckBoxMenuItem _circular_type_cbmi;
    JMenuItem _view_as_NH_item;
    JMenuItem _view_as_XML_item;
    JMenuItem _view_as_nexus_item;
    JMenuItem _display_basic_information_item;
    JMenuItem _about_item;
    JMenuItem _help_item;
    JMenuItem _website_item;
    JMenuItem _aptxjs_website_item;
    JMenuItem _mailing_list_item;
    JMenuItem _phyloxml_website_item;
    JMenuItem _phyloxml_ref_item;
    JMenuItem _aptx_ref_item;
    File _current_dir;
    JFileChooser _writetopdf_filechooser;
    JFileChooser _save_filechooser;
    JFileChooser _writetographics_filechooser;
    JMenu _process_menu;
    MainPanel _mainpanel;
    Container _contentpane;
    final LinkedList<TextFrame> _textframes = new LinkedList();
    Configuration _configuration;
    Options _options;
    private Phylogeny _species_tree;
    InferenceManager _inference_manager;
    final ProcessPool _process_pool = ProcessPool.createInstance();
    private String _previous_node_annotation_ref;

    MainFrame() {
        this._writetopdf_filechooser = new JFileChooser();
        this._writetopdf_filechooser.setMultiSelectionEnabled(false);
        this._writetopdf_filechooser.addChoosableFileFilter(pdffilter);
        this._writetographics_filechooser = new JFileChooser();
        this._writetographics_filechooser.setMultiSelectionEnabled(false);
        this._writetographics_filechooser.addChoosableFileFilter(graphicsfilefilter);
        this._save_filechooser = new JFileChooser();
        this._save_filechooser.setMultiSelectionEnabled(false);
        this._save_filechooser.setFileFilter(xmlfilter);
        this._save_filechooser.addChoosableFileFilter(nhfilter);
        this._save_filechooser.addChoosableFileFilter(nexusfilter);
        this._save_filechooser.addChoosableFileFilter(this._save_filechooser.getAcceptAllFileFilter());
        try {
            String string = System.getProperty("user.home");
            this._save_filechooser.setCurrentDirectory(new File(string));
            this._writetopdf_filechooser.setCurrentDirectory(new File(string));
            this._writetographics_filechooser.setCurrentDirectory(new File(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._exit_item) {
            this.close();
        } else if (object == this._gsdi_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            this.executeGSDI();
        } else if (object == this._gsdir_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            this.executeGSDIR();
        } else if (object == this._taxcolor_item) {
            this.taxColor();
        } else if (object == this._confcolor_item) {
            this.confColor();
        } else if (object == this._color_rank_jmi) {
            this.colorRank();
        } else if (object == this._collapse_species_specific_subtrees) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().collapseSpeciesSpecificSubtrees();
            }
        } else if (object == this._remove_branch_color_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            this.removeBranchColors();
        } else if (object == this._remove_visual_styles_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            this.removeVisualStyles();
        } else if (object == this._midpoint_root_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            this.midpointRoot();
        } else if (object == this._delete_selected_nodes_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            this.deleteSelectedNodes(true);
        } else if (object == this._delete_not_selected_nodes_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            this.deleteSelectedNodes(false);
        } else if (object == this._annotate_item) {
            this.annotateSequences();
        } else if (object == this._switch_colors_mi) {
            this.switchColors();
        } else if (object == this._display_basic_information_item) {
            if (this.getCurrentTreePanel() != null) {
                this.displayBasicInformation(this.getCurrentTreePanel().getTreeFile());
            }
        } else if (object == this._view_as_NH_item) {
            this.viewAsNH();
        } else if (object == this._view_as_XML_item) {
            this.viewAsXML();
        } else if (object == this._view_as_nexus_item) {
            this.viewAsNexus();
        } else if (object == this._super_tiny_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setSuperTinyFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (object == this._tiny_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setTinyFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (object == this._small_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setSmallFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (object == this._medium_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setMediumFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (object == this._large_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setLargeFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (object == this._choose_font_mi) {
            this.chooseFont();
        } else if (object == this._choose_minimal_confidence_mi) {
            this.chooseMinimalConfidence();
        } else if (object == this._choose_node_size_mi) {
            MainFrame.chooseNodeSize(this.getOptions(), this);
        } else if (object == this._overview_placment_mi) {
            MainFrame.cycleOverview(this.getOptions(), this.getCurrentTreePanel());
        } else if (object == this._cycle_node_fill_mi) {
            MainFrame.cycleNodeFill(this.getOptions());
        } else if (object == this._cycle_node_shape_mi) {
            MainFrame.cycleNodeShape(this.getOptions());
        } else if (object == this._cycle_data_return) {
            MainFrame.cycleNodeDataReturn(this.getOptions(), this.getConfiguration());
        } else if (object == this._screen_antialias_cbmi) {
            this.updateOptions(this.getOptions());
            MainFrame.updateScreenTextAntialias(this.getMainPanel().getTreePanels());
        } else if (object == this._background_gradient_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._show_domain_labels) {
            this.updateOptions(this.getOptions());
        } else if (object == this._show_annotation_ref_source) {
            this.updateOptions(this.getOptions());
        } else if (object == this._abbreviate_scientific_names) {
            this.updateOptions(this.getOptions());
        } else if (object == this._color_labels_same_as_parent_branch) {
            this.updateOptions(this.getOptions());
        } else if (object == this._show_default_node_shapes_internal_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._show_default_node_shapes_external_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._show_default_node_shapes_for_marked_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._non_lined_up_cladograms_rbmi) {
            this.updateOptions(this.getOptions());
            this.showWhole();
        } else if (object == this._ext_node_dependent_cladogram_rbmi) {
            this.updateOptions(this.getOptions());
            this.showWhole();
        } else if (object == this._search_case_senstive_cbmi) {
            if (this._search_with_regex_cbmi != null && this._search_case_senstive_cbmi.isSelected()) {
                this._search_with_regex_cbmi.setSelected(false);
            }
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search0();
            this.getMainPanel().getControlPanel().search1();
        } else if (object == this._search_whole_words_only_cbmi) {
            if (this._search_with_regex_cbmi != null && this._search_whole_words_only_cbmi.isSelected()) {
                this._search_with_regex_cbmi.setSelected(false);
            }
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search0();
            this.getMainPanel().getControlPanel().search1();
        } else if (object == this._inverse_search_result_cbmi) {
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search0();
            this.getMainPanel().getControlPanel().search1();
        } else if (object == this._search_with_regex_cbmi) {
            if (this._search_whole_words_only_cbmi != null && this._search_with_regex_cbmi.isSelected()) {
                this._search_whole_words_only_cbmi.setSelected(false);
            }
            if (this._search_case_senstive_cbmi != null && this._search_with_regex_cbmi.isSelected()) {
                this._search_case_senstive_cbmi.setSelected(false);
            }
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search0();
            this.getMainPanel().getControlPanel().search1();
        } else if (object == this._color_all_found_nodes_when_coloring_subtree_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._parse_beast_style_extended_nexus_tags_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._show_scale_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._color_by_taxonomic_group_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._show_confidence_stddev_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._use_brackets_for_conf_in_nh_export_cbmi) {
            if (this._use_brackets_for_conf_in_nh_export_cbmi.isSelected()) {
                this._use_internal_names_for_conf_in_nh_export_cbmi.setSelected(false);
            }
            this.updateOptions(this.getOptions());
        } else if (object == this._use_internal_names_for_conf_in_nh_export_cbmi) {
            if (this._use_internal_names_for_conf_in_nh_export_cbmi.isSelected()) {
                this._use_brackets_for_conf_in_nh_export_cbmi.setSelected(false);
            }
            this.updateOptions(this.getOptions());
        } else if (object == this._label_direction_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._show_overview_cbmi) {
            this.updateOptions(this.getOptions());
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().updateOvSizes();
            }
        } else if (object == this._line_up_renderable_data_cbmi) {
            if (!this._line_up_renderable_data_cbmi.isSelected()) {
                this._right_line_up_domains_cbmi.setSelected(false);
            }
            this.updateOptions(this.getOptions());
        } else if (object == this._collapsed_with_average_height_cbmi) {
            if (this._collapsed_with_average_height_cbmi.isSelected()) {
                this._collapsed_with_average_height_cbmi.setSelected(true);
            }
            this.updateOptions(this.getOptions());
        } else if (object == this._show_abbreviated_labels_for_collapsed_nodes_cbmi) {
            if (this._show_abbreviated_labels_for_collapsed_nodes_cbmi.isSelected()) {
                this._show_abbreviated_labels_for_collapsed_nodes_cbmi.setSelected(true);
            }
            this.updateOptions(this.getOptions());
        } else if (object == this._right_line_up_domains_cbmi) {
            if (this._right_line_up_domains_cbmi.isSelected()) {
                this._line_up_renderable_data_cbmi.setSelected(true);
            }
            this.updateOptions(this.getOptions());
        } else if (object == this._rectangular_type_cbmi || object == this._triangular_type_cbmi || object == this._curved_type_cbmi || object == this._convex_type_cbmi || object == this._euro_type_cbmi || object == this._rounded_type_cbmi || object == this._unrooted_type_cbmi || object == this._circular_type_cbmi) {
            this.typeChanged(object);
        } else if (object == this._about_item) {
            this.about();
        } else if (object == this._help_item) {
            try {
                AptxUtil.openWebsite("https://sites.google.com/site/cmzmasek/home/software/archaeopteryx/documentation");
            }
            catch (IOException iOException) {
                ForesterUtil.printErrorMessage("Archaeopteryx", iOException.toString());
            }
        } else if (object == this._website_item) {
            try {
                AptxUtil.openWebsite("https://sites.google.com/site/cmzmasek/home/software/archaeopteryx");
            }
            catch (IOException iOException) {
                ForesterUtil.printErrorMessage("Archaeopteryx", iOException.toString());
            }
        } else if (object == this._aptxjs_website_item) {
            try {
                AptxUtil.openWebsite("https://sites.google.com/site/cmzmasek/home/software/archaeopteryx-js");
            }
            catch (IOException iOException) {
                ForesterUtil.printErrorMessage("Archaeopteryx", iOException.toString());
            }
        } else if (object == this._mailing_list_item) {
            try {
                AptxUtil.openWebsite("https://groups.google.com/forum/?fromgroups#!forum/archaeopteryx");
            }
            catch (IOException iOException) {
                ForesterUtil.printErrorMessage("Archaeopteryx", iOException.toString());
            }
        } else if (object == this._phyloxml_website_item) {
            try {
                AptxUtil.openWebsite("http://www.phyloxml.org");
            }
            catch (IOException iOException) {
                ForesterUtil.printErrorMessage("Archaeopteryx", iOException.toString());
            }
        } else if (object == this._aptx_ref_item) {
            try {
                AptxUtil.openWebsite("http://www.biomedcentral.com/bmcbioinformatics/");
            }
            catch (IOException iOException) {
                ForesterUtil.printErrorMessage("Archaeopteryx", iOException.toString());
            }
        } else if (object == this._phyloxml_ref_item) {
            try {
                AptxUtil.openWebsite("http://www.biomedcentral.com/1471-2105/10/356/");
            }
            catch (IOException iOException) {
                ForesterUtil.printErrorMessage("Archaeopteryx", iOException.toString());
            }
        } else if (object == this._write_to_pdf_item) {
            File file = MainFrame.writeToPdf(this._mainpanel.getCurrentPhylogeny(), this.getMainPanel(), this._writetopdf_filechooser, this._current_dir, this.getContentPane(), this);
            if (file != null) {
                this.setCurrentDir(file);
            }
        } else if (object == this._save_all_item) {
            this.writeAllToFile();
        } else if (object == this._write_to_jpg_item) {
            File file = MainFrame.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), AptxUtil.GraphicsExportType.JPG, this._mainpanel, this._writetographics_filechooser, this, this.getContentPane(), this._current_dir);
            if (file != null) {
                this.setCurrentDir(file);
            }
        } else if (object == this._write_to_gif_item) {
            File file = MainFrame.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), AptxUtil.GraphicsExportType.GIF, this._mainpanel, this._writetographics_filechooser, this, this.getContentPane(), this._current_dir);
            if (file != null) {
                this.setCurrentDir(file);
            }
        } else if (object == this._write_to_tif_item) {
            File file = MainFrame.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), AptxUtil.GraphicsExportType.TIFF, this._mainpanel, this._writetographics_filechooser, this, this.getContentPane(), this._current_dir);
            if (file != null) {
                this.setCurrentDir(file);
            }
        } else if (object == this._write_to_bmp_item) {
            File file = MainFrame.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), AptxUtil.GraphicsExportType.BMP, this._mainpanel, this._writetographics_filechooser, this, this.getContentPane(), this._current_dir);
            if (file != null) {
                this.setCurrentDir(file);
            }
        } else if (object == this._write_to_png_item) {
            File file = MainFrame.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), AptxUtil.GraphicsExportType.PNG, this._mainpanel, this._writetographics_filechooser, this, this.getContentPane(), this._current_dir);
            if (file != null) {
                this.setCurrentDir(file);
            }
        } else if (object == this._print_item) {
            MainFrame.print(this.getCurrentTreePanel(), this.getOptions(), this);
        } else if (object == this._save_item) {
            File file = MainFrame.writeToFile(this._mainpanel.getCurrentPhylogeny(), this.getMainPanel(), this._save_filechooser, this._current_dir, this.getContentPane(), this);
            if (file != null) {
                this.setCurrentDir(file);
            }
        } else if (object == this._graphics_export_visible_only_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._antialias_print_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._print_black_and_white_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._choose_pdf_width_mi) {
            this.choosePdfWidth();
        } else if (object == this._lineage_inference) {
            if (this.isSubtreeDisplayed()) {
                JOptionPane.showMessageDialog(this, "Subtree is shown.", "Cannot infer ancestral taxonomies", 0);
                return;
            }
            this.executeLineageInference();
        } else if (this._load_phylogeny_from_webservice_menu_items != null) {
            for (int i = 0; i < this._load_phylogeny_from_webservice_menu_items.length; ++i) {
                if (object != this._load_phylogeny_from_webservice_menu_items[i]) continue;
                this.readPhylogeniesFromWebservice(i);
            }
        }
        this._contentpane.repaint();
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public String getCurrentExternalNodesDataBuffer() {
        return this.getCurrentTreePanel().getCurrentExternalNodesDataBufferAsString();
    }

    public int getCurrentExternalNodesDataBufferChangeCounter() {
        return this.getCurrentTreePanel().getCurrentExternalNodesDataBufferChangeCounter();
    }

    public int getCurrentExternalNodesDataBufferLength() {
        return this.getCurrentTreePanel().getCurrentExternalNodesDataBufferAsString().length();
    }

    public InferenceManager getInferenceManager() {
        return this._inference_manager;
    }

    public MainPanel getMainPanel() {
        return this._mainpanel;
    }

    public Options getOptions() {
        return this._options;
    }

    public ProcessPool getProcessPool() {
        return this._process_pool;
    }

    public void showTextFrame(String string, String string2) {
        this.checkTextFrames();
        this._textframes.addLast(TextFrame.instantiate(string, string2, this._textframes));
    }

    public void showWhole() {
        this._mainpanel.getControlPanel().showWhole();
    }

    public void updateProcessMenu() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.doUpdateProcessMenu();
            }
        });
    }

    private void annotateSequences() {
        if (this.getCurrentTreePanel() != null) {
            List<PhylogenyNode> list = null;
            if (this.getCurrentTreePanel().getFoundNodes0() != null || this.getCurrentTreePanel().getFoundNodes1() != null) {
                list = this.getCurrentTreePanel().getFoundNodesAsListOfPhylogenyNodes();
            }
            if (list == null || list.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Need to select nodes, either via direct selection or via the \"Search\" function", "No nodes selected for annotation", 0);
                return;
            }
            Phylogeny phylogeny = this.getMainPanel().getCurrentPhylogeny();
            if (phylogeny != null && !phylogeny.isEmpty()) {
                JTextField jTextField = new JTextField(10);
                JTextField jTextField2 = new JTextField(20);
                jTextField.setText(ForesterUtil.isEmpty(this.getPreviousNodeAnnotationReference()) ? "" : this.getPreviousNodeAnnotationReference());
                JPanel jPanel = new JPanel();
                jPanel.add(new JLabel("Reference "));
                jPanel.add(jTextField);
                jPanel.add(Box.createHorizontalStrut(15));
                jPanel.add(new JLabel("Description "));
                jPanel.add(jTextField2);
                int n = JOptionPane.showConfirmDialog(null, jPanel, "Enter the sequence annotation(s) for the " + list.size() + " selected nodes", 2);
                if (n == 0) {
                    String string = jTextField.getText();
                    String string2 = jTextField2.getText();
                    if (!ForesterUtil.isEmpty(string)) {
                        string = string.trim();
                        if ((string = string.replaceAll("\\s+", " ")).indexOf(58) < 1 || string.indexOf(58) > string.length() - 2 || string.length() < 3) {
                            JOptionPane.showMessageDialog(this, "Reference needs to be in the form of \"GO:1234567\"", "Illegal Format for Annotation Reference", 0);
                            return;
                        }
                    }
                    if (string != null) {
                        this.setPreviousNodeAnnotationReference(string);
                    }
                    if (string2 != null) {
                        string2 = string2.trim();
                        string2 = string2.replaceAll("\\s+", " ");
                    }
                    if (!ForesterUtil.isEmpty(string) || !ForesterUtil.isEmpty(string2)) {
                        for (PhylogenyNode phylogenyNode : list) {
                            Annotation annotation;
                            ForesterUtil.ensurePresenceOfSequence(phylogenyNode);
                            Annotation annotation2 = annotation = ForesterUtil.isEmpty(string) ? new Annotation() : new Annotation(string);
                            if (!ForesterUtil.isEmpty(string2)) {
                                annotation.setDesc(string2);
                            }
                            phylogenyNode.getNodeData().getSequence().addAnnotation(annotation);
                        }
                    }
                    this.getMainPanel().getControlPanel().showAnnotations();
                }
            }
        }
    }

    private void chooseFont() {
        FontChooser fontChooser = new FontChooser();
        fontChooser.setFont(this.getMainPanel().getTreeFontSet().getLargeFont());
        fontChooser.showDialog(this, "Select the Base Font");
        this.getMainPanel().getTreeFontSet().setBaseFont(fontChooser.getFont());
        this.getControlPanel().displayedPhylogenyMightHaveChanged(true);
        if (this.getMainPanel().getCurrentTreePanel() != null) {
            this.getMainPanel().getCurrentTreePanel().resetPreferredSize();
            this.getMainPanel().getCurrentTreePanel().updateOvSizes();
        }
        this.repaint();
    }

    private void chooseMinimalConfidence() {
        String string = (String)JOptionPane.showInputDialog(this, "Please enter the minimum for confidence values to be displayed.\n[current value: " + this.getOptions().getMinConfidenceValue() + "]\n", "Minimal Confidence Value", 3, null, null, this.getOptions().getMinConfidenceValue());
        if (!ForesterUtil.isEmpty(string)) {
            boolean bl = true;
            double d = 0.0;
            String string2 = string.trim();
            if (!ForesterUtil.isEmpty(string2)) {
                try {
                    d = Double.parseDouble(string2);
                }
                catch (Exception exception) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl && d >= 0.0) {
                this.getOptions().setMinConfidenceValue(d);
            }
        }
    }

    private void deleteSelectedNodes(boolean bl) {
        Object object;
        Phylogeny phylogeny = this.getMainPanel().getCurrentPhylogeny();
        if (phylogeny == null || phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        if (this.getCurrentTreePanel().getFoundNodes0() != null || this.getCurrentTreePanel().getFoundNodes1() != null) {
            object = this.getCurrentTreePanel().getFoundNodesAsListOfPhylogenyNodes();
            Iterator<PhylogenyNode> iterator = object.iterator();
            while (iterator.hasNext()) {
                PhylogenyNode phylogenyNode = iterator.next();
                if (!phylogenyNode.isExternal()) continue;
                arrayList.add(phylogenyNode);
            }
        }
        object = "Retain";
        if (bl) {
            object = "Delete";
        }
        if (arrayList == null || arrayList.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Need to select external nodes, either via direct selection or via the \"Search\" function", "No external nodes selected to " + ((String)object).toLowerCase(), 0);
            return;
        }
        int n = arrayList.size();
        int n2 = phylogeny.getNumberOfExternalNodes();
        int n3 = n;
        if (bl) {
            n3 = n2 - n;
        }
        if (n3 < 1) {
            JOptionPane.showMessageDialog(this, "Cannot delete all nodes", "Attempt to delete all nodes ", 0);
            return;
        }
        int n4 = JOptionPane.showConfirmDialog(null, (String)object + " " + n + " external node(s), from a total of " + n2 + " external nodes,\nresulting in tree with " + n3 + " nodes?", (String)object + " external nodes", 2);
        if (n4 == 0) {
            if (!bl) {
                ArrayList<PhylogenyNode> arrayList2 = new ArrayList<PhylogenyNode>();
                Iterator<PhylogenyNode> iterator = phylogeny.iteratorExternalForward();
                while (iterator.hasNext()) {
                    PhylogenyNode phylogenyNode = iterator.next();
                    if (arrayList.contains(phylogenyNode)) continue;
                    arrayList2.add(phylogenyNode);
                }
                for (PhylogenyNode phylogenyNode : arrayList2) {
                    phylogeny.deleteSubtree(phylogenyNode, true);
                }
            } else {
                for (PhylogenyNode phylogenyNode : arrayList) {
                    phylogeny.deleteSubtree(phylogenyNode, true);
                }
            }
            this.resetSearch();
            this.getCurrentTreePanel().setNodeInPreorderToNull();
            phylogeny.externalNodesHaveChanged();
            phylogeny.clearHashIdToNodeMap();
            phylogeny.recalculateNumberOfExternalDescendants(true);
            this.getCurrentTreePanel().resetNodeIdToDistToLeafMap();
            this.getCurrentTreePanel().setEdited(true);
            this.repaint();
        }
    }

    private void doUpdateProcessMenu() {
        if (this._process_pool.size() > 0) {
            if (this._process_menu == null) {
                this._process_menu = MainFrame.createMenu("", this.getConfiguration());
                this._process_menu.setForeground(Color.RED);
            }
            this._process_menu.removeAll();
            String string = "processes running: " + this._process_pool.size();
            this._process_menu.setText(string);
            this._jmenubar.add(this._process_menu);
            for (int i = 0; i < this._process_pool.size(); ++i) {
                ProcessRunning processRunning = this._process_pool.getProcessByIndex(i);
                this._process_menu.add(this.customizeJMenuItem(new JMenuItem(processRunning.getName() + " [" + processRunning.getStart() + "]")));
            }
        } else if (this._process_menu != null) {
            this._process_menu.removeAll();
            this._jmenubar.remove(this._process_menu);
        }
        this._jmenubar.validate();
        this._jmenubar.repaint();
        this.repaint();
    }

    private String getPreviousNodeAnnotationReference() {
        return this._previous_node_annotation_ref;
    }

    private void removeBranchColors() {
        if (this.getMainPanel().getCurrentPhylogeny() != null) {
            AptxUtil.removeBranchColors(this.getMainPanel().getCurrentPhylogeny());
        }
    }

    private void removeVisualStyles() {
        if (this.getMainPanel().getCurrentPhylogeny() != null) {
            AptxUtil.removeVisualStyles(this.getMainPanel().getCurrentPhylogeny());
        }
    }

    private void setPreviousNodeAnnotationReference(String string) {
        this._previous_node_annotation_ref = string;
    }

    private void writeAllToFile() {
        if (this.getMainPanel().getTabbedPane() == null || this.getMainPanel().getTabbedPane().getTabCount() < 1) {
            return;
        }
        File file = this.getCurrentDir();
        if (file != null) {
            this._save_filechooser.setCurrentDirectory(file);
        }
        this._save_filechooser.setSelectedFile(new File(""));
        int n = this._save_filechooser.showSaveDialog(this._contentpane);
        File file2 = this._save_filechooser.getSelectedFile();
        this.setCurrentDir(this._save_filechooser.getCurrentDirectory());
        if (file2 != null && n == 0) {
            int n2;
            if (file2.exists()) {
                n2 = JOptionPane.showConfirmDialog(this, file2 + " already exists. Overwrite?", "Warning", 2, 2);
                if (n2 != 0) {
                    return;
                }
                try {
                    file2.delete();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Failed to delete: " + file2, "Error", 2);
                }
            }
            n2 = this.getMainPanel().getTabbedPane().getTabCount();
            ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>();
            for (int i = 0; i < n2; ++i) {
                Phylogeny phylogeny = this.getMainPanel().getPhylogeny(i);
                if (ForesterUtil.isEmpty(phylogeny.getName()) && !ForesterUtil.isEmpty(this.getMainPanel().getTabbedPane().getTitleAt(i))) {
                    phylogeny.setName(this.getMainPanel().getTabbedPane().getTitleAt(i));
                }
                arrayList.add(phylogeny);
                this.getMainPanel().getTreePanels().get(i).setEdited(false);
            }
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            try {
                phylogenyWriter.toPhyloXML(file2, arrayList, 0, ForesterUtil.LINE_SEPARATOR);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Failed to write to: " + file2, "Error", 2);
            }
        }
    }

    void activateSaveAllIfNeeded() {
        if (this.getMainPanel().getTabbedPane() != null && this.getMainPanel().getTabbedPane().getTabCount() > 1) {
            this._save_all_item.setEnabled(true);
        } else {
            this._save_all_item.setEnabled(false);
        }
    }

    void buildFileMenu() {
        this._file_jmenu = MainFrame.createMenu("File", this.getConfiguration());
        this._save_item = new JMenuItem("Save Tree As...");
        this._file_jmenu.add(this._save_item);
        this._file_jmenu.addSeparator();
        this._write_to_pdf_item = new JMenuItem("Export to PDF file ...");
        this._file_jmenu.add(this._write_to_pdf_item);
        if (AptxUtil.canWriteFormat("tif") || AptxUtil.canWriteFormat("tiff") || AptxUtil.canWriteFormat("TIF")) {
            this._write_to_tif_item = new JMenuItem("Export to TIFF file...");
            this._file_jmenu.add(this._write_to_tif_item);
        }
        this._write_to_png_item = new JMenuItem("Export to PNG file...");
        this._file_jmenu.add(this._write_to_png_item);
        this._write_to_jpg_item = new JMenuItem("Export to JPG file...");
        this._file_jmenu.add(this._write_to_jpg_item);
        if (AptxUtil.canWriteFormat("gif")) {
            this._write_to_gif_item = new JMenuItem("Export to GIF file...");
            this._file_jmenu.add(this._write_to_gif_item);
        }
        if (AptxUtil.canWriteFormat("bmp")) {
            this._write_to_bmp_item = new JMenuItem("Export to BMP file...");
            this._file_jmenu.add(this._write_to_bmp_item);
        }
        this._file_jmenu.addSeparator();
        this._print_item = new JMenuItem("Print...");
        this._file_jmenu.add(this._print_item);
        this._file_jmenu.addSeparator();
        this._exit_item = new JMenuItem("Exit");
        this._file_jmenu.add(this._exit_item);
        this.customizeJMenuItem(this._save_item);
        this.customizeJMenuItem(this._write_to_pdf_item);
        this.customizeJMenuItem(this._write_to_png_item);
        this.customizeJMenuItem(this._write_to_jpg_item);
        this.customizeJMenuItem(this._write_to_gif_item);
        this.customizeJMenuItem(this._write_to_tif_item);
        this.customizeJMenuItem(this._write_to_bmp_item);
        this.customizeJMenuItem(this._print_item);
        this.customizeJMenuItem(this._exit_item);
        this._jmenubar.add(this._file_jmenu);
    }

    void buildFontSizeMenu() {
        this._font_size_menu = MainFrame.createMenu(FONT_SIZE_MENU_LABEL, this.getConfiguration());
        this._super_tiny_fonts_item = new JMenuItem("Super Tiny Fonts");
        this._font_size_menu.add(this._super_tiny_fonts_item);
        this._tiny_fonts_item = new JMenuItem("Tiny Fonts");
        this._font_size_menu.add(this._tiny_fonts_item);
        this._small_fonts_item = new JMenuItem("Small Fonts");
        this._font_size_menu.add(this._small_fonts_item);
        this._medium_fonts_item = new JMenuItem("Medium Fonts");
        this._font_size_menu.add(this._medium_fonts_item);
        this._large_fonts_item = new JMenuItem("Large Fonts");
        this._font_size_menu.add(this._large_fonts_item);
        this.customizeJMenuItem(this._super_tiny_fonts_item);
        this.customizeJMenuItem(this._tiny_fonts_item);
        this.customizeJMenuItem(this._small_fonts_item);
        this.customizeJMenuItem(this._medium_fonts_item);
        this.customizeJMenuItem(this._large_fonts_item);
        this._jmenubar.add(this._font_size_menu);
    }

    void buildHelpMenu() {
        this._help_jmenu = MainFrame.createMenu("Help", this.getConfiguration());
        this._help_item = new JMenuItem("Documentation");
        this._help_jmenu.add(this._help_item);
        this._help_jmenu.addSeparator();
        this._website_item = new JMenuItem("Archaeopteryx Home");
        this._help_jmenu.add(this._website_item);
        this._aptxjs_website_item = new JMenuItem("NEW! Archaeopteryx online version: Archaeopteryx.js");
        this._help_jmenu.add(this._aptxjs_website_item);
        this._mailing_list_item = new JMenuItem("Mailing List");
        this._help_jmenu.add(this._mailing_list_item);
        this._aptx_ref_item = new JMenuItem("Archaeopteryx Reference");
        this._phyloxml_website_item = new JMenuItem("phyloXML Home");
        this._help_jmenu.add(this._phyloxml_website_item);
        this._phyloxml_ref_item = new JMenuItem("phyloXML Reference");
        this._help_jmenu.add(this._phyloxml_ref_item);
        this._help_jmenu.addSeparator();
        this._about_item = new JMenuItem("About");
        this._help_jmenu.add(this._about_item);
        this.customizeJMenuItem(this._help_item);
        this.customizeJMenuItem(this._website_item);
        this.customizeJMenuItem(this._aptxjs_website_item);
        this.customizeJMenuItem(this._mailing_list_item);
        this.customizeJMenuItem(this._phyloxml_website_item);
        this.customizeJMenuItem(this._aptx_ref_item);
        this.customizeJMenuItem(this._phyloxml_ref_item);
        this.customizeJMenuItem(this._about_item);
        this._phyloxml_ref_item.setToolTipText(PHYLOXML_REF_TOOL_TIP);
        this._aptx_ref_item.setToolTipText(APTX_REF_TOOL_TIP);
        this._jmenubar.add(this._help_jmenu);
    }

    void buildTypeMenu() {
        this._type_menu = MainFrame.createMenu(TYPE_MENU_HEADER, this.getConfiguration());
        this._rectangular_type_cbmi = new JCheckBoxMenuItem(RECTANGULAR_TYPE_CBMI_LABEL);
        this._type_menu.add(this._rectangular_type_cbmi);
        this._euro_type_cbmi = new JCheckBoxMenuItem(EURO_TYPE_CBMI_LABEL);
        this._type_menu.add(this._euro_type_cbmi);
        this._rounded_type_cbmi = new JCheckBoxMenuItem(ROUNDED_TYPE_CBMI_LABEL);
        this._type_menu.add(this._rounded_type_cbmi);
        this._curved_type_cbmi = new JCheckBoxMenuItem(CURVED_TYPE_CBMI_LABEL);
        this._type_menu.add(this._curved_type_cbmi);
        this._triangular_type_cbmi = new JCheckBoxMenuItem(TRIANGULAR_TYPE_CBMI_LABEL);
        this._type_menu.add(this._triangular_type_cbmi);
        this._convex_type_cbmi = new JCheckBoxMenuItem(CONVEX_TYPE_CBMI_LABEL);
        this._type_menu.add(this._convex_type_cbmi);
        this._unrooted_type_cbmi = new JCheckBoxMenuItem(UNROOTED_TYPE_CBMI_LABEL);
        this._type_menu.add(this._unrooted_type_cbmi);
        this._circular_type_cbmi = new JCheckBoxMenuItem(CIRCULAR_TYPE_CBMI_LABEL);
        this._type_menu.add(this._circular_type_cbmi);
        this.customizeCheckBoxMenuItem(this._rectangular_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._triangular_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._euro_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._rounded_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._curved_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._convex_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._unrooted_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._circular_type_cbmi, false);
        this._triangular_type_cbmi.setToolTipText("not suitable for phylograms");
        this._curved_type_cbmi.setToolTipText("not suitable for phylograms");
        this._unrooted_type_cbmi.setToolTipText(USE_MOUSEWHEEL_SHIFT_TO_ROTATE);
        this._circular_type_cbmi.setToolTipText(USE_MOUSEWHEEL_SHIFT_TO_ROTATE);
        this.initializeTypeMenu(this.getOptions());
        this._jmenubar.add(this._type_menu);
    }

    void buildViewMenu() {
        this._view_jmenu = MainFrame.createMenu("View", this.getConfiguration());
        this._display_basic_information_item = new JMenuItem(SHOW_BASIC_TREE_INFORMATION_LABEL);
        this._view_jmenu.add(this._display_basic_information_item);
        this._view_jmenu.addSeparator();
        this._view_as_XML_item = new JMenuItem("as phyloXML");
        this._view_jmenu.add(this._view_as_XML_item);
        this._view_as_NH_item = new JMenuItem("as Newick");
        this._view_jmenu.add(this._view_as_NH_item);
        this._view_as_nexus_item = new JMenuItem("as Nexus");
        this._view_jmenu.add(this._view_as_nexus_item);
        this.customizeJMenuItem(this._display_basic_information_item);
        this.customizeJMenuItem(this._view_as_NH_item);
        this.customizeJMenuItem(this._view_as_XML_item);
        this.customizeJMenuItem(this._view_as_nexus_item);
        this._jmenubar.add(this._view_jmenu);
    }

    void checkTextFrames() {
        if (this._textframes.size() > 5) {
            try {
                if (this._textframes.getFirst() != null) {
                    this._textframes.getFirst().removeMe();
                } else {
                    this._textframes.removeFirst();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    void choosePdfWidth() {
        String string = (String)JOptionPane.showInputDialog(this, "Please enter the default line width for PDF export.\n[current value: " + this.getOptions().getPrintLineWidth() + "]\n", "Line Width for PDF Export", 3, null, null, Float.valueOf(this.getOptions().getPrintLineWidth()));
        if (!ForesterUtil.isEmpty(string)) {
            boolean bl = true;
            float f = 0.0f;
            String string2 = string.trim();
            if (!ForesterUtil.isEmpty(string2)) {
                try {
                    f = Float.parseFloat(string2);
                }
                catch (Exception exception) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl && (double)f > 0.0) {
                this.getOptions().setPrintLineWidth(f);
            }
        }
    }

    void close() {
        this.removeAllTextFrames();
        if (this._mainpanel != null) {
            this._mainpanel.terminate();
        }
        if (this._contentpane != null) {
            this._contentpane.removeAll();
        }
        this.setVisible(false);
        this.dispose();
    }

    void colorRank() {
        Map<String, Integer> map;
        Object[] objectArray;
        String string;
        if (this._mainpanel.getCurrentTreePanel() != null && !ForesterUtil.isEmpty(string = (String)JOptionPane.showInputDialog(this, "What rank should the colorization be based on", "Rank Selection", 3, null, objectArray = AptxUtil.getAllPossibleRanks(map = AptxUtil.getRankCounts(this._mainpanel.getCurrentTreePanel().getPhylogeny())), null))) {
            if (string.indexOf(40) > 0) {
                string = string.substring(0, string.indexOf(40)).trim();
            }
            this._mainpanel.getCurrentTreePanel().colorRank(string);
        }
    }

    void confColor() {
        if (this._mainpanel.getCurrentTreePanel() != null) {
            this._mainpanel.getCurrentTreePanel().confColor();
        }
    }

    void customizeCheckBoxMenuItem(JCheckBoxMenuItem jCheckBoxMenuItem, boolean bl) {
        if (jCheckBoxMenuItem != null) {
            jCheckBoxMenuItem.setFont(menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                jCheckBoxMenuItem.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
                jCheckBoxMenuItem.setForeground(this.getConfiguration().getGuiMenuTextColor());
            }
            jCheckBoxMenuItem.setSelected(bl);
            jCheckBoxMenuItem.addActionListener(this);
        }
    }

    JMenuItem customizeJMenuItem(JMenuItem jMenuItem) {
        if (jMenuItem != null) {
            jMenuItem.setFont(menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                jMenuItem.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
                jMenuItem.setForeground(this.getConfiguration().getGuiMenuTextColor());
            }
            jMenuItem.addActionListener(this);
        }
        return jMenuItem;
    }

    void customizeRadioButtonMenuItem(JRadioButtonMenuItem jRadioButtonMenuItem, boolean bl) {
        if (jRadioButtonMenuItem != null) {
            jRadioButtonMenuItem.setFont(menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                jRadioButtonMenuItem.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
                jRadioButtonMenuItem.setForeground(this.getConfiguration().getGuiMenuTextColor());
            }
            jRadioButtonMenuItem.setSelected(bl);
            jRadioButtonMenuItem.addActionListener(this);
        }
    }

    void displayBasicInformation(File file) {
        if (this._mainpanel.getCurrentPhylogeny() != null && !this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            String string = "Basic Information";
            if (!ForesterUtil.isEmpty(this._mainpanel.getCurrentPhylogeny().getName())) {
                string = string + " for \"" + this._mainpanel.getCurrentPhylogeny().getName() + "\"";
            }
            this.showTextFrame(AptxUtil.createBasicInformation(this._mainpanel.getCurrentPhylogeny(), file), string);
        }
    }

    void exceptionOccuredDuringOpenFile(Exception exception) {
        try {
            this._mainpanel.getCurrentTreePanel().setArrowCursor();
        }
        catch (Exception exception2) {
            // empty catch block
        }
        JOptionPane.showMessageDialog(this, ForesterUtil.wordWrap(exception.getLocalizedMessage(), 80), "Error during File|Open", 0);
    }

    void executeGSDI() {
        if (!this.isOKforSDI(false, true)) {
            return;
        }
        if (!this._mainpanel.getCurrentPhylogeny().isRooted()) {
            JOptionPane.showMessageDialog(this, "Gene tree is not rooted.", "Cannot execute GSDI", 0);
            return;
        }
        Phylogeny phylogeny = this._mainpanel.getCurrentPhylogeny().copy();
        phylogeny.setAllNodesToNotCollapse();
        phylogeny.recalculateNumberOfExternalDescendants(false);
        GSDI gSDI = null;
        Phylogeny phylogeny2 = this.getSpeciesTree().copy();
        try {
            gSDI = new GSDI(phylogeny, phylogeny2, false, true, true, true);
        }
        catch (SDIException sDIException) {
            JOptionPane.showMessageDialog(this, sDIException.getLocalizedMessage(), "Error during GSDI", 0);
            return;
        }
        catch (Exception exception) {
            AptxUtil.unexpectedException(exception);
            return;
        }
        phylogeny.setRerootable(false);
        phylogeny.clearHashIdToNodeMap();
        phylogeny.recalculateNumberOfExternalDescendants(true);
        this._mainpanel.addPhylogenyInNewTab(phylogeny, this.getConfiguration(), "gene tree", null);
        this.getMainPanel().getControlPanel().setShowEvents(true);
        this.showWhole();
        int n = this._mainpanel.getTabbedPane().getSelectedIndex();
        this._mainpanel.addPhylogenyInNewTab(phylogeny2, this.getConfiguration(), "species tree", null);
        this.showWhole();
        this._mainpanel.getTabbedPane().setSelectedIndex(n);
        this.showWhole();
        this._mainpanel.getCurrentTreePanel().setEdited(true);
        int n2 = PhylogenyMethods.countNumberOfPolytomies(phylogeny2);
        if (gSDI.getStrippedExternalGeneTreeNodes().size() > 0) {
            JOptionPane.showMessageDialog(this, "Duplications: " + gSDI.getDuplicationsSum() + "\nPotential duplications: " + gSDI.getSpeciationOrDuplicationEventsSum() + "\nSpeciations: " + gSDI.getSpeciationsSum() + "\nStripped gene tree nodes: " + gSDI.getStrippedExternalGeneTreeNodes().size() + "\nTaxonomy linkage based on: " + (Object)((Object)gSDI.getTaxCompBase()) + "\nNumber of polytomies in species tree used: " + n2 + "\n", "GSDI successfully completed", 2);
        } else {
            JOptionPane.showMessageDialog(this, "Duplications: " + gSDI.getDuplicationsSum() + "\nPotential duplications: " + gSDI.getSpeciationOrDuplicationEventsSum() + "\nSpeciations: " + gSDI.getSpeciationsSum() + "\nStripped gene tree nodes: " + gSDI.getStrippedExternalGeneTreeNodes().size() + "\nTaxonomy linkage based on: " + (Object)((Object)gSDI.getTaxCompBase()) + "\nNumber of polytomies in species tree used: " + n2 + "\n", "GSDI successfully completed", 1);
        }
    }

    void executeGSDIR() {
        if (!this.isOKforSDI(false, false)) {
            return;
        }
        int n = PhylogenyMethods.countNumberOfPolytomies(this._mainpanel.getCurrentPhylogeny());
        if (n > 0 && (n != 1 || this._mainpanel.getCurrentPhylogeny().getRoot().getNumberOfDescendants() != 3)) {
            JOptionPane.showMessageDialog(this, "Gene tree is not completely binary", "Cannot execute GSDI", 0);
            return;
        }
        Phylogeny phylogeny = this._mainpanel.getCurrentPhylogeny().copy();
        phylogeny.setAllNodesToNotCollapse();
        phylogeny.recalculateNumberOfExternalDescendants(false);
        GSDIR gSDIR = null;
        Phylogeny phylogeny2 = this.getSpeciesTree().copy();
        try {
            gSDIR = new GSDIR(phylogeny, phylogeny2, true, true, true);
        }
        catch (SDIException sDIException) {
            JOptionPane.showMessageDialog(this, sDIException.getLocalizedMessage(), "Error during GSDIR", 0);
            return;
        }
        catch (Exception exception) {
            AptxUtil.unexpectedException(exception);
            return;
        }
        Phylogeny phylogeny3 = gSDIR.getMinDuplicationsSumGeneTree();
        phylogeny3.setRerootable(false);
        phylogeny3.clearHashIdToNodeMap();
        phylogeny3.recalculateNumberOfExternalDescendants(true);
        PhylogenyMethods.orderAppearance(phylogeny3.getRoot(), true, true, PhylogenyMethods.DESCENDANT_SORT_PRIORITY.NODE_NAME);
        this._mainpanel.addPhylogenyInNewTab(phylogeny3, this.getConfiguration(), "gene tree", null);
        this.getMainPanel().getControlPanel().setShowEvents(true);
        this.showWhole();
        int n2 = this._mainpanel.getTabbedPane().getSelectedIndex();
        this._mainpanel.addPhylogenyInNewTab(phylogeny2, this.getConfiguration(), "species tree", null);
        this.showWhole();
        this._mainpanel.getTabbedPane().setSelectedIndex(n2);
        this.showWhole();
        this._mainpanel.getCurrentTreePanel().setEdited(true);
        int n3 = PhylogenyMethods.countNumberOfPolytomies(phylogeny2);
        if (gSDIR.getStrippedExternalGeneTreeNodes().size() > 0) {
            JOptionPane.showMessageDialog(this, "Minimal duplications: " + gSDIR.getMinDuplicationsSum() + "\nSpeciations: " + gSDIR.getSpeciationsSum() + "\nStripped gene tree nodes: " + gSDIR.getStrippedExternalGeneTreeNodes().size() + "\nTaxonomy linkage based on: " + (Object)((Object)gSDIR.getTaxCompBase()) + "\nNumber of polytomies in species tree used: " + n3 + "\n", "GSDIR successfully completed", 2);
        } else {
            JOptionPane.showMessageDialog(this, "Minimal duplications: " + gSDIR.getMinDuplicationsSum() + "\nSpeciations: " + gSDIR.getSpeciationsSum() + "\nStripped gene tree nodes: " + gSDIR.getStrippedExternalGeneTreeNodes().size() + "\nTaxonomy linkage based on: " + (Object)((Object)gSDIR.getTaxCompBase()) + "\nNumber of polytomies in species tree used: " + n3 + "\n", "GSDIR successfully completed", 1);
        }
    }

    void executeLineageInference() {
        if (this._mainpanel.getCurrentPhylogeny() == null || this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            return;
        }
        if (!this._mainpanel.getCurrentPhylogeny().isRooted()) {
            JOptionPane.showMessageDialog(this, "Phylogeny is not rooted.", "Cannot infer ancestral taxonomies", 0);
            return;
        }
        AncestralTaxonomyInferrer ancestralTaxonomyInferrer = new AncestralTaxonomyInferrer(this, this._mainpanel.getCurrentTreePanel(), this._mainpanel.getCurrentPhylogeny().copy());
        new Thread(ancestralTaxonomyInferrer).start();
    }

    boolean GAndSDoHaveMoreThanOneSpeciesInComman(Phylogeny phylogeny) {
        if (phylogeny == null || phylogeny.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Gene tree and species tree have no species in common.", "Error during SDI", 0);
            return false;
        }
        if (phylogeny.getNumberOfExternalNodes() < 2) {
            JOptionPane.showMessageDialog(this, "Gene tree and species tree have only one species in common.", "Error during SDI", 0);
            return false;
        }
        return true;
    }

    ControlPanel getControlPanel() {
        return this.getMainPanel().getControlPanel();
    }

    File getCurrentDir() {
        if ((this._current_dir == null || !this._current_dir.canRead()) && ForesterUtil.isWindows()) {
            try {
                this._current_dir = new File(WindowsUtils.getCurrentUserDesktopPath());
            }
            catch (Exception exception) {
                this._current_dir = null;
            }
        }
        if (this._current_dir == null || !this._current_dir.canRead()) {
            if (System.getProperty("user.home") != null) {
                this._current_dir = new File(System.getProperty("user.home"));
            } else if (System.getProperty("user.dir") != null) {
                this._current_dir = new File(System.getProperty("user.dir"));
            }
        }
        return this._current_dir;
    }

    TreePanel getCurrentTreePanel() {
        return this.getMainPanel().getCurrentTreePanel();
    }

    JMenu getHelpMenu() {
        return this._help_jmenu;
    }

    JCheckBoxMenuItem getlabelDirectionCbmi() {
        return this._label_direction_cbmi;
    }

    JMenuBar getMenuBarOfMainFrame() {
        return this._jmenubar;
    }

    final Phylogeny getSpeciesTree() {
        return this._species_tree;
    }

    void initializeTypeMenu(Options options) {
        this.setTypeMenuToAllUnselected();
        switch (options.getPhylogenyGraphicsType()) {
            case CONVEX: {
                this._convex_type_cbmi.setSelected(true);
                break;
            }
            case CURVED: {
                this._curved_type_cbmi.setSelected(true);
                break;
            }
            case EURO_STYLE: {
                this._euro_type_cbmi.setSelected(true);
                break;
            }
            case ROUNDED: {
                this._rounded_type_cbmi.setSelected(true);
                break;
            }
            case TRIANGULAR: {
                this._triangular_type_cbmi.setSelected(true);
                break;
            }
            case UNROOTED: {
                this._unrooted_type_cbmi.setSelected(true);
                break;
            }
            case CIRCULAR: {
                this._circular_type_cbmi.setSelected(true);
                break;
            }
            default: {
                this._rectangular_type_cbmi.setSelected(true);
            }
        }
    }

    boolean isOKforSDI(boolean bl, boolean bl2) {
        if (this._mainpanel.getCurrentPhylogeny() == null || this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            return false;
        }
        if (this.getSpeciesTree() == null || this.getSpeciesTree().isEmpty()) {
            JOptionPane.showMessageDialog(this, "No species tree loaded", "Cannot execute GSDI", 0);
            return false;
        }
        if (bl && !this.getSpeciesTree().isCompletelyBinary()) {
            JOptionPane.showMessageDialog(this, "Species tree is not completely binary", "Cannot execute GSDI", 0);
            return false;
        }
        if (bl2 && !this._mainpanel.getCurrentPhylogeny().isCompletelyBinary()) {
            JOptionPane.showMessageDialog(this, "Gene tree is not completely binary", "Cannot execute GSDI", 0);
            return false;
        }
        return true;
    }

    boolean isSubtreeDisplayed() {
        if (this.getCurrentTreePanel() != null && this.getCurrentTreePanel().isCurrentTreeIsSubtree()) {
            JOptionPane.showMessageDialog(this, "This operation can only be performed on a complete tree, not on the currently displayed sub-tree only.", "Operation can not be exectuted on a sub-tree", 2);
            return true;
        }
        return false;
    }

    void midpointRoot() {
        if (this._mainpanel.getCurrentTreePanel() != null) {
            this._mainpanel.getCurrentTreePanel().midpointRoot();
        }
    }

    void readPhylogeniesFromWebservice(int n) {
        UrlTreeReader urlTreeReader = new UrlTreeReader(this, n);
        new Thread(urlTreeReader).start();
    }

    void removeAllTextFrames() {
        for (TextFrame textFrame : this._textframes) {
            if (textFrame == null) continue;
            textFrame.close();
        }
        this._textframes.clear();
    }

    void resetSearch() {
        this.getMainPanel().getCurrentTreePanel().setFoundNodes0(null);
        this.getMainPanel().getCurrentTreePanel().setFoundNodes1(null);
        this.getMainPanel().getControlPanel().setSearchFoundCountsOnLabel0(0);
        this.getMainPanel().getControlPanel().getSearchFoundCountsLabel0().setVisible(false);
        this.getMainPanel().getControlPanel().getSearchTextField0().setText("");
        this.getMainPanel().getControlPanel().getSearchResetButton0().setEnabled(false);
        this.getMainPanel().getControlPanel().getSearchResetButton0().setVisible(false);
        this.getMainPanel().getControlPanel().setSearchFoundCountsOnLabel1(0);
        this.getMainPanel().getControlPanel().getSearchFoundCountsLabel1().setVisible(false);
        this.getMainPanel().getControlPanel().getSearchTextField1().setText("");
        this.getMainPanel().getControlPanel().getSearchResetButton1().setEnabled(false);
        this.getMainPanel().getControlPanel().getSearchResetButton1().setVisible(false);
    }

    void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    void setCurrentDir(File file) {
        this._current_dir = file;
    }

    void setInferenceManager(InferenceManager inferenceManager) {
        this._inference_manager = inferenceManager;
    }

    void setOptions(Options options) {
        this._options = options;
    }

    void setSelectedTypeInTypeMenu(Options.PHYLOGENY_GRAPHICS_TYPE pHYLOGENY_GRAPHICS_TYPE) {
        this.setTypeMenuToAllUnselected();
        switch (pHYLOGENY_GRAPHICS_TYPE) {
            case CIRCULAR: {
                this._circular_type_cbmi.setSelected(true);
                break;
            }
            case CONVEX: {
                this._convex_type_cbmi.setSelected(true);
                break;
            }
            case CURVED: {
                this._curved_type_cbmi.setSelected(true);
                break;
            }
            case EURO_STYLE: {
                this._euro_type_cbmi.setSelected(true);
                break;
            }
            case ROUNDED: {
                this._rounded_type_cbmi.setSelected(true);
                break;
            }
            case RECTANGULAR: {
                this._rectangular_type_cbmi.setSelected(true);
                break;
            }
            case TRIANGULAR: {
                this._triangular_type_cbmi.setSelected(true);
                break;
            }
            case UNROOTED: {
                this._unrooted_type_cbmi.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type: " + (Object)((Object)pHYLOGENY_GRAPHICS_TYPE));
            }
        }
    }

    final void setSpeciesTree(Phylogeny phylogeny) {
        this._species_tree = phylogeny;
    }

    void setTypeMenuToAllUnselected() {
        this._convex_type_cbmi.setSelected(false);
        this._curved_type_cbmi.setSelected(false);
        this._euro_type_cbmi.setSelected(false);
        this._rounded_type_cbmi.setSelected(false);
        this._triangular_type_cbmi.setSelected(false);
        this._rectangular_type_cbmi.setSelected(false);
        this._unrooted_type_cbmi.setSelected(false);
        this._circular_type_cbmi.setSelected(false);
    }

    void switchColors() {
        TreeColorSet treeColorSet = this._mainpanel.getTreeColorSet();
        ColorSchemeChooser colorSchemeChooser = new ColorSchemeChooser(this.getMainPanel(), treeColorSet);
        colorSchemeChooser.setVisible(true);
    }

    void taxColor() {
        if (this._mainpanel.getCurrentTreePanel() != null) {
            this._mainpanel.getCurrentTreePanel().taxColor();
        }
    }

    void typeChanged(Object object) {
        this.updateTypeCheckboxes(this.getOptions(), object);
        this.updateOptions(this.getOptions());
        if (this.getCurrentTreePanel() != null) {
            Options.PHYLOGENY_GRAPHICS_TYPE pHYLOGENY_GRAPHICS_TYPE = this.getCurrentTreePanel().getPhylogenyGraphicsType();
            Options.PHYLOGENY_GRAPHICS_TYPE pHYLOGENY_GRAPHICS_TYPE2 = this.getOptions().getPhylogenyGraphicsType();
            if (pHYLOGENY_GRAPHICS_TYPE == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && pHYLOGENY_GRAPHICS_TYPE2 != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || pHYLOGENY_GRAPHICS_TYPE == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR && pHYLOGENY_GRAPHICS_TYPE2 != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || pHYLOGENY_GRAPHICS_TYPE != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && pHYLOGENY_GRAPHICS_TYPE2 == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || pHYLOGENY_GRAPHICS_TYPE != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR && pHYLOGENY_GRAPHICS_TYPE2 == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.getCurrentTreePanel().getControlPanel().showWhole();
            }
            if (this.getCurrentTreePanel().isPhyHasBranchLengths() && pHYLOGENY_GRAPHICS_TYPE2 != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.getCurrentTreePanel().getControlPanel().setDrawPhylogramEnabled(true);
            } else {
                this.getCurrentTreePanel().getControlPanel().setDrawPhylogramEnabled(false);
            }
            this.getCurrentTreePanel().setPhylogenyGraphicsType(this.getOptions().getPhylogenyGraphicsType());
            MainFrame.updateScreenTextAntialias(this.getMainPanel().getTreePanels());
            if (this.getCurrentTreePanel().getControlPanel().getDynamicallyHideData() != null) {
                if (pHYLOGENY_GRAPHICS_TYPE2 == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
                    this.getCurrentTreePanel().getControlPanel().getDynamicallyHideData().setEnabled(false);
                } else {
                    this.getCurrentTreePanel().getControlPanel().getDynamicallyHideData().setEnabled(true);
                }
            }
        }
    }

    void updateOptions(Options options) {
        options.setAntialiasScreen(this._screen_antialias_cbmi != null && this._screen_antialias_cbmi.isSelected());
        options.setBackgroundColorGradient(this._background_gradient_cbmi != null && this._background_gradient_cbmi.isSelected());
        options.setShowDomainLabels(this._show_domain_labels != null && this._show_domain_labels.isSelected());
        options.setShowAnnotationRefSource(this._show_annotation_ref_source != null && this._show_annotation_ref_source.isSelected());
        options.setAbbreviateScientificTaxonNames(this._abbreviate_scientific_names != null && this._abbreviate_scientific_names.isSelected());
        options.setColorLabelsSameAsParentBranch(this._color_labels_same_as_parent_branch != null && this._color_labels_same_as_parent_branch.isSelected());
        options.setShowDefaultNodeShapesInternal(this._show_default_node_shapes_internal_cbmi != null && this._show_default_node_shapes_internal_cbmi.isSelected());
        options.setShowDefaultNodeShapesExternal(this._show_default_node_shapes_external_cbmi != null && this._show_default_node_shapes_external_cbmi.isSelected());
        options.setShowDefaultNodeShapesForMarkedNodes(this._show_default_node_shapes_for_marked_cbmi != null && this._show_default_node_shapes_for_marked_cbmi.isSelected());
        if (this._non_lined_up_cladograms_rbmi != null && this._non_lined_up_cladograms_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.NON_LINED_UP);
        } else if (this._ext_node_dependent_cladogram_rbmi != null && this._ext_node_dependent_cladogram_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.LINED_UP);
        }
        options.setSearchCaseSensitive(this._search_case_senstive_cbmi != null && this._search_case_senstive_cbmi.isSelected());
        if (this._show_scale_cbmi != null && this._show_scale_cbmi.isEnabled()) {
            options.setShowScale(this._show_scale_cbmi.isSelected());
        }
        if (this._label_direction_cbmi != null) {
            if (this._label_direction_cbmi.isSelected()) {
                options.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.RADIAL);
            } else {
                options.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
            }
        }
        options.setShowOverview(this._show_overview_cbmi != null && this._show_overview_cbmi.isSelected());
        options.setShowConfidenceStddev(this._show_confidence_stddev_cbmi != null && this._show_confidence_stddev_cbmi.isSelected());
        if (this._color_by_taxonomic_group_cbmi != null && this._color_by_taxonomic_group_cbmi.isEnabled()) {
            options.setColorByTaxonomicGroup(this._color_by_taxonomic_group_cbmi.isSelected());
        }
        options.setAntialiasPrint(this._antialias_print_cbmi != null && this._antialias_print_cbmi.isSelected());
        if (this._use_brackets_for_conf_in_nh_export_cbmi != null && this._use_brackets_for_conf_in_nh_export_cbmi.isSelected()) {
            options.setNhConversionSupportValueStyle(PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE.IN_SQUARE_BRACKETS);
        } else if (this._use_internal_names_for_conf_in_nh_export_cbmi != null && this._use_internal_names_for_conf_in_nh_export_cbmi.isSelected()) {
            options.setNhConversionSupportValueStyle(PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE.AS_INTERNAL_NODE_NAMES);
        } else {
            options.setNhConversionSupportValueStyle(PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE.NONE);
        }
        options.setPrintBlackAndWhite(this._print_black_and_white_cbmi != null && this._print_black_and_white_cbmi.isSelected());
        options.setInternalNumberAreConfidenceForNhParsing(this._internal_number_are_confidence_for_nh_parsing_cbmi != null && this._internal_number_are_confidence_for_nh_parsing_cbmi.isSelected());
        if (this._extract_taxonomy_pfam_strict_rbmi != null && this._extract_taxonomy_pfam_strict_rbmi.isSelected()) {
            options.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_STRICT);
        } else if (this._extract_taxonomy_pfam_relaxed_rbmi != null && this._extract_taxonomy_pfam_relaxed_rbmi.isSelected()) {
            options.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_RELAXED);
        } else if (this._extract_taxonomy_agressive_rbmi != null && this._extract_taxonomy_agressive_rbmi.isSelected()) {
            options.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
        } else if (this._extract_taxonomy_no_rbmi != null && this._extract_taxonomy_no_rbmi.isSelected()) {
            options.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.NO);
        }
        options.setReplaceUnderscoresInNhParsing(this._replace_underscores_cbmi != null && this._replace_underscores_cbmi.isSelected());
        options.setAllowErrorsInDistanceToParent(this._allow_errors_in_distance_to_parent_cbmi != null && this._allow_errors_in_distance_to_parent_cbmi.isSelected());
        options.setMatchWholeTermsOnly(this._search_whole_words_only_cbmi != null && this._search_whole_words_only_cbmi.isSelected());
        options.setSearchWithRegex(this._search_with_regex_cbmi != null && this._search_with_regex_cbmi.isSelected());
        options.setInverseSearchResult(this._inverse_search_result_cbmi != null && this._inverse_search_result_cbmi.isSelected());
        if (this._graphics_export_visible_only_cbmi != null) {
            options.setGraphicsExportVisibleOnly(this._graphics_export_visible_only_cbmi.isSelected());
        }
        if (this._rectangular_type_cbmi != null && this._rectangular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        } else if (this._triangular_type_cbmi != null && this._triangular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
        } else if (this._curved_type_cbmi != null && this._curved_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
        } else if (this._convex_type_cbmi != null && this._convex_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
        } else if (this._euro_type_cbmi != null && this._euro_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
        } else if (this._rounded_type_cbmi != null && this._rounded_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
        } else if (this._unrooted_type_cbmi != null && this._unrooted_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
        } else if (this._circular_type_cbmi != null && this._circular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
        }
        if (this._right_line_up_domains_cbmi != null && this._right_line_up_domains_cbmi.isEnabled()) {
            options.setRightLineUpDomains(this._right_line_up_domains_cbmi.isSelected());
        }
        if (this._line_up_renderable_data_cbmi != null && this._line_up_renderable_data_cbmi.isEnabled()) {
            options.setLineUpRendarableNodeData(this._line_up_renderable_data_cbmi.isSelected());
        }
        if (this._color_all_found_nodes_when_coloring_subtree_cbmi != null && this._color_all_found_nodes_when_coloring_subtree_cbmi.isEnabled()) {
            options.setColorAllFoundNodesWhenColoringSubtree(this._color_all_found_nodes_when_coloring_subtree_cbmi.isSelected());
        }
        if (this._parse_beast_style_extended_nexus_tags_cbmi != null && this._parse_beast_style_extended_nexus_tags_cbmi.isEnabled()) {
            options.setParseBeastStyleExtendedNexusTags(this._parse_beast_style_extended_nexus_tags_cbmi.isSelected());
        }
        if (this._collapsed_with_average_height_cbmi != null && this._collapsed_with_average_height_cbmi.isEnabled()) {
            options.setCollapsedWithAverageHeigh(this._collapsed_with_average_height_cbmi.isSelected());
        }
        if (this._show_abbreviated_labels_for_collapsed_nodes_cbmi != null && this._show_abbreviated_labels_for_collapsed_nodes_cbmi.isEnabled()) {
            options.setShowAbbreviatedLabelsForCollapsedNodes(this._show_abbreviated_labels_for_collapsed_nodes_cbmi.isSelected());
        }
    }

    void updateTypeCheckboxes(Options options, Object object) {
        this.setTypeMenuToAllUnselected();
        ((JCheckBoxMenuItem)object).setSelected(true);
    }

    void viewAsNexus() {
        if (this._mainpanel.getCurrentPhylogeny() != null && !this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            String string = "Nexus";
            if (!ForesterUtil.isEmpty(this._mainpanel.getCurrentPhylogeny().getName())) {
                string = "\"" + this.getMainPanel().getCurrentPhylogeny().getName() + "\" in " + string;
            }
            this.showTextFrame(this._mainpanel.getCurrentPhylogeny().toNexus(this.getOptions().getNhConversionSupportValueStyle()), string);
        }
    }

    void viewAsNH() {
        if (this._mainpanel.getCurrentPhylogeny() != null && !this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            String string = "New Hampshire";
            if (!ForesterUtil.isEmpty(this._mainpanel.getCurrentPhylogeny().getName())) {
                string = "\"" + this.getMainPanel().getCurrentPhylogeny().getName() + "\" in " + string;
            }
            this.showTextFrame(this._mainpanel.getCurrentPhylogeny().toNewHampshire(this.getOptions().getNhConversionSupportValueStyle()), string);
        }
    }

    void viewAsXML() {
        if (this._mainpanel.getCurrentPhylogeny() != null && !this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            String string = "phyloXML";
            if (!ForesterUtil.isEmpty(this._mainpanel.getCurrentPhylogeny().getName())) {
                string = "\"" + this.getMainPanel().getCurrentPhylogeny().getName() + "\" in " + string;
            }
            this.showTextFrame(this._mainpanel.getCurrentPhylogeny().toPhyloXML(0), string);
        }
    }

    private static void cycleNodeDataReturn(Options options, Configuration configuration) {
        switch (options.getExtDescNodeDataToReturn()) {
            case UNKNOWN: {
                options.setExtDescNodeDataToReturn(NodeDataField.DOMAINS_ALL);
                break;
            }
            case DOMAINS_ALL: {
                options.setExtDescNodeDataToReturn(NodeDataField.DOMAINS_COLLAPSED_PER_PROTEIN);
                break;
            }
            case DOMAINS_COLLAPSED_PER_PROTEIN: {
                options.setExtDescNodeDataToReturn(NodeDataField.SEQ_ANNOTATIONS);
                break;
            }
            case SEQ_ANNOTATIONS: {
                options.setExtDescNodeDataToReturn(NodeDataField.GO_TERM_IDS);
                break;
            }
            case GO_TERM_IDS: {
                options.setExtDescNodeDataToReturn(NodeDataField.SEQUENCE_MOL_SEQ_FASTA);
                break;
            }
            case SEQUENCE_MOL_SEQ_FASTA: {
                if (configuration != null && configuration.getExtDescNodeDataToReturn() != null && configuration.getExtDescNodeDataToReturn() != NodeDataField.DOMAINS_ALL && configuration.getExtDescNodeDataToReturn() != NodeDataField.DOMAINS_COLLAPSED_PER_PROTEIN && configuration.getExtDescNodeDataToReturn() != NodeDataField.SEQ_ANNOTATIONS && configuration.getExtDescNodeDataToReturn() != NodeDataField.GO_TERM_IDS && configuration.getExtDescNodeDataToReturn() != NodeDataField.SEQUENCE_MOL_SEQ_FASTA) {
                    options.setExtDescNodeDataToReturn(configuration.getExtDescNodeDataToReturn());
                    break;
                }
                options.setExtDescNodeDataToReturn(NodeDataField.UNKNOWN);
                break;
            }
            default: {
                options.setExtDescNodeDataToReturn(NodeDataField.UNKNOWN);
            }
        }
    }

    void about() {
        StringBuffer stringBuffer = new StringBuffer("Archaeopteryx\nVersion 0.9928 beta\n");
        stringBuffer.append("Copyright (C) 2018 Christian M Zmasek\n");
        stringBuffer.append("All Rights Reserved\n");
        stringBuffer.append("License: GNU Lesser General Public License (LGPL)\n");
        stringBuffer.append("Last modified: 180705\n");
        stringBuffer.append("Based on: " + ForesterUtil.getForesterLibraryInformation() + "\n");
        if (this._configuration.isCouldReadConfigFile()) {
            stringBuffer.append("Using configuration file: " + this._configuration.config_filename + "\n");
        } else {
            stringBuffer.append("Not using a configuration file\n");
        }
        stringBuffer.append("phyloXML version : 1.20\n");
        stringBuffer.append("phyloXML location: http://www.phyloxml.org\n");
        if (!ForesterUtil.isEmpty(ForesterUtil.JAVA_VERSION) && !ForesterUtil.isEmpty(ForesterUtil.JAVA_VENDOR)) {
            stringBuffer.append("[your Java version: " + ForesterUtil.JAVA_VERSION + " " + ForesterUtil.JAVA_VENDOR + "]\n");
        }
        if (!(ForesterUtil.isEmpty(ForesterUtil.OS_NAME) || ForesterUtil.isEmpty(ForesterUtil.OS_ARCH) || ForesterUtil.isEmpty(ForesterUtil.OS_VERSION))) {
            stringBuffer.append("[your OS: " + ForesterUtil.OS_NAME + " " + ForesterUtil.OS_ARCH + " " + ForesterUtil.OS_VERSION + "]\n");
        }
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory() / 1000000L;
        long l2 = runtime.totalMemory() / 1000000L;
        stringBuffer.append("[free memory: " + l + "MB, total memory: " + l2 + "MB]\n");
        stringBuffer.append("[locale: " + Locale.getDefault() + "]\n");
        stringBuffer.append("References:\n");
        stringBuffer.append("Han MV and Zmasek CM (2009), BMC Bioinformatics, 10:356\n");
        stringBuffer.append("For more information & download:\n");
        stringBuffer.append("https://sites.google.com/site/cmzmasek/home/software/archaeopteryx\n");
        stringBuffer.append("Documentation:\n");
        stringBuffer.append("https://sites.google.com/site/cmzmasek/home/software/archaeopteryx/documentation\n");
        stringBuffer.append("Comments: phyloxml@gmail.com");
        JOptionPane.showMessageDialog(null, stringBuffer, "Archaeopteryx", -1);
    }

    static void chooseNodeSize(Options options, Component component) {
        String string = (String)JOptionPane.showInputDialog(component, "Please enter the default size for node shapes.\n[current value: " + options.getDefaultNodeShapeSize() + "]\n", "Node Shape Size", 3, null, null, options.getDefaultNodeShapeSize());
        if (!ForesterUtil.isEmpty(string)) {
            short s;
            boolean bl = true;
            double d = 0.0;
            String string2 = string.trim();
            if (!ForesterUtil.isEmpty(string2)) {
                try {
                    d = Double.parseDouble(string2);
                }
                catch (Exception exception) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl && d >= 0.0 && (double)(s = ForesterUtil.roundToShort(d)) >= 0.0) {
                options.setDefaultNodeShapeSize(s);
            }
        }
    }

    static String createCurrentFontDesc(TreeFontSet treeFontSet) {
        return treeFontSet.getLargeFont().getFamily() + " " + treeFontSet.getLargeFont().getSize();
    }

    static JMenu createMenu(String string, Configuration configuration) {
        JMenu jMenu = new JMenu(string);
        if (!configuration.isUseNativeUI()) {
            jMenu.setFont(menu_font);
            jMenu.setBackground(configuration.getGuiMenuBackgroundColor());
            jMenu.setForeground(configuration.getGuiMenuTextColor());
        }
        return jMenu;
    }

    static JMenuItem customizeMenuItemAsLabel(JMenuItem jMenuItem, Configuration configuration) {
        jMenuItem.setFont(menu_font.deriveFont(1));
        if (!configuration.isUseNativeUI()) {
            jMenuItem.setBackground(configuration.getGuiMenuBackgroundColor());
            jMenuItem.setForeground(configuration.getGuiMenuTextColor());
            jMenuItem.setOpaque(true);
        }
        jMenuItem.setSelected(false);
        jMenuItem.setEnabled(false);
        return jMenuItem;
    }

    static void cycleNodeFill(Options options) {
        switch (options.getDefaultNodeFill()) {
            case GRADIENT: {
                options.setDefaultNodeFill(NodeVisualData.NodeFill.SOLID);
                break;
            }
            case NONE: {
                options.setDefaultNodeFill(NodeVisualData.NodeFill.GRADIENT);
                break;
            }
            case SOLID: {
                options.setDefaultNodeFill(NodeVisualData.NodeFill.NONE);
                break;
            }
            default: {
                throw new RuntimeException("unknown fill: " + (Object)((Object)options.getDefaultNodeFill()));
            }
        }
    }

    static void cycleNodeShape(Options options) {
        switch (options.getDefaultNodeShape()) {
            case CIRCLE: {
                options.setDefaultNodeShape(NodeVisualData.NodeShape.RECTANGLE);
                break;
            }
            case RECTANGLE: {
                options.setDefaultNodeShape(NodeVisualData.NodeShape.CIRCLE);
                break;
            }
            default: {
                throw new RuntimeException("unknown shape: " + (Object)((Object)options.getDefaultNodeShape()));
            }
        }
    }

    static void cycleOverview(Options options, TreePanel treePanel) {
        switch (options.getOvPlacement()) {
            case LOWER_LEFT: {
                options.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT);
                break;
            }
            case LOWER_RIGHT: {
                options.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_LEFT);
                break;
            }
            case UPPER_LEFT: {
                options.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_RIGHT);
                break;
            }
            case UPPER_RIGHT: {
                options.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_RIGHT);
                break;
            }
            default: {
                throw new RuntimeException("unknown placement: " + (Object)((Object)options.getOvPlacement()));
            }
        }
        if (treePanel != null) {
            treePanel.updateOvSettings();
        }
    }

    static void exceptionOccuredDuringSaveAs(Exception exception, TreePanel treePanel, Component component) {
        try {
            treePanel.setArrowCursor();
        }
        catch (Exception exception2) {
            // empty catch block
        }
        JOptionPane.showMessageDialog(component, "Exception" + exception, "Error during File|SaveAs", 0);
    }

    static void print(TreePanel treePanel, Options options, Component component) {
        if (treePanel == null || treePanel.getPhylogeny() == null || treePanel.getPhylogeny().isEmpty()) {
            return;
        }
        boolean bl = false;
        String string = null;
        try {
            string = Printer.print(treePanel, "Archaeopteryx");
        }
        catch (Exception exception) {
            bl = true;
            JOptionPane.showMessageDialog(component, exception.getMessage(), "Printing Error", 0);
        }
        if (!bl && string != null) {
            String string2 = "Printing data sent to printer";
            if (string.length() > 1) {
                string2 = string2 + " [" + string + "]";
            }
            JOptionPane.showMessageDialog(component, string2, "Printing...", 1);
        }
        if (!options.isPrintUsingActualSize()) {
            treePanel.getControlPanel().showWhole();
        }
    }

    static void printPhylogenyToPdf(String string, Options options, TreePanel treePanel, Component component) {
        String string2 = "";
        boolean bl = false;
        try {
            if (options.isPrintUsingActualSize()) {
                string2 = PdfExporter.writePhylogenyToPdf(string, treePanel, treePanel.getWidth(), treePanel.getHeight());
            }
        }
        catch (IOException iOException) {
            bl = true;
            JOptionPane.showMessageDialog(component, iOException.getMessage(), "Error", 0);
        }
        if (!bl) {
            if (!ForesterUtil.isEmpty(string2)) {
                JOptionPane.showMessageDialog(component, "Wrote PDF to: " + string2, "Information", 1);
            } else {
                JOptionPane.showMessageDialog(component, "There was an unknown problem when attempting to write to PDF file: \"" + string + "\"", "Error", 0);
            }
        }
        if (!options.isPrintUsingActualSize()) {
            treePanel.getControlPanel().showWhole();
        }
    }

    static void setCycleDataReturnMenuItem(JMenuItem jMenuItem, Options options) {
        if (options != null && options.getExtDescNodeDataToReturn() != null) {
            jMenuItem.setText("Cycle Node Return Data... (current: " + options.getExtDescNodeDataToReturn().toString() + ")");
        } else {
            jMenuItem.setText("Cycle Node Return Data...");
        }
    }

    static void setCycleNodeFillMenuItem(JMenuItem jMenuItem, Options options) {
        if (options != null && options.getDefaultNodeFill() != null) {
            jMenuItem.setText("Cycle Node Shape Fill Type... (current: " + options.getDefaultNodeFill().toString().toLowerCase() + ")");
        } else {
            jMenuItem.setText("Cycle Node Shape Fill Type...");
        }
    }

    static void setCycleNodeShapeMenuItem(JMenuItem jMenuItem, Options options) {
        if (options != null && options.getDefaultNodeShape() != null) {
            jMenuItem.setText("Cycle Node Shape Fill Type... (current: " + options.getDefaultNodeShape().toString().toLowerCase() + ")");
        } else {
            jMenuItem.setText("Cycle Node Shape Fill Type...");
        }
    }

    static void setOvPlacementColorChooseMenuItem(JMenuItem jMenuItem, Options options) {
        if (options != null && options.getOvPlacement() != null) {
            jMenuItem.setText("Cycle Overview Placement... (current: " + (Object)((Object)options.getOvPlacement()) + ")");
        } else {
            jMenuItem.setText("Cycle Overview Placement...");
        }
    }

    static void setTextColorChooseMenuItem(JMenuItem jMenuItem, TreePanel treePanel) {
        if (treePanel != null && treePanel.getTreeColorSet() != null) {
            jMenuItem.setText("Select Color Scheme... (current: " + treePanel.getTreeColorSet().getCurrentColorSchemeName() + ")");
        } else {
            jMenuItem.setText("Select Color Scheme...");
        }
    }

    static void setTextForFontChooserMenuItem(JMenuItem jMenuItem, String string) {
        jMenuItem.setText("Select Default Font... (current: " + string + ")");
    }

    static void setTextForPdfLineWidthChooserMenuItem(JMenuItem jMenuItem, Options options) {
        jMenuItem.setText("Enter Default Line Width for PDF Export... (current: " + options.getPrintLineWidth() + ")");
    }

    static void setTextMinSupportMenuItem(JMenuItem jMenuItem, Options options, TreePanel treePanel) {
        if (treePanel == null || treePanel.getPhylogeny() == null) {
            jMenuItem.setEnabled(true);
        } else if (AptxUtil.isHasAtLeastOneBranchWithSupportValues(treePanel.getPhylogeny())) {
            jMenuItem.setEnabled(true);
        } else {
            jMenuItem.setEnabled(false);
        }
        jMenuItem.setText("Enter Min Confidence Value... (current: " + options.getMinConfidenceValue() + ")");
    }

    static void setTextNodeSizeMenuItem(JMenuItem jMenuItem, Options options) {
        jMenuItem.setText("Enter Default Node Shape Size... (current: " + options.getDefaultNodeShapeSize() + ")");
    }

    static void updateScreenTextAntialias(List<TreePanel> list) {
        for (TreePanel treePanel : list) {
            treePanel.setTextAntialias();
        }
    }

    static boolean writeAsNewHampshire(TreePanel treePanel, Options options, boolean bl, File file) {
        try {
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            phylogenyWriter.toNewHampshire(treePanel.getPhylogeny(), true, options.getNhConversionSupportValueStyle(), file);
        }
        catch (Exception exception) {
            bl = true;
            MainFrame.exceptionOccuredDuringSaveAs(exception, treePanel, treePanel);
        }
        return bl;
    }

    static boolean writeAsNexus(TreePanel treePanel, Options options, boolean bl, File file) {
        try {
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            phylogenyWriter.toNexus(file, treePanel.getPhylogeny(), options.getNhConversionSupportValueStyle());
        }
        catch (Exception exception) {
            bl = true;
            MainFrame.exceptionOccuredDuringSaveAs(exception, treePanel, treePanel);
        }
        return bl;
    }

    static boolean writeAsPhyloXml(TreePanel treePanel, Options options, boolean bl, File file) {
        try {
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            phylogenyWriter.toPhyloXML(file, treePanel.getPhylogeny(), 0);
        }
        catch (Exception exception) {
            bl = true;
            MainFrame.exceptionOccuredDuringSaveAs(exception, treePanel, treePanel);
        }
        return bl;
    }

    static void writePhylogenyToGraphicsFile(String string, AptxUtil.GraphicsExportType graphicsExportType, MainPanel mainPanel, Component component, Container container) {
        mainPanel.getCurrentTreePanel().calcParametersForPainting(mainPanel.getCurrentTreePanel().getWidth(), mainPanel.getCurrentTreePanel().getHeight());
        String string2 = "";
        boolean bl = false;
        try {
            string2 = AptxUtil.writePhylogenyToGraphicsFile(string, mainPanel.getCurrentTreePanel().getWidth(), mainPanel.getCurrentTreePanel().getHeight(), mainPanel.getCurrentTreePanel(), mainPanel.getControlPanel(), graphicsExportType, mainPanel.getOptions());
        }
        catch (IOException iOException) {
            bl = true;
            JOptionPane.showMessageDialog(component, iOException.getMessage(), "Error", 0);
        }
        if (!bl) {
            if (string2 != null && string2.length() > 0) {
                JOptionPane.showMessageDialog(component, "Wrote image to: " + string2, "Graphics Export", 1);
            } else {
                JOptionPane.showMessageDialog(component, "There was an unknown problem when attempting to write to an image file: \"" + string + "\"", "Error", 0);
            }
        }
        container.repaint();
    }

    static File writeToFile(Phylogeny phylogeny, MainPanel mainPanel, JFileChooser jFileChooser, File file, Container container, Component component) {
        File file2 = null;
        if (phylogeny == null) {
            return null;
        }
        String string = null;
        if (mainPanel.getCurrentTreePanel().getTreeFile() != null) {
            try {
                string = mainPanel.getCurrentTreePanel().getTreeFile().getCanonicalPath();
            }
            catch (IOException iOException) {
                string = null;
            }
        }
        if (!ForesterUtil.isEmpty(string)) {
            jFileChooser.setSelectedFile(new File(string));
        } else {
            jFileChooser.setSelectedFile(new File(""));
        }
        File file3 = file;
        if (file3 != null) {
            jFileChooser.setCurrentDirectory(file3);
        }
        int n = jFileChooser.showSaveDialog(container);
        File file4 = jFileChooser.getSelectedFile();
        file2 = jFileChooser.getCurrentDirectory();
        boolean bl = false;
        if (file4 != null && n == 0) {
            String string2;
            if (file4.exists()) {
                int n2 = JOptionPane.showConfirmDialog(component, file4 + " already exists.\nOverwrite?", "Overwrite?", 2, 3);
                if (n2 != 0) {
                    return null;
                }
                File file5 = new File(file4.getAbsoluteFile().toString() + ".BAK");
                try {
                    ForesterUtil.copyFile(file4, file5);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(component, "Failed to create backup copy " + file5, "Failed to Create Backup Copy", 2);
                }
                try {
                    file4.delete();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(component, "Failed to delete: " + file4, "Failed to Delete", 2);
                }
            }
            if (!(bl = jFileChooser.getFileFilter() == nhfilter ? MainFrame.writeAsNewHampshire(mainPanel.getCurrentTreePanel(), mainPanel.getOptions(), bl, file4) : (jFileChooser.getFileFilter() == xmlfilter ? MainFrame.writeAsPhyloXml(mainPanel.getCurrentTreePanel(), mainPanel.getOptions(), bl, file4) : (jFileChooser.getFileFilter() == nexusfilter ? MainFrame.writeAsNexus(mainPanel.getCurrentTreePanel(), mainPanel.getOptions(), bl, file4) : ((string2 = file4.getName().trim().toLowerCase()).endsWith(".nh") || string2.endsWith(".newick") || string2.endsWith(".phy") || string2.endsWith(".tree") ? MainFrame.writeAsNewHampshire(mainPanel.getCurrentTreePanel(), mainPanel.getOptions(), bl, file4) : (string2.endsWith(".nex") || string2.endsWith(".nexus") ? MainFrame.writeAsNexus(mainPanel.getCurrentTreePanel(), mainPanel.getOptions(), bl, file4) : MainFrame.writeAsPhyloXml(mainPanel.getCurrentTreePanel(), mainPanel.getOptions(), bl, file4))))))) {
                mainPanel.setTitleOfSelectedTab(file4.getName());
                mainPanel.getCurrentTreePanel().setTreeFile(file4);
                mainPanel.getCurrentTreePanel().setEdited(false);
            }
        }
        return file2;
    }

    static File writeToGraphicsFile(Phylogeny phylogeny, AptxUtil.GraphicsExportType graphicsExportType, MainPanel mainPanel, JFileChooser jFileChooser, Component component, Container container, File file) {
        File file2 = null;
        if (phylogeny == null || phylogeny.isEmpty()) {
            return null;
        }
        String string = "";
        if (mainPanel.getCurrentTreePanel().getTreeFile() != null) {
            string = mainPanel.getCurrentTreePanel().getTreeFile().toString();
        }
        if (string.indexOf(46) > 0) {
            string = string.substring(0, string.lastIndexOf(46));
        }
        string = string + "." + (Object)((Object)graphicsExportType);
        jFileChooser.setSelectedFile(new File(string));
        File file3 = file;
        if (file3 != null) {
            jFileChooser.setCurrentDirectory(file3);
        }
        int n = jFileChooser.showSaveDialog(container);
        File file4 = jFileChooser.getSelectedFile();
        file2 = jFileChooser.getCurrentDirectory();
        if (file4 != null && n == 0) {
            if (!file4.toString().toLowerCase().endsWith(graphicsExportType.toString())) {
                file4 = new File(file4.toString() + "." + (Object)((Object)graphicsExportType));
            }
            if (file4.exists()) {
                int n2 = JOptionPane.showConfirmDialog(component, file4 + " already exists. Overwrite?", "Warning", 2, 2);
                if (n2 != 0) {
                    return null;
                }
                try {
                    file4.delete();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(component, "Failed to delete: " + file4, "Error", 2);
                }
            }
            MainFrame.writePhylogenyToGraphicsFile(file4.toString(), graphicsExportType, mainPanel, component, container);
        }
        return file2;
    }

    static File writeToPdf(Phylogeny phylogeny, MainPanel mainPanel, JFileChooser jFileChooser, File file, Container container, Component component) {
        if (phylogeny == null || phylogeny.isEmpty()) {
            return null;
        }
        String string = "";
        if (mainPanel.getCurrentTreePanel().getTreeFile() != null) {
            string = mainPanel.getCurrentTreePanel().getTreeFile().toString();
        }
        if (string.indexOf(46) > 0) {
            string = string.substring(0, string.lastIndexOf(46));
        }
        string = string + ".pdf";
        jFileChooser.setSelectedFile(new File(string));
        File file2 = file;
        if (file2 != null) {
            jFileChooser.setCurrentDirectory(file2);
        }
        int n = jFileChooser.showSaveDialog(container);
        File file3 = jFileChooser.getSelectedFile();
        File file4 = jFileChooser.getCurrentDirectory();
        if (file3 != null && n == 0) {
            int n2;
            if (!file3.toString().toLowerCase().endsWith(".pdf")) {
                file3 = new File(file3.toString() + ".pdf");
            }
            if (file3.exists() && (n2 = JOptionPane.showConfirmDialog(component, file3 + " already exists. Overwrite?", "WARNING", 2, 2)) != 0) {
                return null;
            }
            MainFrame.printPhylogenyToPdf(file3.toString(), mainPanel.getOptions(), mainPanel.getCurrentTreePanel(), component);
        }
        return file4;
    }
}

