/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;

public class BoundedPriorityQueue<E>
extends PriorityQueue<E> {
    private static final long serialVersionUID = 9150330156289560252L;
    private int maxCapacity;
    private boolean removeFromFront;

    public BoundedPriorityQueue(int maxCapacityVal, Comparator<E> c, boolean removeFromFrontVal) {
        super(maxCapacityVal + 1, c);
        this.maxCapacity = maxCapacityVal;
        this.removeFromFront = removeFromFrontVal;
    }

    public BoundedPriorityQueue(int maxCapacityVal, Comparator<E> c) {
        this(maxCapacityVal, c, false);
    }

    public BoundedPriorityQueue(int maxCapacityVal, boolean removeFromFrontVal) {
        super(maxCapacityVal);
        this.maxCapacity = maxCapacityVal;
        this.removeFromFront = removeFromFrontVal;
    }

    public BoundedPriorityQueue(int maxCapacityVal) {
        this(maxCapacityVal, false);
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public boolean isRemoveFromFrontSize() {
        return this.removeFromFront;
    }

    public void setRemoveFromFrontSize(boolean removeFromFrontVal) {
        this.removeFromFront = removeFromFrontVal;
    }

    @Override
    public boolean add(E e) {
        boolean result = super.add(e);
        this.ensureSize();
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = super.addAll(c);
        this.ensureSize();
        return result;
    }

    @Override
    public boolean offer(E e) {
        boolean result = super.offer(e);
        this.ensureSize();
        return result;
    }

    public synchronized List<E> reversedList(boolean destructive) {
        int queueSize = this.size();
        LinkedList reverse = new LinkedList();
        for (int i = 0; i < queueSize; ++i) {
            Object current = this.poll();
            reverse.addFirst(current);
        }
        if (!destructive) {
            this.addAll(reverse);
        }
        return reverse;
    }

    private synchronized void ensureSize() {
        int size = this.size();
        if (size <= this.maxCapacity) {
            return;
        }
        if (this.removeFromFront) {
            for (int i = 0; i < size - this.maxCapacity; ++i) {
                this.poll();
            }
        } else {
            ArrayList transferQueue = new ArrayList(this.maxCapacity);
            for (int i = 0; i < this.maxCapacity; ++i) {
                transferQueue.add(this.poll());
            }
            this.clear();
            super.addAll(transferQueue);
        }
    }
}

