/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.counts;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.campagnelab.goby.counts.CountBinningAdapterI;
import org.campagnelab.goby.counts.CountsReaderI;

public class CountAdaptiveBinningAdaptor
implements CountBinningAdapterI {
    final CountsReaderI delegate;
    int position = -1;
    int length;
    double average;
    int max;
    long sumBasesOverBin;
    private boolean binLoaded;
    private int nextCount;
    private int nextLength;
    private int nextPosition;
    private boolean haveCachedNextTransition;
    boolean previousCountWasZero = true;

    public CountAdaptiveBinningAdaptor(CountsReaderI delegate) {
        this.delegate = delegate;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean hasNextTransition() throws IOException {
        if (this.binLoaded) {
            return true;
        }
        if (!this.haveCachedNextTransition && !this.delegate.hasNextTransition()) {
            return false;
        }
        this.length = 0;
        this.sumBasesOverBin = 0L;
        this.max = 0;
        this.position = Integer.MAX_VALUE;
        boolean binCompleted = false;
        if (this.haveCachedNextTransition) {
            this.length = this.nextLength;
            this.sumBasesOverBin = (long)this.nextCount * (long)this.nextLength;
            this.max = this.nextCount;
            this.haveCachedNextTransition = false;
            this.position = Math.min(this.nextPosition, this.position);
            boolean bl = this.previousCountWasZero = this.nextCount == 0;
        }
        while (this.delegate.hasNextTransition() && !binCompleted) {
            this.delegate.nextTransition();
            int delegateLength = this.delegate.getLength();
            int count = this.delegate.getCount();
            if (count == 0 && this.previousCountWasZero || count != 0 && !this.previousCountWasZero) {
                this.length += delegateLength;
                this.sumBasesOverBin += (long)count * (long)delegateLength;
                this.max = Math.max(count, this.max);
                this.position = Math.min(this.delegate.getPosition(), this.position);
                this.previousCountWasZero = count == 0;
                continue;
            }
            binCompleted = true;
            this.nextCount = count;
            this.nextLength = delegateLength;
            this.nextPosition = this.delegate.getPosition();
            this.haveCachedNextTransition = true;
        }
        this.average = (double)this.sumBasesOverBin / (double)this.length;
        this.binLoaded = true;
        return true;
    }

    @Override
    public void nextTransition() throws IOException {
        if (!this.hasNextTransition()) {
            throw new NoSuchElementException("No such element.");
        }
        this.binLoaded = false;
    }

    @Override
    public int getCount() {
        return (int)this.average;
    }

    @Override
    public double getAverage() {
        return this.average;
    }

    @Override
    public void skipTo(int position) throws IOException {
        this.delegate.skipTo(position);
        this.resetStateAtNewPosition();
    }

    @Override
    public void reposition(int position) throws IOException {
        this.delegate.reposition(position);
        this.resetStateAtNewPosition();
    }

    private void resetStateAtNewPosition() {
        this.position = this.delegate.getPosition() - 1;
        this.length = 0;
        this.sumBasesOverBin = 0L;
        this.max = 0;
        this.average = 0.0;
        this.haveCachedNextTransition = false;
        int count = this.delegate.getCount();
        this.previousCountWasZero = true;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getMax() {
        return this.max;
    }
}

