/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.baseinfo;

import edu.cornell.med.icb.util.VersionUtils;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.campagnelab.dl.varanalysis.protobuf.BaseInformationRecords;
import org.campagnelab.goby.baseinfo.BasenameUtils;
import org.campagnelab.goby.baseinfo.CommitPropertiesStatAccumulator;
import org.campagnelab.goby.baseinfo.ConstantAccumulator;
import org.campagnelab.goby.baseinfo.StatAccumulator;
import org.campagnelab.goby.baseinfo.StatAccumulatorBaseQuality;
import org.campagnelab.goby.baseinfo.StatAccumulatorDistanceToEndOfRead;
import org.campagnelab.goby.baseinfo.StatAccumulatorDistanceToStartOfRead;
import org.campagnelab.goby.baseinfo.StatAccumulatorDistancesToReadVariations;
import org.campagnelab.goby.baseinfo.StatAccumulatorInsertSizes;
import org.campagnelab.goby.baseinfo.StatAccumulatorNumVariationsInRead;
import org.campagnelab.goby.baseinfo.StatAccumulatorPairFlags;
import org.campagnelab.goby.baseinfo.StatAccumulatorQueryAlignedLength;
import org.campagnelab.goby.baseinfo.StatAccumulatorQueryPosition;
import org.campagnelab.goby.baseinfo.StatAccumulatorReadMappingQuality;
import org.campagnelab.goby.baseinfo.StatAccumulatorTargetAlignedLength;
import org.campagnelab.goby.compression.MessageChunksWriter;
import org.campagnelab.goby.compression.SequenceBaseInfoCollectionHandler;
import org.campagnelab.goby.util.FileExtensionHelper;
import org.campagnelab.goby.util.commits.CommitPropertyHelper;

public class SequenceBaseInformationWriter
implements Closeable {
    private final BaseInformationRecords.BaseInformationCollection.Builder collectionBuilder;
    private String basename;
    private final MessageChunksWriter messageChunkWriter;
    private long recordIndex;
    public List<StatAccumulator> ACCUMULATORS = new ArrayList<StatAccumulator>();
    private Properties customProperties;

    public SequenceBaseInformationWriter(String basename) throws FileNotFoundException {
        this(new FileOutputStream(BasenameUtils.getBasename(basename, FileExtensionHelper.COMPACT_SEQUENCE_BASE_INFORMATION) + ".sbi"));
        this.basename = BasenameUtils.getBasename(basename, FileExtensionHelper.COMPACT_SEQUENCE_BASE_INFORMATION);
    }

    public SequenceBaseInformationWriter(OutputStream output) {
        this.ACCUMULATORS.add(new ConstantAccumulator("stats.genomicContextSize", baseInformation -> Float.valueOf(baseInformation.getGenomicSequenceContext().length())));
        this.ACCUMULATORS.add(new StatAccumulatorReadMappingQuality());
        this.ACCUMULATORS.add(new StatAccumulatorNumVariationsInRead());
        this.ACCUMULATORS.add(new StatAccumulatorBaseQuality());
        this.ACCUMULATORS.add(new StatAccumulatorInsertSizes());
        this.ACCUMULATORS.add(new StatAccumulatorDistancesToReadVariations());
        this.ACCUMULATORS.add(new StatAccumulatorTargetAlignedLength());
        this.ACCUMULATORS.add(new StatAccumulatorQueryAlignedLength());
        this.ACCUMULATORS.add(new StatAccumulatorQueryPosition());
        this.ACCUMULATORS.add(new StatAccumulatorPairFlags());
        this.ACCUMULATORS.add(new StatAccumulatorDistanceToStartOfRead());
        this.ACCUMULATORS.add(new StatAccumulatorDistanceToEndOfRead());
        this.ACCUMULATORS.add(new CommitPropertiesStatAccumulator("goby-framework"));
        this.ACCUMULATORS.add(new CommitPropertiesStatAccumulator("variation-analysis"));
        this.customProperties = new Properties();
        this.collectionBuilder = BaseInformationRecords.BaseInformationCollection.newBuilder();
        this.messageChunkWriter = new MessageChunksWriter(output);
        this.messageChunkWriter.setParser(new SequenceBaseInfoCollectionHandler());
        this.recordIndex = 0L;
    }

    @Override
    public void close() throws IOException {
        this.messageChunkWriter.close(this.collectionBuilder);
        Properties p = this.getCustomProperties();
        for (StatAccumulator accumulator : this.ACCUMULATORS) {
            accumulator.setProperties(p);
        }
        SequenceBaseInformationWriter.writeProperties(this.basename, this.recordIndex, p);
    }

    public void setCustomProperties(Properties customProperties) {
        if (customProperties != null) {
            this.customProperties = customProperties;
        }
    }

    public void addCustomProperties(String key, String value) {
        this.customProperties.setProperty(key, value);
    }

    public Properties getCustomProperties() {
        return this.customProperties;
    }

    public static void writeProperties(String basename, List<Properties> properties) throws FileNotFoundException {
        FileOutputStream out = new FileOutputStream(basename + ".sbip");
        ArrayList<StatAccumulator> accumulators = new ArrayList<StatAccumulator>();
        accumulators.add(new ConstantAccumulator("stats.genomicContextSize", baseInformation -> Float.valueOf(baseInformation.getGenomicSequenceContext().length())));
        accumulators.add(new StatAccumulatorBaseQuality());
        accumulators.add(new StatAccumulatorReadMappingQuality());
        accumulators.add(new StatAccumulatorNumVariationsInRead());
        accumulators.add(new StatAccumulatorDistancesToReadVariations());
        accumulators.add(new StatAccumulatorInsertSizes());
        accumulators.add(new StatAccumulatorTargetAlignedLength());
        accumulators.add(new StatAccumulatorQueryAlignedLength());
        accumulators.add(new StatAccumulatorQueryPosition());
        accumulators.add(new StatAccumulatorPairFlags());
        accumulators.add(new StatAccumulatorDistanceToStartOfRead());
        accumulators.add(new StatAccumulatorDistanceToEndOfRead());
        accumulators.add(new CommitPropertiesStatAccumulator("goby-framework"));
        accumulators.add(new CommitPropertiesStatAccumulator("variation-analysis"));
        long numTotal = 0L;
        for (Properties p : properties) {
            for (StatAccumulator accumulator : accumulators) {
                accumulator.mergeWith(p);
            }
            numTotal += Long.parseLong(p.get("numRecords").toString());
        }
        Properties merged = new Properties();
        if (properties.size() >= 1) {
            merged.putAll((Map<?, ?>)properties.get(0));
        }
        merged.setProperty("numRecords", Long.toString(numTotal));
        merged.setProperty("goby.version", VersionUtils.getImplementationVersion(SequenceBaseInformationWriter.class));
        for (StatAccumulator accumulator : accumulators) {
            accumulator.setProperties(merged);
        }
        CommitPropertyHelper.appendCommitInfo(SequenceBaseInformationWriter.class, "/GOBY_COMMIT.properties", merged);
        merged.save(out, basename);
        IOUtils.closeQuietly((OutputStream)out);
    }

    public static void writeProperties(String basename, long numberOfRecords) throws FileNotFoundException {
        Properties p = new Properties();
        SequenceBaseInformationWriter.writeProperties(basename, numberOfRecords, p);
    }

    private static void writeProperties(String basename, long numberOfRecords, Properties p) throws FileNotFoundException {
        p.setProperty("numRecords", Long.toString(numberOfRecords));
        ArrayList<Properties> lp = new ArrayList<Properties>();
        lp.add(p);
        SequenceBaseInformationWriter.writeProperties(basename, lp);
    }

    public synchronized void appendEntry(BaseInformationRecords.BaseInformation baseInfo) throws IOException {
        this.collectionBuilder.addRecords(baseInfo);
        for (StatAccumulator accumulator : this.ACCUMULATORS) {
            accumulator.observe(baseInfo);
        }
        this.messageChunkWriter.writeAsNeeded(this.collectionBuilder);
        ++this.recordIndex;
    }

    public void setNumEntriesPerChunk(int numEntriesPerChunk) {
        this.messageChunkWriter.setNumEntriesPerChunk(numEntriesPerChunk);
    }

    public synchronized void printStats(PrintStream out) {
        this.messageChunkWriter.printStats(out);
        out.println("Number of bytes/baseInformation record " + (double)this.messageChunkWriter.getTotalBytesWritten() / (double)this.recordIndex);
    }
}

