/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments.filters;

import edu.cornell.med.icb.identifier.IndexedIdentifier;
import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ShortMap;
import it.unimi.dsi.fastutil.ints.Int2ShortOpenHashMap;
import org.campagnelab.goby.alignments.AlignmentReader;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.filters.AbstractAlignmentEntryFilter;

public class BestScoreAmbiguityAlignmentFilter
extends AbstractAlignmentEntryFilter {
    private final Int2FloatMap indexToBestScore = new Int2FloatOpenHashMap();
    private final Int2ShortMap indexToCountAtBestScore;
    private final int k;
    private int shouldWrite;
    private int willSkip;
    private final int minQueryIndex;

    public int getShouldWrite() {
        return this.shouldWrite;
    }

    public BestScoreAmbiguityAlignmentFilter(int k, int maxNumberOfReads, int minQueryIndex) {
        this.indexToBestScore.defaultReturnValue(Float.MIN_VALUE);
        this.indexToCountAtBestScore = new Int2ShortOpenHashMap();
        this.indexToCountAtBestScore.defaultReturnValue((short)0);
        this.k = k;
        this.minQueryIndex = minQueryIndex;
    }

    public void setHeader(AlignmentReader reader) {
    }

    @Override
    public void setTargetIdentifiers(IndexedIdentifier targets) {
    }

    @Override
    public void inspectEntry(Alignments.AlignmentEntry entry) {
        int index = entry.getQueryIndex();
        float score = entry.getScore();
        float previousScore = this.indexToBestScore.get(index);
        if (previousScore == score) {
            short newValue = (short)(this.indexToCountAtBestScore.get(index) + 1);
            this.indexToCountAtBestScore.put(index, newValue);
        } else if (previousScore < score) {
            this.indexToBestScore.put(index, score);
            this.indexToCountAtBestScore.put(index, (short)1);
        }
    }

    @Override
    public boolean shouldRetainEntry(Alignments.AlignmentEntry entry) {
        int index = entry.getQueryIndex();
        float score = entry.getScore();
        float keepHighestScore = this.indexToBestScore.get(index);
        if (keepHighestScore == Float.MIN_VALUE) {
            return false;
        }
        if (keepHighestScore == score) {
            short count = this.indexToCountAtBestScore.get(index);
            return count <= this.k;
        }
        return false;
    }

    @Override
    public synchronized void postProcessing() {
    }

    public int getWillSkip() {
        return this.willSkip;
    }
}

