/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import edu.cornell.med.icb.identifier.IndexedIdentifier;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.campagnelab.goby.alignments.AlignmentReader;
import org.campagnelab.goby.alignments.AlignmentTooManyHitsReader;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.DefaultAlignmentReaderFactory;
import org.campagnelab.goby.alignments.ReadOriginInfo;
import org.campagnelab.goby.alignments.ReferenceLocation;
import org.campagnelab.goby.util.dynoptions.DynamicOptionClient;
import org.campagnelab.goby.util.dynoptions.RegisterThis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonAmbiguousAlignmentReader
implements AlignmentReader {
    private static final Logger LOG = LoggerFactory.getLogger(NonAmbiguousAlignmentReader.class);
    @RegisterThis
    public static final DynamicOptionClient doc = new DynamicOptionClient(NonAmbiguousAlignmentReader.class, "ambiguity-threshold: integer, maximum number of locations (inclusive) a read can match in the genome to be loaded:1");
    private Alignments.AlignmentEntry possibleEntry;
    private boolean allQueriesHaveAmbiguity = false;
    private int maxLocations = 1;
    private final AlignmentReader delegate;
    int numQueries;
    private BitSet ambiguousQueryIndices;

    public void setMaxLocations(int maxLocations) {
        this.maxLocations = maxLocations;
    }

    @Override
    public boolean isSorted() {
        return this.delegate.isSorted();
    }

    @Override
    public boolean isIndexed() {
        return this.delegate.isIndexed();
    }

    @Override
    public String basename() {
        return this.delegate.basename();
    }

    public NonAmbiguousAlignmentReader(String basename, int startReferenceIndex, int startPosition, int endReferenceIndex, int endPosition) throws IOException {
        DefaultAlignmentReaderFactory factory = new DefaultAlignmentReaderFactory();
        this.delegate = factory.createReader(basename, startReferenceIndex, startPosition, endReferenceIndex, endPosition);
        this.initialize(basename);
    }

    private void initialize(String basename) throws IOException {
        this.maxLocations = NonAmbiguousAlignmentReader.doc().getInteger("ambiguity-threshold");
        this.delegate.readHeader();
        if (!this.delegate.hasAmbiguity()) {
            LOG.debug("Alignment does not have ambiguity field, using TMH file.");
            this.readTmh(basename);
            this.allQueriesHaveAmbiguity = false;
        } else {
            LOG.debug("All alignment entries have an ambiguity field.");
            this.allQueriesHaveAmbiguity = true;
        }
    }

    public static DynamicOptionClient doc() {
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTmh(String basename) throws IOException {
        assert (!this.delegate.hasAmbiguity()) : "This method must never be called when all entries have the ambiguity field";
        LOG.debug("start reading TMH for " + basename);
        ProgressLogger pg = new ProgressLogger(LOG);
        try (AlignmentTooManyHitsReader tmh = new AlignmentTooManyHitsReader(basename);){
            LOG.debug("finished loading TMH for " + basename);
            this.numQueries = tmh.getQueryIndices().size();
            this.ambiguousQueryIndices = new BitSet(this.numQueries);
            pg.expectedUpdates = tmh.getQueryIndices().size();
            pg.info = "processed %d items";
            pg.start((CharSequence)("start reading TMH for " + basename));
            for (int i = 0; i < this.numQueries; ++i) {
                if (tmh.isQueryAmbiguous(i)) {
                    this.ambiguousQueryIndices.set(i);
                }
                pg.lightUpdate();
            }
            pg.stop((CharSequence)("done reading TMH for " + basename));
        }
    }

    public NonAmbiguousAlignmentReader(long startOffset, long endOffset, String basename) throws IOException {
        DefaultAlignmentReaderFactory factory = new DefaultAlignmentReaderFactory();
        this.delegate = factory.createReader(basename, startOffset, endOffset);
        this.initialize(basename);
    }

    public NonAmbiguousAlignmentReader(String basename) throws IOException {
        DefaultAlignmentReaderFactory factory = new DefaultAlignmentReaderFactory();
        this.delegate = factory.createReader(basename);
        this.initialize(basename);
    }

    @Override
    public final boolean hasNext() {
        if (this.possibleEntry != null) {
            return true;
        }
        while (this.delegate.hasNext()) {
            this.possibleEntry = this.delegate.next();
            if (!(this.allQueriesHaveAmbiguity ? this.possibleEntry.getAmbiguity() <= this.maxLocations : !this.ambiguousQueryIndices.get(this.possibleEntry.getQueryIndex()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Alignments.AlignmentEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Alignments.AlignmentEntry returnValue = this.possibleEntry;
        this.possibleEntry = null;
        return returnValue;
    }

    @Override
    public Alignments.AlignmentEntry skipTo(int targetIndex, int position) throws IOException {
        if (this.possibleEntry != null) {
            if (this.possibleEntry.getTargetIndex() >= targetIndex && this.possibleEntry.getPosition() >= position) {
                return this.possibleEntry;
            }
            this.possibleEntry = null;
        }
        while (true) {
            this.possibleEntry = this.delegate.skipTo(targetIndex, position);
            if (this.possibleEntry == null) {
                return null;
            }
            if (this.allQueriesHaveAmbiguity) {
                if (this.possibleEntry.getAmbiguity() <= this.maxLocations) {
                    Alignments.AlignmentEntry tmp = this.possibleEntry;
                    this.possibleEntry = null;
                    return tmp;
                }
                this.possibleEntry = null;
                continue;
            }
            if (!this.ambiguousQueryIndices.get(this.possibleEntry.getQueryIndex())) {
                Alignments.AlignmentEntry tmp = this.possibleEntry;
                this.possibleEntry = null;
                return tmp;
            }
            this.possibleEntry = null;
        }
    }

    @Override
    public void reposition(int targetIndex, int position) throws IOException {
        this.delegate.reposition(targetIndex, position);
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public void readHeader() throws IOException {
        this.delegate.readHeader();
    }

    @Override
    public void readIndex() throws IOException {
        this.delegate.readIndex();
    }

    @Override
    public void close() {
        this.delegate.close();
        if (!this.allQueriesHaveAmbiguity) {
            this.ambiguousQueryIndices.clear();
        }
    }

    @Override
    public Iterator<Alignments.AlignmentEntry> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Properties getStatistics() {
        return this.delegate.getStatistics();
    }

    @Override
    public int getNumberOfAlignedReads() {
        return this.delegate.getNumberOfAlignedReads();
    }

    @Override
    public ObjectList<ReferenceLocation> getLocations(int modulo) throws IOException {
        return this.delegate.getLocations(modulo);
    }

    @Override
    public ReferenceLocation getMinLocation() throws IOException {
        return this.delegate.getMinLocation();
    }

    @Override
    public ReferenceLocation getMaxLocation() throws IOException {
        return this.delegate.getMaxLocation();
    }

    @Override
    public ObjectList<ReferenceLocation> getLocationsByBytes(int bytesPerSlice) throws IOException {
        return this.delegate.getLocationsByBytes(bytesPerSlice);
    }

    @Override
    public boolean isQueryLengthStoredInEntries() {
        return this.delegate.isQueryLengthStoredInEntries();
    }

    @Override
    public String getAlignerName() {
        return this.delegate.getAlignerName();
    }

    @Override
    public String getAlignerVersion() {
        return this.delegate.getAlignerVersion();
    }

    @Override
    public int getSmallestSplitQueryIndex() {
        return this.delegate.getSmallestSplitQueryIndex();
    }

    @Override
    public int getLargestSplitQueryIndex() {
        return this.delegate.getLargestSplitQueryIndex();
    }

    @Override
    public IndexedIdentifier getTargetIdentifiers() {
        return this.delegate.getTargetIdentifiers();
    }

    @Override
    public int[] getTargetLength() {
        return this.delegate.getTargetLength();
    }

    @Override
    public int getNumberOfTargets() {
        return this.delegate.getNumberOfTargets();
    }

    @Override
    public int getNumberOfQueries() {
        return this.delegate.getNumberOfQueries();
    }

    @Override
    public boolean isConstantQueryLengths() {
        return this.delegate.isConstantQueryLengths();
    }

    @Override
    public int getConstantQueryLength() {
        return this.delegate.getConstantQueryLength();
    }

    @Override
    public IndexedIdentifier getQueryIdentifiers() {
        return this.delegate.getQueryIdentifiers();
    }

    @Override
    public long getStartByteOffset(int startReferenceIndex, int startPosition) {
        return this.delegate.getStartByteOffset(startReferenceIndex, startPosition);
    }

    @Override
    public boolean getQueryIndicesWerePermuted() {
        return this.delegate.getQueryIndicesWerePermuted();
    }

    @Override
    public boolean hasQueryIndexOccurrences() {
        return this.delegate.hasQueryIndexOccurrences();
    }

    @Override
    public boolean hasAmbiguity() {
        return this.delegate.hasAmbiguity();
    }

    @Override
    public long getEndByteOffset(int startReferenceIndex, int startPosition, int endReferenceIndex, int endPosition) {
        return this.delegate.getEndByteOffset(startReferenceIndex, startPosition, endReferenceIndex, endPosition);
    }

    @Override
    public ReadOriginInfo getReadOriginInfo() {
        return this.delegate.getReadOriginInfo();
    }
}

