/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.FCS;

import FCSalyzer.FCS.FCS_gate;
import FCSalyzer.FCS.FCS_region;
import java.awt.Color;
import java.util.ArrayList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import staticStuff.staticMethods;

public class FCS_RegionGatesHolder {
    private final ArrayList<FCS_region> regions = new ArrayList();
    private final ArrayList<FCS_gate> gates = new ArrayList();
    private final ArrayList<FCS_gate> validGates = new ArrayList();
    public static final String XML_name = "Regions_and_Gates";
    private static final int black = Color.BLACK.getRGB();

    public void add(FCS_region paramRegion) {
        String name = paramRegion.getName();
        if (name == null || name.isEmpty() || this.nameExists(name)) {
            int n = this.regions.size() - 1;
            while (this.nameExists(name = "R" + ++n)) {
            }
            paramRegion.setName(name);
        }
        this.regions.add(paramRegion);
        this.updateGates(null);
    }

    public void deleteGate(FCS_gate gate) {
        this.gates.remove(gate);
        this.updateGates(null);
    }

    public boolean nameExists(String paramName) {
        paramName = paramName.toLowerCase();
        for (FCS_region paramRegion : this.regions) {
            if (!paramRegion.getName().toLowerCase().equals(paramName)) continue;
            return true;
        }
        for (FCS_gate paramGate : this.gates) {
            if (!paramGate.getName().toLowerCase().equals(paramName)) continue;
            return true;
        }
        return false;
    }

    public void add(FCS_gate paramGate) {
        String name = paramGate.getName();
        if (name == null || name.isEmpty() || this.nameExists(name)) {
            int n = this.regions.size() - 1;
            while (this.nameExists(name = "G" + ++n)) {
            }
            paramGate.setName(name);
        }
        this.gates.add(paramGate);
        this.updateGates(null);
    }

    public ArrayList<FCS_region> getRegions() {
        return (ArrayList)this.regions.clone();
    }

    public FCS_region getRegion(int index) {
        return this.regions.get(index);
    }

    public ArrayList<FCS_gate> getGates() {
        return (ArrayList)this.gates.clone();
    }

    public FCS_gate getGate(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.gates.size()) {
            return null;
        }
        return this.gates.get(index);
    }

    public int getRegionsCount() {
        return this.regions.size();
    }

    public int getGatesCount() {
        return this.gates.size();
    }

    public ArrayList<Integer> regionsContaining(double[] event) {
        ArrayList<Integer> result = new ArrayList<Integer>(0);
        int m = this.getRegionsCount();
        for (int i = 0; i < m; ++i) {
            if (!this.regions.get(i).contains(event)) continue;
            result.add(i);
        }
        return result;
    }

    public ArrayList<Integer> gatesContaining(double[] event) {
        ArrayList<Integer> result = new ArrayList<Integer>(0);
        for (FCS_gate currentGate : this.validGates) {
            if (!currentGate.contains(event)) continue;
            result.add(this.gates.indexOf(currentGate));
        }
        return result;
    }

    public int colorFirstGateContaining(double[] event) {
        for (int i = 0; i < this.validGates.size(); ++i) {
            FCS_gate currGate = this.validGates.get(i);
            if (!currGate.contains(event)) continue;
            return currGate.getColor();
        }
        return black;
    }

    public void moveGate(int gateIndex, int step) {
        FCS_gate toMove = this.gates.remove(gateIndex);
        this.gates.add(gateIndex + step, toMove);
        ArrayList<FCS_gate> newValid = new ArrayList<FCS_gate>();
        for (int i = 0; i < this.gates.size(); ++i) {
            FCS_gate currGate = this.gates.get(i);
            if (!this.validGates.contains(currGate)) continue;
            newValid.add(currGate);
        }
        this.validGates.clear();
        this.validGates.addAll(newValid);
    }

    public int getGatesColor(int paramGate) {
        return this.gates.get(paramGate).getColor();
    }

    public void toXML(Node parent) {
        Node r = staticMethods.addNode(parent, XML_name, null);
        for (FCS_region currentRegion : this.regions) {
            currentRegion.toXML(r);
        }
        for (FCS_gate currentGate : this.gates) {
            currentGate.toXML(r);
        }
    }

    public static FCS_RegionGatesHolder fromXML(Node sourceNode) {
        Node current;
        int i;
        if (sourceNode == null) {
            return null;
        }
        FCS_RegionGatesHolder returnData = new FCS_RegionGatesHolder();
        NodeList nL = sourceNode.getChildNodes();
        for (i = 0; i < nL.getLength(); ++i) {
            FCS_region newRegion;
            current = nL.item(i);
            if (!current.getNodeName().equals("Region") || (newRegion = FCS_region.fromXML(current, returnData)) == null) continue;
            returnData.regions.add(newRegion);
        }
        for (i = 0; i < nL.getLength(); ++i) {
            FCS_gate newGate;
            current = nL.item(i);
            if (!current.getNodeName().equals("Gate") || (newGate = FCS_gate.fromXML(current, returnData)) == null) continue;
            returnData.gates.add(newGate);
        }
        returnData.updateGates(null);
        return returnData;
    }

    public void deleteRegion(FCS_region currRegion) {
        this.regions.remove(currRegion);
        this.updateGates(null);
        this.setValidGatesList();
    }

    public Integer indexOf(FCS_region theRegion) {
        return this.regions.indexOf(theRegion);
    }

    public Integer indexOf(FCS_gate theGate) {
        return this.gates.indexOf(theGate);
    }

    public FCS_gate getGate(String currentString) {
        for (FCS_gate currentGate : this.validGates) {
            if (!currentGate.getLowerCaseName().equals(currentString.toLowerCase())) continue;
            return currentGate;
        }
        return null;
    }

    public FCS_region getRegion(String currentSplit) {
        for (FCS_region currentRegion : this.regions) {
            if (!currentRegion.getLowerCaseName().equals(currentSplit.toLowerCase())) continue;
            return currentRegion;
        }
        return null;
    }

    public void updateGates(FCS_gate excluded) {
        for (FCS_gate currentGate : this.gates) {
            if (currentGate == excluded) continue;
            currentGate.updateValidity();
        }
        this.setValidGatesList();
    }

    public void nameChanged(String oldName, String newName) {
        for (FCS_gate currentGate : this.gates) {
            currentGate.changeNameInStrategy(oldName, newName);
        }
        this.setValidGatesList();
    }

    private void setValidGatesList() {
        this.validGates.clear();
        for (FCS_gate currentGate : this.gates) {
            if (!currentGate.isValid()) continue;
            this.validGates.add(currentGate);
        }
    }

    public String[] getGateDescription() {
        ArrayList<FCS_gate> theGates = this.getGates();
        String[] gateDesc = new String[theGates.size()];
        for (int i = 0; i < gateDesc.length; ++i) {
            FCS_gate currGate = theGates.get(i);
            gateDesc[i] = currGate.isValid() ? "<html>" : "<html><font color=\"#AAAAAA\"><i>";
            gateDesc[i] = gateDesc[i] + currGate.getName() + " = " + currGate.getStrategy();
            gateDesc[i] = currGate.isValid() ? gateDesc[i] + "</html>" : gateDesc[i] + "</color></i></html>";
        }
        return gateDesc;
    }

    public boolean hasValidGates() {
        return !this.validGates.isEmpty();
    }
}

