/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.Hashtable;
import java.util.Stack;
import org.python.compiler.ArgListCompiler;
import org.python.compiler.CompilationContext;
import org.python.compiler.Future;
import org.python.compiler.ScopeConstants;
import org.python.compiler.ScopeInfo;
import org.python.core.parser;
import org.python.parser.SimpleNode;
import org.python.parser.Visitor;
import org.python.parser.ast.ClassDef;
import org.python.parser.ast.Exec;
import org.python.parser.ast.Expression;
import org.python.parser.ast.FunctionDef;
import org.python.parser.ast.Global;
import org.python.parser.ast.Import;
import org.python.parser.ast.ImportFrom;
import org.python.parser.ast.Interactive;
import org.python.parser.ast.Lambda;
import org.python.parser.ast.ListComp;
import org.python.parser.ast.Module;
import org.python.parser.ast.Name;
import org.python.parser.ast.Return;
import org.python.parser.ast.Yield;
import org.python.parser.ast.exprType;
import org.python.parser.ast.stmtType;

public class ScopesCompiler
extends Visitor
implements ScopeConstants {
    private CompilationContext code_compiler;
    private Stack scopes;
    private ScopeInfo cur = null;
    private Hashtable nodeScopes;
    private int level = 0;
    private int func_level = 0;

    public ScopesCompiler(CompilationContext compilationContext, Hashtable hashtable) {
        this.code_compiler = compilationContext;
        this.nodeScopes = hashtable;
        this.scopes = new Stack();
    }

    public void beginScope(String string2, int n, SimpleNode simpleNode, ArgListCompiler argListCompiler) {
        if (this.cur != null) {
            this.scopes.push(this.cur);
        }
        if (n == 1) {
            ++this.func_level;
        }
        this.cur = new ScopeInfo(string2, simpleNode, this.level++, n, this.func_level, argListCompiler);
        this.nodeScopes.put(simpleNode, this.cur);
    }

    public void endScope() throws Exception {
        if (this.cur.kind == 1) {
            --this.func_level;
        }
        --this.level;
        ScopeInfo scopeInfo = !this.scopes.empty() ? (ScopeInfo)this.scopes.pop() : null;
        int n = 1;
        ScopeInfo scopeInfo2 = scopeInfo;
        int n2 = this.scopes.size() - 1;
        while (n2 >= 0 && scopeInfo2.kind == 2) {
            scopeInfo2 = (ScopeInfo)this.scopes.get(n2);
            --n2;
            ++n;
        }
        this.cur.cook(scopeInfo2, n, this.code_compiler);
        this.cur.dump();
        this.cur = scopeInfo;
    }

    public void parse(SimpleNode simpleNode) throws Exception {
        try {
            this.visit(simpleNode);
        }
        catch (Throwable throwable) {
            throw parser.fixParseError(null, throwable, this.code_compiler.getFilename());
        }
    }

    public Object visitInteractive(Interactive interactive) throws Exception {
        this.beginScope("<single-top>", 0, (SimpleNode)interactive, null);
        this.suite(interactive.body);
        this.endScope();
        return null;
    }

    public Object visitModule(Module module) throws Exception {
        this.beginScope("<file-top>", 0, (SimpleNode)module, null);
        this.suite(module.body);
        this.endScope();
        return null;
    }

    public Object visitExpression(Expression expression) throws Exception {
        this.beginScope("<eval-top>", 0, (SimpleNode)expression, null);
        this.visit((SimpleNode)new Return(expression.body));
        this.endScope();
        return null;
    }

    private void def(String string2) {
        this.cur.addBound(string2);
    }

    public Object visitFunctionDef(FunctionDef functionDef) throws Exception {
        int n;
        int n2;
        this.def(functionDef.name);
        ArgListCompiler argListCompiler = new ArgListCompiler();
        argListCompiler.visitArgs(functionDef.args);
        exprType[] exprTypeArray = argListCompiler.getDefaults();
        int n3 = exprTypeArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.visit((SimpleNode)exprTypeArray[n2]);
        }
        this.beginScope(functionDef.name, 1, (SimpleNode)functionDef, argListCompiler);
        n2 = argListCompiler.names.size();
        for (n = 0; n < n2; ++n) {
            this.cur.addParam((String)argListCompiler.names.elementAt(n));
        }
        for (n = 0; n < argListCompiler.init_code.size(); ++n) {
            this.visit((SimpleNode)((stmtType)argListCompiler.init_code.elementAt(n)));
        }
        this.cur.markFromParam();
        this.suite(functionDef.body);
        this.endScope();
        return null;
    }

    public Object visitLambda(Lambda lambda) throws Exception {
        int n;
        int n2;
        ArgListCompiler argListCompiler = new ArgListCompiler();
        argListCompiler.visitArgs(lambda.args);
        exprType[] exprTypeArray = argListCompiler.getDefaults();
        int n3 = exprTypeArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.visit((SimpleNode)exprTypeArray[n2]);
        }
        this.beginScope("<lambda>", 1, (SimpleNode)lambda, argListCompiler);
        n2 = argListCompiler.names.size();
        for (n = 0; n < n2; ++n) {
            this.cur.addParam((String)argListCompiler.names.elementAt(n));
        }
        for (n = 0; n < argListCompiler.init_code.size(); ++n) {
            this.visit((SimpleNode)((stmtType)argListCompiler.init_code.elementAt(n)));
        }
        this.cur.markFromParam();
        this.visit((SimpleNode)lambda.body);
        this.endScope();
        return null;
    }

    public void suite(stmtType[] stmtTypeArray) throws Exception {
        int n = stmtTypeArray.length;
        for (int i = 0; i < n; ++i) {
            this.visit((SimpleNode)stmtTypeArray[i]);
        }
    }

    public Object visitImport(Import import_) throws Exception {
        int n = import_.names.length;
        for (int i = 0; i < n; ++i) {
            if (import_.names[i].asname != null) {
                this.cur.addBound(import_.names[i].asname);
                continue;
            }
            String string2 = import_.names[i].name;
            if (string2.indexOf(46) > 0) {
                string2 = string2.substring(0, string2.indexOf(46));
            }
            this.cur.addBound(string2);
        }
        return null;
    }

    public Object visitImportFrom(ImportFrom importFrom) throws Exception {
        Future.checkFromFuture(importFrom);
        int n = importFrom.names.length;
        if (n == 0) {
            this.cur.from_import_star = true;
            return null;
        }
        for (int i = 0; i < n; ++i) {
            if (importFrom.names[i].asname != null) {
                this.cur.addBound(importFrom.names[i].asname);
                continue;
            }
            this.cur.addBound(importFrom.names[i].name);
        }
        return null;
    }

    public Object visitGlobal(Global global) throws Exception {
        int n = global.names.length;
        for (int i = 0; i < n; ++i) {
            String string2 = global.names[i];
            int n2 = this.cur.addGlobal(string2);
            if (n2 < 0) continue;
            if ((n2 & 8) != 0) {
                this.code_compiler.error("name '" + string2 + "' is local and global", true, (SimpleNode)global);
            }
            if ((n2 & 0x42) != 0) continue;
            String string3 = (n2 & 1) != 0 ? "assignment" : "use";
            this.code_compiler.error("name '" + string2 + "' declared global after " + string3, false, (SimpleNode)global);
        }
        return null;
    }

    public Object visitExec(Exec exec) throws Exception {
        this.cur.exec = true;
        if (exec.globals == null && exec.locals == null) {
            this.cur.unqual_exec = true;
        }
        this.traverse((SimpleNode)exec);
        return null;
    }

    public Object visitClassDef(ClassDef classDef) throws Exception {
        this.def(classDef.name);
        int n = classDef.bases.length;
        for (int i = 0; i < n; ++i) {
            this.visit((SimpleNode)classDef.bases[i]);
        }
        this.beginScope(classDef.name, 2, (SimpleNode)classDef, null);
        this.suite(classDef.body);
        this.endScope();
        return null;
    }

    public Object visitName(Name name) throws Exception {
        String string2 = name.id;
        if (name.ctx != 1) {
            if (string2.equals("__debug__")) {
                this.code_compiler.error("can not assign to __debug__", true, (SimpleNode)name);
            }
            this.cur.addBound(string2);
        } else {
            this.cur.addUsed(string2);
        }
        return null;
    }

    public Object visitListComp(ListComp listComp) throws Exception {
        String string2 = "_[" + ++this.cur.list_comprehension_count + "]";
        this.cur.addBound(string2);
        this.traverse((SimpleNode)listComp);
        return null;
    }

    public Object visitYield(Yield yield) throws Exception {
        this.cur.generator = true;
        ++this.cur.yield_count;
        this.traverse((SimpleNode)yield);
        return null;
    }
}

